/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.LogManagerProperties;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class DurationFilter
implements Filter {
    private final long records;
    private final long duration;
    private long count;
    private long peak;
    private long start;

    public DurationFilter() {
        this.records = DurationFilter.checkRecords(this.initLong(".records"));
        this.duration = DurationFilter.checkDuration(this.initLong(".duration"));
    }

    public DurationFilter(long records, long duration) {
        this.records = DurationFilter.checkRecords(records);
        this.duration = DurationFilter.checkDuration(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        long s2;
        long p2;
        long c2;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DurationFilter other = (DurationFilter)obj;
        if (this.records != other.records) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            c2 = this.count;
            p2 = this.peak;
            s2 = this.start;
        }
        durationFilter = other;
        synchronized (durationFilter) {
            if (c2 != other.count || p2 != other.peak || s2 != other.start) {
                return false;
            }
        }
        return true;
    }

    public boolean isIdle() {
        return this.test(0L, System.currentTimeMillis());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (int)(this.records ^ this.records >>> 32);
        hash = 89 * hash + (int)(this.duration ^ this.duration >>> 32);
        return hash;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.accept(record.getMillis());
    }

    public boolean isLoggable() {
        return this.test(this.records, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean loggable;
        boolean idle;
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            long millis = System.currentTimeMillis();
            idle = this.test(0L, millis);
            loggable = this.test(this.records, millis);
        }
        return this.getClass().getName() + "{records=" + this.records + ", duration=" + this.duration + ", idle=" + idle + ", loggable=" + loggable + '}';
    }

    protected DurationFilter clone() throws CloneNotSupportedException {
        DurationFilter clone = (DurationFilter)super.clone();
        clone.count = 0L;
        clone.peak = 0L;
        clone.start = 0L;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean test(long limit, long millis) {
        long s2;
        long c2;
        assert (limit >= 0L) : limit;
        DurationFilter durationFilter = this;
        synchronized (durationFilter) {
            c2 = this.count;
            s2 = this.start;
        }
        return c2 > 0L ? millis - s2 >= this.duration || c2 < limit : millis - s2 >= 0L || c2 == 0L;
    }

    private synchronized boolean accept(long millis) {
        boolean allow;
        if (this.count > 0L) {
            if (millis - this.peak > 0L) {
                this.peak = millis;
            }
            if (this.count != this.records) {
                ++this.count;
                allow = true;
            } else if (this.peak - this.start >= this.duration) {
                this.count = 1L;
                this.start = this.peak;
                allow = true;
            } else {
                this.count = -1L;
                this.start = this.peak + this.duration;
                allow = false;
            }
        } else if (millis - this.start >= 0L || this.count == 0L) {
            this.count = 1L;
            this.start = millis;
            this.peak = millis;
            allow = true;
        } else {
            allow = false;
        }
        return allow;
    }

    private long initLong(String suffix) {
        long result = 0L;
        String p2 = this.getClass().getName();
        String value = LogManagerProperties.fromLogManager(p2.concat(suffix));
        if (value != null && value.length() != 0) {
            if (this.isTimeEntry(suffix, value = value.trim())) {
                try {
                    result = LogManagerProperties.parseDurationToMillis(value);
                }
                catch (RuntimeException runtimeException) {
                }
                catch (Exception exception) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            if (result == 0L) {
                try {
                    result = 1L;
                    for (String s2 : DurationFilter.tokenizeLongs(value)) {
                        if (s2.endsWith("L") || s2.endsWith("l")) {
                            s2 = s2.substring(0, s2.length() - 1);
                        }
                        result = DurationFilter.multiplyExact(result, Long.parseLong(s2));
                    }
                }
                catch (RuntimeException ignore) {
                    result = Long.MIN_VALUE;
                }
            }
        } else {
            result = Long.MIN_VALUE;
        }
        return result;
    }

    private boolean isTimeEntry(String suffix, String value) {
        return (value.charAt(0) == 'P' || value.charAt(0) == 'p') && suffix.equals(".duration");
    }

    private static String[] tokenizeLongs(String value) {
        String[] e2;
        int i2 = value.indexOf(42);
        if (i2 > -1 && (e2 = value.split("\\s*\\*\\s*")).length != 0) {
            if (i2 == 0 || value.charAt(value.length() - 1) == '*') {
                throw new NumberFormatException(value);
            }
            if (e2.length == 1) {
                throw new NumberFormatException(e2[0]);
            }
        } else {
            e2 = new String[]{value};
        }
        return e2;
    }

    private static long multiplyExact(long x2, long y2) {
        long r2 = x2 * y2;
        if ((Math.abs(x2) | Math.abs(y2)) >>> 31 != 0L && (y2 != 0L && r2 / y2 != x2 || x2 == Long.MIN_VALUE && y2 == -1L)) {
            throw new ArithmeticException();
        }
        return r2;
    }

    private static long checkRecords(long records) {
        return records > 0L ? records : 1000L;
    }

    private static long checkDuration(long duration) {
        return duration > 0L ? duration : 900000L;
    }
}

