/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import java.util.ArrayList;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

class IMAPAddress
extends InternetAddress {
    private boolean group = false;
    private InternetAddress[] grouplist;
    private String groupname;
    private static final long serialVersionUID = -3835822029483122232L;

    IMAPAddress(Response r2) throws ParsingException {
        r2.skipSpaces();
        if (r2.readByte() != 40) {
            throw new ParsingException("ADDRESS parse error");
        }
        this.encodedPersonal = r2.readString();
        r2.readString();
        String mb = r2.readString();
        String host = r2.readString();
        r2.skipSpaces();
        if (!r2.isNextNonSpace(')')) {
            throw new ParsingException("ADDRESS parse error");
        }
        if (host == null) {
            IMAPAddress a2;
            this.group = true;
            this.groupname = mb;
            if (this.groupname == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupname).append(':');
            ArrayList<IMAPAddress> v2 = new ArrayList<IMAPAddress>();
            while (r2.peekByte() != 41 && !(a2 = new IMAPAddress(r2)).isEndOfGroup()) {
                if (v2.size() != 0) {
                    sb.append(',');
                }
                sb.append(a2.toString());
                v2.add(a2);
            }
            sb.append(';');
            this.address = sb.toString();
            this.grouplist = v2.toArray(new IMAPAddress[v2.size()]);
        } else {
            this.address = mb == null || mb.length() == 0 ? host : (host.length() == 0 ? mb : mb + "@" + host);
        }
    }

    boolean isEndOfGroup() {
        return this.group && this.groupname == null;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        if (this.grouplist == null) {
            return null;
        }
        return (InternetAddress[])this.grouplist.clone();
    }
}

