/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPInputStream;
import com.sun.mail.imap.IMAPMultipartDataSource;
import com.sun.mail.imap.IMAPNestedMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchItem;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.imap.protocol.MODSEQ;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.RFC822SIZE;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.ReadableMime;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderClosedException;
import javax.mail.Header;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class IMAPMessage
extends MimeMessage
implements ReadableMime {
    protected BODYSTRUCTURE bs;
    protected ENVELOPE envelope;
    protected Map<String, Object> items;
    private Date receivedDate;
    private long size = -1L;
    private Boolean peek;
    private volatile long uid = -1L;
    private volatile long modseq = -1L;
    protected String sectionId;
    private String type;
    private String subject;
    private String description;
    private volatile boolean headersLoaded = false;
    private volatile boolean bodyLoaded = false;
    private Hashtable<String, String> loadedHeaders = new Hashtable(1);
    static final String EnvelopeCmd = "ENVELOPE INTERNALDATE RFC822.SIZE";

    protected IMAPMessage(IMAPFolder folder, int msgnum) {
        super(folder, msgnum);
        this.flags = null;
    }

    protected IMAPMessage(Session session) {
        super(session);
    }

    protected IMAPProtocol getProtocol() throws ProtocolException, FolderClosedException {
        ((IMAPFolder)this.folder).waitIfIdle();
        IMAPProtocol p2 = ((IMAPFolder)this.folder).protocol;
        if (p2 == null) {
            throw new FolderClosedException(this.folder);
        }
        return p2;
    }

    protected boolean isREV1() throws FolderClosedException {
        IMAPProtocol p2 = ((IMAPFolder)this.folder).protocol;
        if (p2 == null) {
            throw new FolderClosedException(this.folder);
        }
        return p2.isREV1();
    }

    protected Object getMessageCacheLock() {
        return ((IMAPFolder)this.folder).messageCacheLock;
    }

    protected int getSequenceNumber() {
        return ((IMAPFolder)this.folder).messageCache.seqnumOf(this.getMessageNumber());
    }

    @Override
    protected void setMessageNumber(int msgnum) {
        super.setMessageNumber(msgnum);
    }

    protected long getUID() {
        return this.uid;
    }

    protected void setUID(long uid) {
        this.uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getModSeq() throws MessagingException {
        if (this.modseq != -1L) {
            return this.modseq;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                MODSEQ ms = p2.fetchMODSEQ(this.getSequenceNumber());
                if (ms != null) {
                    this.modseq = ms.modseq;
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        return this.modseq;
    }

    long _getModSeq() {
        return this.modseq;
    }

    void setModSeq(long modseq) {
        this.modseq = modseq;
    }

    @Override
    protected void setExpunged(boolean set) {
        super.setExpunged(set);
    }

    protected void checkExpunged() throws MessageRemovedException {
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceCheckExpunged() throws MessageRemovedException, FolderClosedException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                this.getProtocol().noop();
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    protected int getFetchBlockSize() {
        return ((IMAPStore)this.folder.getStore()).getFetchBlockSize();
    }

    protected boolean ignoreBodyStructureSize() {
        return ((IMAPStore)this.folder.getStore()).ignoreBodyStructureSize();
    }

    @Override
    public Address[] getFrom() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getFrom();
        }
        this.loadEnvelope();
        InternetAddress[] a2 = this.envelope.from;
        if (a2 == null || a2.length == 0) {
            a2 = this.envelope.sender;
        }
        return this.aaclone(a2);
    }

    @Override
    public void setFrom(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public void addFrom(Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Address getSender() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getSender();
        }
        this.loadEnvelope();
        if (this.envelope.sender != null && this.envelope.sender.length > 0) {
            return this.envelope.sender[0];
        }
        return null;
    }

    @Override
    public void setSender(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Address[] getRecipients(Message.RecipientType type) throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getRecipients(type);
        }
        this.loadEnvelope();
        if (type == Message.RecipientType.TO) {
            return this.aaclone(this.envelope.to);
        }
        if (type == Message.RecipientType.CC) {
            return this.aaclone(this.envelope.cc);
        }
        if (type == Message.RecipientType.BCC) {
            return this.aaclone(this.envelope.bcc);
        }
        return super.getRecipients(type);
    }

    @Override
    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Address[] getReplyTo() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getReplyTo();
        }
        this.loadEnvelope();
        if (this.envelope.replyTo == null || this.envelope.replyTo.length == 0) {
            return this.getFrom();
        }
        return this.aaclone(this.envelope.replyTo);
    }

    @Override
    public void setReplyTo(Address[] addresses) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public String getSubject() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getSubject();
        }
        if (this.subject != null) {
            return this.subject;
        }
        this.loadEnvelope();
        if (this.envelope.subject == null) {
            return null;
        }
        try {
            this.subject = MimeUtility.decodeText(MimeUtility.unfold(this.envelope.subject));
        }
        catch (UnsupportedEncodingException ex2) {
            this.subject = this.envelope.subject;
        }
        return this.subject;
    }

    @Override
    public void setSubject(String subject, String charset) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Date getSentDate() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getSentDate();
        }
        this.loadEnvelope();
        if (this.envelope.date == null) {
            return null;
        }
        return new Date(this.envelope.date.getTime());
    }

    @Override
    public void setSentDate(Date d2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Date getReceivedDate() throws MessagingException {
        this.checkExpunged();
        if (this.receivedDate == null) {
            this.loadEnvelope();
        }
        if (this.receivedDate == null) {
            return null;
        }
        return new Date(this.receivedDate.getTime());
    }

    @Override
    public int getSize() throws MessagingException {
        this.checkExpunged();
        if (this.size == -1L) {
            this.loadEnvelope();
        }
        if (this.size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.size;
    }

    public long getSizeLong() throws MessagingException {
        this.checkExpunged();
        if (this.size == -1L) {
            this.loadEnvelope();
        }
        return this.size;
    }

    @Override
    public int getLineCount() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.lines;
    }

    @Override
    public String[] getContentLanguage() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getContentLanguage();
        }
        this.loadBODYSTRUCTURE();
        if (this.bs.language != null) {
            return (String[])this.bs.language.clone();
        }
        return null;
    }

    @Override
    public void setContentLanguage(String[] languages) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getInReplyTo() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getHeader("In-Reply-To", " ");
        }
        this.loadEnvelope();
        return this.envelope.inReplyTo;
    }

    @Override
    public synchronized String getContentType() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getContentType();
        }
        if (this.type == null) {
            this.loadBODYSTRUCTURE();
            ContentType ct2 = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
            this.type = ct2.toString();
        }
        return this.type;
    }

    @Override
    public String getDisposition() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getDisposition();
        }
        this.loadBODYSTRUCTURE();
        return this.bs.disposition;
    }

    @Override
    public void setDisposition(String disposition) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public String getEncoding() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getEncoding();
        }
        this.loadBODYSTRUCTURE();
        return this.bs.encoding;
    }

    @Override
    public String getContentID() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getContentID();
        }
        this.loadBODYSTRUCTURE();
        return this.bs.id;
    }

    @Override
    public void setContentID(String cid) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public String getContentMD5() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getContentMD5();
        }
        this.loadBODYSTRUCTURE();
        return this.bs.md5;
    }

    @Override
    public void setContentMD5(String md5) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public String getDescription() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getDescription();
        }
        if (this.description != null) {
            return this.description;
        }
        this.loadBODYSTRUCTURE();
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText(this.bs.description);
        }
        catch (UnsupportedEncodingException ex2) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    @Override
    public void setDescription(String description, String charset) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public String getMessageID() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getMessageID();
        }
        this.loadEnvelope();
        return this.envelope.messageId;
    }

    @Override
    public String getFileName() throws MessagingException {
        this.checkExpunged();
        if (this.bodyLoaded) {
            return super.getFileName();
        }
        String filename = null;
        this.loadBODYSTRUCTURE();
        if (this.bs.dParams != null) {
            filename = this.bs.dParams.get("filename");
        }
        if (filename == null && this.bs.cParams != null) {
            filename = this.bs.cParams.get("name");
        }
        return filename;
    }

    @Override
    public void setFileName(String filename) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream getContentStream() throws MessagingException {
        if (this.bodyLoaded) {
            return super.getContentStream();
        }
        ByteArrayInputStream is2 = null;
        boolean pk = this.getPeek();
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                if (p2.isREV1() && this.getFetchBlockSize() != -1) {
                    return new IMAPInputStream(this, this.toSection("TEXT"), this.bs != null && !this.ignoreBodyStructureSize() ? this.bs.size : -1, pk);
                }
                if (p2.isREV1()) {
                    BODY b2 = pk ? p2.peekBody(this.getSequenceNumber(), this.toSection("TEXT")) : p2.fetchBody(this.getSequenceNumber(), this.toSection("TEXT"));
                    if (b2 != null) {
                        is2 = b2.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rd = p2.fetchRFC822(this.getSequenceNumber(), "TEXT");
                    if (rd != null) {
                        is2 = rd.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (is2 == null) {
            this.forceCheckExpunged();
            is2 = new ByteArrayInputStream(new byte[0]);
        }
        return is2;
    }

    @Override
    public synchronized DataHandler getDataHandler() throws MessagingException {
        this.checkExpunged();
        if (this.dh == null && !this.bodyLoaded) {
            this.loadBODYSTRUCTURE();
            if (this.type == null) {
                ContentType ct2 = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
                this.type = ct2.toString();
            }
            if (this.bs.isMulti()) {
                this.dh = new DataHandler(new IMAPMultipartDataSource(this, this.bs.bodies, this.sectionId, this));
            } else if (this.bs.isNested() && this.isREV1() && this.bs.envelope != null) {
                this.dh = new DataHandler(new IMAPNestedMessage(this, this.bs.bodies[0], this.bs.envelope, this.sectionId == null ? "1" : this.sectionId + ".1"), this.type);
            }
        }
        return super.getDataHandler();
    }

    @Override
    public void setDataHandler(DataHandler content) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getMimeStream() throws MessagingException {
        ByteArrayInputStream is2 = null;
        boolean pk = this.getPeek();
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                if (p2.isREV1() && this.getFetchBlockSize() != -1) {
                    return new IMAPInputStream(this, this.sectionId, -1, pk);
                }
                if (p2.isREV1()) {
                    BODY b2 = pk ? p2.peekBody(this.getSequenceNumber(), this.sectionId) : p2.fetchBody(this.getSequenceNumber(), this.sectionId);
                    if (b2 != null) {
                        is2 = b2.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rd = p2.fetchRFC822(this.getSequenceNumber(), null);
                    if (rd != null) {
                        is2 = rd.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (is2 == null) {
            this.forceCheckExpunged();
            is2 = new ByteArrayInputStream(new byte[0]);
        }
        return is2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os) throws IOException, MessagingException {
        if (this.bodyLoaded) {
            super.writeTo(os);
            return;
        }
        try (InputStream is2 = this.getMimeStream();){
            int count;
            byte[] bytes = new byte[16384];
            while ((count = is2.read(bytes)) != -1) {
                os.write(bytes, 0, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getHeader(String name) throws MessagingException {
        this.checkExpunged();
        if (this.isHeaderLoaded(name)) {
            return this.headers.getHeader(name);
        }
        ByteArrayInputStream is2 = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                if (p2.isREV1()) {
                    BODY b2 = p2.peekBody(this.getSequenceNumber(), this.toSection("HEADER.FIELDS (" + name + ")"));
                    if (b2 != null) {
                        is2 = b2.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rd = p2.fetchRFC822(this.getSequenceNumber(), "HEADER.LINES (" + name + ")");
                    if (rd != null) {
                        is2 = rd.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (is2 == null) {
            return null;
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        this.headers.load(is2);
        this.setHeaderLoaded(name);
        return this.headers.getHeader(name);
    }

    @Override
    public String getHeader(String name, String delimiter) throws MessagingException {
        this.checkExpunged();
        if (this.getHeader(name) == null) {
            return null;
        }
        return this.headers.getHeader(name, delimiter);
    }

    @Override
    public void setHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public void addHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public void removeHeader(String name) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Enumeration<Header> getAllHeaders() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaders();
    }

    @Override
    public Enumeration<Header> getMatchingHeaders(String[] names) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaders(names);
    }

    @Override
    public Enumeration<Header> getNonMatchingHeaders(String[] names) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaders(names);
    }

    @Override
    public void addHeaderLine(String line) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    @Override
    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    @Override
    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaderLines(names);
    }

    @Override
    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(names);
    }

    @Override
    public synchronized Flags getFlags() throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.getFlags();
    }

    @Override
    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.isSet(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFlags(Flags flag, boolean set) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                p2.storeFlags(this.getSequenceNumber(), flag, set);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    public synchronized void setPeek(boolean peek) {
        this.peek = peek;
    }

    public synchronized boolean getPeek() {
        if (this.peek == null) {
            return ((IMAPStore)this.folder.getStore()).getPeek();
        }
        return this.peek;
    }

    public synchronized void invalidateHeaders() {
        this.headersLoaded = false;
        this.loadedHeaders.clear();
        this.headers = null;
        this.envelope = null;
        this.bs = null;
        this.receivedDate = null;
        this.size = -1L;
        this.type = null;
        this.subject = null;
        this.description = null;
        this.flags = null;
        this.content = null;
        this.contentStream = null;
        this.bodyLoaded = false;
    }

    protected boolean handleFetchItem(Item item, String[] hdrs, boolean allHeaders) throws MessagingException {
        if (item instanceof Flags) {
            this.flags = (Flags)((Object)item);
        } else if (item instanceof ENVELOPE) {
            this.envelope = (ENVELOPE)item;
        } else if (item instanceof INTERNALDATE) {
            this.receivedDate = ((INTERNALDATE)item).getDate();
        } else if (item instanceof RFC822SIZE) {
            this.size = ((RFC822SIZE)item).size;
        } else if (item instanceof MODSEQ) {
            this.modseq = ((MODSEQ)item).modseq;
        } else if (item instanceof BODYSTRUCTURE) {
            this.bs = (BODYSTRUCTURE)item;
        } else if (item instanceof UID) {
            UID u2 = (UID)item;
            this.uid = u2.uid;
            if (((IMAPFolder)this.folder).uidTable == null) {
                ((IMAPFolder)this.folder).uidTable = new Hashtable();
            }
            ((IMAPFolder)this.folder).uidTable.put(u2.uid, this);
        } else if (item instanceof RFC822DATA || item instanceof BODY) {
            boolean isHeader;
            ByteArrayInputStream headerStream;
            if (item instanceof RFC822DATA) {
                headerStream = ((RFC822DATA)item).getByteArrayInputStream();
                isHeader = ((RFC822DATA)item).isHeader();
            } else {
                headerStream = ((BODY)item).getByteArrayInputStream();
                isHeader = ((BODY)item).isHeader();
            }
            if (!isHeader) {
                try {
                    this.size = ((InputStream)headerStream).available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.parse(headerStream);
                this.bodyLoaded = true;
                this.setHeadersLoaded(true);
            } else {
                InternetHeaders h2 = new InternetHeaders();
                if (headerStream != null) {
                    h2.load(headerStream);
                }
                if (this.headers == null || allHeaders) {
                    this.headers = h2;
                } else {
                    Enumeration<Header> e2 = h2.getAllHeaders();
                    while (e2.hasMoreElements()) {
                        Header he2 = e2.nextElement();
                        if (this.isHeaderLoaded(he2.getName())) continue;
                        this.headers.addHeader(he2.getName(), he2.getValue());
                    }
                }
                if (allHeaders) {
                    this.setHeadersLoaded(true);
                } else {
                    for (int k2 = 0; k2 < hdrs.length; ++k2) {
                        this.setHeaderLoaded(hdrs[k2]);
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected void handleExtensionFetchItems(Map<String, Object> extensionItems) {
        if (extensionItems == null || extensionItems.isEmpty()) {
            return;
        }
        if (this.items == null) {
            this.items = new HashMap<String, Object>();
        }
        this.items.putAll(extensionItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object fetchItem(FetchItem fitem) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            Object robj = null;
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                int seqnum = this.getSequenceNumber();
                Response[] r2 = p2.fetch(seqnum, fitem.getName());
                for (int i2 = 0; i2 < r2.length; ++i2) {
                    Object o2;
                    if (r2[i2] == null || !(r2[i2] instanceof FetchResponse) || ((FetchResponse)r2[i2]).getNumber() != seqnum) continue;
                    FetchResponse f2 = (FetchResponse)r2[i2];
                    this.handleExtensionFetchItems(f2.getExtensionItems());
                    if (this.items == null || (o2 = this.items.get(fitem.getName())) == null) continue;
                    robj = o2;
                }
                p2.notifyResponseHandlers(r2);
                p2.handleResult(r2[r2.length - 1]);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
            return robj;
        }
    }

    public synchronized Object getItem(FetchItem fitem) throws MessagingException {
        Object item;
        Object object = item = this.items == null ? null : this.items.get(fitem.getName());
        if (item == null) {
            item = this.fetchItem(fitem);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadEnvelope() throws MessagingException {
        if (this.envelope != null) {
            return;
        }
        Response[] r2 = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                int seqnum = this.getSequenceNumber();
                r2 = p2.fetch(seqnum, EnvelopeCmd);
                for (int i2 = 0; i2 < r2.length; ++i2) {
                    if (r2[i2] == null || !(r2[i2] instanceof FetchResponse) || ((FetchResponse)r2[i2]).getNumber() != seqnum) continue;
                    FetchResponse f2 = (FetchResponse)r2[i2];
                    int count = f2.getItemCount();
                    for (int j2 = 0; j2 < count; ++j2) {
                        Item item = f2.getItem(j2);
                        if (item instanceof ENVELOPE) {
                            this.envelope = (ENVELOPE)item;
                            continue;
                        }
                        if (item instanceof INTERNALDATE) {
                            this.receivedDate = ((INTERNALDATE)item).getDate();
                            continue;
                        }
                        if (!(item instanceof RFC822SIZE)) continue;
                        this.size = ((RFC822SIZE)item).size;
                    }
                }
                p2.notifyResponseHandlers(r2);
                p2.handleResult(r2[r2.length - 1]);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (this.envelope == null) {
            throw new MessagingException("Failed to load IMAP envelope");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadBODYSTRUCTURE() throws MessagingException {
        if (this.bs != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                this.bs = p2.fetchBodyStructure(this.getSequenceNumber());
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
            if (this.bs == null) {
                this.forceCheckExpunged();
                throw new MessagingException("Unable to load BODYSTRUCTURE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadHeaders() throws MessagingException {
        if (this.headersLoaded) {
            return;
        }
        ByteArrayInputStream is2 = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                if (p2.isREV1()) {
                    BODY b2 = p2.peekBody(this.getSequenceNumber(), this.toSection("HEADER"));
                    if (b2 != null) {
                        is2 = b2.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rd = p2.fetchRFC822(this.getSequenceNumber(), "HEADER");
                    if (rd != null) {
                        is2 = rd.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        if (is2 == null) {
            throw new MessagingException("Cannot load header");
        }
        this.headers = new InternetHeaders(is2);
        this.headersLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadFlags() throws MessagingException {
        if (this.flags != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol p2 = this.getProtocol();
                this.checkExpunged();
                this.flags = p2.fetchFlags(this.getSequenceNumber());
                if (this.flags == null) {
                    this.flags = new Flags();
                }
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                this.forceCheckExpunged();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
    }

    private boolean areHeadersLoaded() {
        return this.headersLoaded;
    }

    private void setHeadersLoaded(boolean loaded) {
        this.headersLoaded = loaded;
    }

    private boolean isHeaderLoaded(String name) {
        if (this.headersLoaded) {
            return true;
        }
        return this.loadedHeaders.containsKey(name.toUpperCase(Locale.ENGLISH));
    }

    private void setHeaderLoaded(String name) {
        this.loadedHeaders.put(name.toUpperCase(Locale.ENGLISH), name);
    }

    private String toSection(String what) {
        if (this.sectionId == null) {
            return what;
        }
        return this.sectionId + "." + what;
    }

    private InternetAddress[] aaclone(InternetAddress[] aa2) {
        if (aa2 == null) {
            return null;
        }
        return (InternetAddress[])aa2.clone();
    }

    private Flags _getFlags() {
        return this.flags;
    }

    private ENVELOPE _getEnvelope() {
        return this.envelope;
    }

    private BODYSTRUCTURE _getBodyStructure() {
        return this.bs;
    }

    void _setFlags(Flags flags) {
        this.flags = flags;
    }

    Session _getSession() {
        return this.session;
    }

    public static class FetchProfileCondition
    implements Utility.Condition {
        private boolean needEnvelope = false;
        private boolean needFlags = false;
        private boolean needBodyStructure = false;
        private boolean needUID = false;
        private boolean needHeaders = false;
        private boolean needSize = false;
        private boolean needMessage = false;
        private boolean needRDate = false;
        private String[] hdrs = null;
        private Set<FetchItem> need = new HashSet<FetchItem>();

        public FetchProfileCondition(FetchProfile fp2, FetchItem[] fitems) {
            if (fp2.contains(FetchProfile.Item.ENVELOPE)) {
                this.needEnvelope = true;
            }
            if (fp2.contains(FetchProfile.Item.FLAGS)) {
                this.needFlags = true;
            }
            if (fp2.contains(FetchProfile.Item.CONTENT_INFO)) {
                this.needBodyStructure = true;
            }
            if (fp2.contains(FetchProfile.Item.SIZE)) {
                this.needSize = true;
            }
            if (fp2.contains(UIDFolder.FetchProfileItem.UID)) {
                this.needUID = true;
            }
            if (fp2.contains(IMAPFolder.FetchProfileItem.HEADERS)) {
                this.needHeaders = true;
            }
            if (fp2.contains(IMAPFolder.FetchProfileItem.SIZE)) {
                this.needSize = true;
            }
            if (fp2.contains(IMAPFolder.FetchProfileItem.MESSAGE)) {
                this.needMessage = true;
            }
            if (fp2.contains(IMAPFolder.FetchProfileItem.INTERNALDATE)) {
                this.needRDate = true;
            }
            this.hdrs = fp2.getHeaderNames();
            for (int i2 = 0; i2 < fitems.length; ++i2) {
                if (!fp2.contains(fitems[i2].getFetchProfileItem())) continue;
                this.need.add(fitems[i2]);
            }
        }

        @Override
        public boolean test(IMAPMessage m3) {
            if (this.needEnvelope && m3._getEnvelope() == null && !m3.bodyLoaded) {
                return true;
            }
            if (this.needFlags && m3._getFlags() == null) {
                return true;
            }
            if (this.needBodyStructure && m3._getBodyStructure() == null && !m3.bodyLoaded) {
                return true;
            }
            if (this.needUID && m3.getUID() == -1L) {
                return true;
            }
            if (this.needHeaders && !m3.areHeadersLoaded()) {
                return true;
            }
            if (this.needSize && m3.size == -1L && !m3.bodyLoaded) {
                return true;
            }
            if (this.needMessage && !m3.bodyLoaded) {
                return true;
            }
            if (this.needRDate && m3.receivedDate == null) {
                return true;
            }
            for (int i2 = 0; i2 < this.hdrs.length; ++i2) {
                if (m3.isHeaderLoaded(this.hdrs[i2])) continue;
                return true;
            }
            for (FetchItem fitem : this.need) {
                if (m3.items != null && m3.items.get(fitem.getName()) != null) continue;
                return true;
            }
            return false;
        }
    }
}

