/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.util;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.MessageFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

public class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c2 = ReflectionUtil.forNamePrimitive(name);
        if (c2 == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c2 = Class.forName(nc, true, Thread.currentThread().getContextClassLoader());
                c2 = Array.newInstance(c2, 0).getClass();
            } else {
                c2 = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return c2;
    }

    protected static Class forNamePrimitive(String name) {
        int p2;
        if (name.length() <= 8 && (p2 = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p2];
        }
        return null;
    }

    public static Class[] toTypeArray(String[] s2) throws ClassNotFoundException {
        if (s2 == null) {
            return null;
        }
        Class[] c2 = new Class[s2.length];
        for (int i2 = 0; i2 < s2.length; ++i2) {
            c2[i2] = ReflectionUtil.forName(s2[i2]);
        }
        return c2;
    }

    public static String[] toTypeNameArray(Class[] c2) {
        if (c2 == null) {
            return null;
        }
        String[] s2 = new String[c2.length];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            s2[i2] = c2[i2].getName();
        }
        return s2;
    }

    public static Method getMethod(Object base, Object property, Class[] paramTypes) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property.toString();
        Method method = ReflectionUtil.getMethod(base.getClass(), methodName, paramTypes);
        if (method == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return method;
    }

    private static Method getMethod(Class<?> cl2, String methodName, Class<?>[] paramTypes) {
        Method m3 = null;
        try {
            m3 = cl2.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex2) {
            return null;
        }
        Class<?> dclass = m3.getDeclaringClass();
        if (Modifier.isPublic(dclass.getModifiers())) {
            return m3;
        }
        for (Class<?> c2 : dclass.getInterfaces()) {
            m3 = ReflectionUtil.getMethod(c2, methodName, paramTypes);
            if (m3 == null) continue;
            return m3;
        }
        Class<?> c3 = dclass.getSuperclass();
        if (c3 != null && (m3 = ReflectionUtil.getMethod(c3, methodName, paramTypes)) != null) {
            return m3;
        }
        return null;
    }

    protected static final String paramString(Class[] types) {
        if (types != null) {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < types.length; ++i2) {
                sb.append(types[i2].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object base, Object property) throws ELException, PropertyNotFoundException {
        String name = ELSupport.coerceToString(property);
        Object p2 = null;
        try {
            PropertyDescriptor[] desc = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            for (int i2 = 0; i2 < desc.length; ++i2) {
                if (!desc[i2].getName().equals(name)) continue;
                return desc[i2];
            }
        }
        catch (IntrospectionException ie2) {
            throw new ELException(ie2);
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.property.notfound", base, name));
    }
}

