/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Objects;
import org.apache.commons.text.TextStringBuilder;

public class ResultSetHelperService
implements ResultSetHelper {
    protected static final int CLOBBUFFERSIZE = 2048;
    static final String DEFAULT_DATE_FORMAT = "dd-MMM-yyyy";
    static final String DEFAULT_TIMESTAMP_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private static final String DEFAULT_VALUE = "";
    protected String dateFormat = "dd-MMM-yyyy";
    protected String dateTimeFormat = "dd-MMM-yyyy HH:mm:ss";

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        String[] nameArray = new String[metadata.getColumnCount()];
        for (int i2 = 0; i2 < metadata.getColumnCount(); ++i2) {
            nameArray[i2] = metadata.getColumnLabel(i2 + 1);
        }
        return nameArray;
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        return this.getColumnValues(rs, false, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        return this.getColumnValues(rs, trim, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        ResultSetMetaData metadata = rs.getMetaData();
        String[] valueArray = new String[metadata.getColumnCount()];
        for (int i2 = 1; i2 <= metadata.getColumnCount(); ++i2) {
            valueArray[i2 - 1] = this.getColumnValue(rs, metadata.getColumnType(i2), i2, trim, dateFormatString, timeFormatString);
        }
        return valueArray;
    }

    protected String handleTimestamp(Timestamp timestamp, String timestampFormatString) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(timestampFormatString);
        return timestamp == null ? null : timeFormat.format(timestamp);
    }

    private String getColumnValue(ResultSet rs, int colType, int colIndex, boolean trim, String dateFormatString, String timestampFormatString) throws SQLException, IOException {
        String value;
        switch (colType) {
            case 16: {
                value = Objects.toString(rs.getBoolean(colIndex));
                break;
            }
            case 2011: {
                value = this.handleNClob(rs, colIndex);
                break;
            }
            case 2005: {
                value = this.handleClob(rs, colIndex);
                break;
            }
            case -5: {
                BigDecimal d2 = rs.getBigDecimal(colIndex);
                value = Objects.toString(d2 != null ? d2.toBigInteger() : null);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                value = Objects.toString(rs.getBigDecimal(colIndex), DEFAULT_VALUE);
                break;
            }
            case 8: {
                value = Objects.toString(rs.getDouble(colIndex));
                break;
            }
            case 6: {
                value = Objects.toString(Float.valueOf(rs.getFloat(colIndex)));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = Objects.toString(rs.getInt(colIndex));
                break;
            }
            case 91: {
                value = this.handleDate(rs, colIndex, dateFormatString);
                break;
            }
            case 92: {
                value = Objects.toString(rs.getTime(colIndex), DEFAULT_VALUE);
                break;
            }
            case 93: {
                value = this.handleTimestamp(rs.getTimestamp(colIndex), timestampFormatString);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                value = this.handleNVarChar(rs, colIndex, trim);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                value = this.handleVarChar(rs, colIndex, trim);
                break;
            }
            default: {
                value = Objects.toString(rs.getObject(colIndex), DEFAULT_VALUE);
            }
        }
        if (rs.wasNull() || value == null) {
            value = DEFAULT_VALUE;
        }
        return value;
    }

    protected String handleVarChar(ResultSet rs, int colIndex, boolean trim) throws SQLException {
        String columnValue = rs.getString(colIndex);
        String value = trim && columnValue != null ? columnValue.trim() : columnValue;
        return value;
    }

    protected String handleNVarChar(ResultSet rs, int colIndex, boolean trim) throws SQLException {
        String nColumnValue = rs.getNString(colIndex);
        String value = trim && nColumnValue != null ? nColumnValue.trim() : nColumnValue;
        return value;
    }

    protected String handleDate(ResultSet rs, int colIndex, String dateFormatString) throws SQLException {
        String value = DEFAULT_VALUE;
        Date date = rs.getDate(colIndex);
        if (date != null) {
            SimpleDateFormat df2 = new SimpleDateFormat(dateFormatString);
            value = df2.format(date);
        }
        return value;
    }

    protected String handleClob(ResultSet rs, int colIndex) throws SQLException, IOException {
        String value = DEFAULT_VALUE;
        Clob c2 = rs.getClob(colIndex);
        if (c2 != null) {
            TextStringBuilder sb = new TextStringBuilder();
            sb.readFrom(c2.getCharacterStream());
            value = sb.toString();
        }
        return value;
    }

    protected String handleNClob(ResultSet rs, int colIndex) throws SQLException, IOException {
        String value = DEFAULT_VALUE;
        NClob nc = rs.getNClob(colIndex);
        if (nc != null) {
            TextStringBuilder sb = new TextStringBuilder();
            sb.readFrom(nc.getCharacterStream());
            value = sb.toString();
        }
        return value;
    }
}

