/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.concurrent;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public final class BoundedExecutorService
extends AbstractExecutorService {
    static final MLogger logger = MLog.getLogger(BoundedExecutorService.class);
    final ExecutorService inner;
    final int blockBound;
    final int restartBeneath;
    State state;
    int permits;
    Map<Thread, Runnable> waiters = new HashMap<Thread, Runnable>();

    public BoundedExecutorService(ExecutorService executorService, int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("blockBound and restartBeneath must both be greater than zero!");
        }
        if (n3 > n2) {
            throw new IllegalArgumentException("restartBeneath must be less than or equal to blockBound!");
        }
        this.inner = executorService;
        this.blockBound = n2;
        this.restartBeneath = n3;
        this.state = State.ACCEPTING;
        this.permits = 0;
    }

    public BoundedExecutorService(ExecutorService executorService, int n2) {
        this(executorService, n2, n2);
    }

    public synchronized State getState() {
        return this.state;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.state == State.SHUTDOWN || this.state == State.SHUTDOWN_NOW;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.isShutdown() && this.permits == 0;
    }

    @Override
    public synchronized void shutdown() {
        this.inner.shutdown();
        this.updateState(State.SHUTDOWN);
        this.notifyAll();
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.updateState(State.SHUTDOWN_NOW);
        List<Runnable> list = this.inner.shutdownNow();
        Collection<Runnable> collection = this.waiters.values();
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>(list.size() + collection.size());
        arrayList.addAll(list);
        arrayList.addAll(collection);
        Iterator<Thread> iterator2 = this.waiters.keySet().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().interrupt();
        }
        this.waiters.clear();
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public synchronized boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = System.currentTimeMillis();
        long l4 = l3 + TimeUnit.MILLISECONDS.convert(l2, timeUnit);
        boolean bl2 = this.inner.awaitTermination(l2, timeUnit);
        if (bl2) {
            long l5 = System.currentTimeMillis();
            while (!this.isTerminated()) {
                if (l5 > l4) {
                    return false;
                }
                this.wait(l4 - l5);
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(Runnable runnable2) {
        this.inner.execute(this.newTaskFor(runnable2, (V)null));
    }

    protected <V> RunnableFuture<V> newTaskFor(Callable<V> callable) {
        ReleasingFutureTask<V> releasingFutureTask = new ReleasingFutureTask<V>(callable);
        this.acquirePermit(releasingFutureTask);
        return releasingFutureTask;
    }

    protected <V> RunnableFuture<V> newTaskFor(Runnable runnable2, V v2) {
        ReleasingFutureTask<V> releasingFutureTask = new ReleasingFutureTask<V>(runnable2, v2);
        this.acquirePermit(releasingFutureTask);
        return releasingFutureTask;
    }

    private boolean shouldWait() {
        switch (this.state) {
            case SHUTDOWN: 
            case SHUTDOWN_NOW: {
                return this.permits == this.blockBound;
            }
            case ACCEPTING: {
                return false;
            }
            case SATURATED: 
            case UNWINDING: {
                return true;
            }
        }
        throw new AssertionError((Object)"This should be dead code.");
    }

    private synchronized void acquirePermit(Runnable runnable2) {
        try {
            switch (this.state) {
                case SHUTDOWN: 
                case SHUTDOWN_NOW: {
                    throw new RejectedExecutionException(this + " has been shut down. [state=" + (Object)((Object)this.state) + "]");
                }
                case ACCEPTING: 
                case SATURATED: 
                case UNWINDING: {
                    while (this.shouldWait()) {
                        try {
                            this.waiters.put(Thread.currentThread(), runnable2);
                            this.wait();
                        }
                        finally {
                            this.waiters.remove(Thread.currentThread());
                        }
                    }
                    if (this.state == State.SHUTDOWN_NOW) break;
                    ++this.permits;
                    if (this.permits != this.blockBound) break;
                    this.updateState(State.SATURATED);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RejectedExecutionException(this + " has been forcibly shut down. [state=" + (Object)((Object)this.state) + "]", interruptedException);
        }
    }

    private synchronized void releasePermit() {
        --this.permits;
        if (this.permits < this.restartBeneath) {
            this.updateState(State.ACCEPTING);
        } else if (this.state == State.SATURATED && this.permits < this.blockBound) {
            this.updateState(State.UNWINDING);
        }
    }

    private void updateState(State state) {
        switch (this.state) {
            case ACCEPTING: 
            case SATURATED: 
            case UNWINDING: {
                if (this.state == state) break;
                this.doUpdateState(state);
                break;
            }
            case SHUTDOWN: {
                if (state != State.SHUTDOWN_NOW) break;
                this.doUpdateState(state);
                break;
            }
        }
    }

    private void doUpdateState(State state) {
        if (logger.isLoggable(MLevel.FINE)) {
            logger.log(MLevel.FINE, "State transition " + (Object)((Object)this.state) + " => " + (Object)((Object)state) + "; blockBound=" + this.blockBound + "; restartBeneath=" + this.restartBeneath + "; permits=" + this.permits);
        }
        this.state = state;
        if (this.state == State.SHUTDOWN_NOW) {
            this.permits = 0;
        }
        this.notifyAll();
    }

    class ReleasingFutureTask<V>
    extends FutureTask<V> {
        ReleasingFutureTask(Callable<V> callable) {
            super(callable);
        }

        ReleasingFutureTask(Runnable runnable2, V v2) {
            super(runnable2, v2);
        }

        @Override
        protected void done() {
            BoundedExecutorService.this.releasePermit();
        }
    }

    static enum State {
        ACCEPTING,
        SATURATED,
        UNWINDING,
        SHUTDOWN,
        SHUTDOWN_NOW;

    }
}

