/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicMultiPropertiesConfig;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class CombinedMultiPropertiesConfig
extends MultiPropertiesConfig {
    MultiPropertiesConfig[] configs;
    String[] resourcePaths;
    List parseMessages;

    CombinedMultiPropertiesConfig(MultiPropertiesConfig[] multiPropertiesConfigArray) {
        int n2;
        this.configs = multiPropertiesConfigArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i2 = multiPropertiesConfigArray.length - 1; i2 >= 0; --i2) {
            String[] stringArray = multiPropertiesConfigArray[i2].getPropertiesResourcePaths();
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                String string = stringArray[n2];
                if (linkedList.contains(string)) continue;
                linkedList.add(0, string);
            }
        }
        this.resourcePaths = linkedList.toArray(new String[linkedList.size()]);
        LinkedList linkedList2 = new LinkedList();
        n2 = multiPropertiesConfigArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            linkedList2.addAll(multiPropertiesConfigArray[i3].getDelayedLogItems());
        }
        this.parseMessages = Collections.unmodifiableList(linkedList2);
    }

    private Map getPropsByResourcePaths() {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        for (String string : this.resourcePaths) {
            hashMap.put(string, this.getPropertiesByResourcePath(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public BasicMultiPropertiesConfig toBasic() {
        String[] stringArray = this.getPropertiesResourcePaths();
        Map map = this.getPropsByResourcePaths();
        List list = this.getDelayedLogItems();
        return new BasicMultiPropertiesConfig(stringArray, map, list);
    }

    @Override
    public String[] getPropertiesResourcePaths() {
        return (String[])this.resourcePaths.clone();
    }

    @Override
    public Properties getPropertiesByResourcePath(String string) {
        Properties properties = new Properties();
        for (MultiPropertiesConfig multiPropertiesConfig : this.configs) {
            Properties properties2 = multiPropertiesConfig.getPropertiesByResourcePath(string);
            if (properties2 == null) continue;
            properties.putAll((Map<?, ?>)properties2);
        }
        return properties.size() > 0 ? properties : null;
    }

    @Override
    public Properties getPropertiesByPrefix(String string) {
        LinkedList<Map.Entry<Object, Object>> linkedList = new LinkedList<Map.Entry<Object, Object>>();
        for (int i2 = this.configs.length - 1; i2 >= 0; --i2) {
            MultiPropertiesConfig multiPropertiesConfig = this.configs[i2];
            Properties object = multiPropertiesConfig.getPropertiesByPrefix(string);
            if (object == null) continue;
            linkedList.addAll(0, object.entrySet());
        }
        if (linkedList.size() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (Map.Entry entry : linkedList) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @Override
    public String getProperty(String string) {
        for (int i2 = this.configs.length - 1; i2 >= 0; --i2) {
            MultiPropertiesConfig multiPropertiesConfig = this.configs[i2];
            String string2 = multiPropertiesConfig.getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    @Override
    public List getDelayedLogItems() {
        return this.parseMessages;
    }
}

