/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.jvm;

import com.mchange.v1.jvm.TypeFormatException;

public final class InternalNameUtils {
    public static String dottifySlashesAndDollarSigns(String string) {
        return InternalNameUtils._dottifySlashesAndDollarSigns(string).toString();
    }

    public static String decodeType(String string) throws TypeFormatException {
        return InternalNameUtils._decodeType(string).toString();
    }

    public static String decodeTypeList(String string) throws TypeFormatException {
        StringBuffer stringBuffer = new StringBuffer(64);
        InternalNameUtils._decodeTypeList(string, 0, stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean isPrimitive(char c2) {
        return c2 == 'Z' || c2 == 'B' || c2 == 'C' || c2 == 'S' || c2 == 'I' || c2 == 'J' || c2 == 'F' || c2 == 'D' || c2 == 'V';
    }

    private static void _decodeTypeList(String string, int n2, StringBuffer stringBuffer) throws TypeFormatException {
        char c2;
        if (stringBuffer.length() != 0) {
            stringBuffer.append(' ');
        }
        if (InternalNameUtils.isPrimitive(c2 = string.charAt(n2))) {
            stringBuffer.append(InternalNameUtils._decodeType(string.substring(n2, n2 + 1)));
            ++n2;
        } else {
            int n3;
            if (c2 == '[') {
                int n4 = n2 + 1;
                while (string.charAt(n4) == '[') {
                    ++n4;
                }
                if (string.charAt(n4) == 'L') {
                    ++n4;
                    while (string.charAt(n4) != ';') {
                        ++n4;
                    }
                }
                n3 = n4;
            } else {
                n3 = string.indexOf(59, n2);
                if (n3 < 0) {
                    throw new TypeFormatException(string.substring(n2) + " is neither a primitive nor semicolon terminated!");
                }
            }
            int n5 = n2;
            n2 = n3 + 1;
            stringBuffer.append(InternalNameUtils._decodeType(string.substring(n5, n2)));
        }
        if (n2 < string.length()) {
            stringBuffer.append(',');
            InternalNameUtils._decodeTypeList(string, n2, stringBuffer);
        }
    }

    private static StringBuffer _decodeType(String string) throws TypeFormatException {
        StringBuffer stringBuffer;
        int n2 = 0;
        char c2 = string.charAt(0);
        switch (c2) {
            case 'Z': {
                stringBuffer = new StringBuffer("boolean");
                break;
            }
            case 'B': {
                stringBuffer = new StringBuffer("byte");
                break;
            }
            case 'C': {
                stringBuffer = new StringBuffer("char");
                break;
            }
            case 'S': {
                stringBuffer = new StringBuffer("short");
                break;
            }
            case 'I': {
                stringBuffer = new StringBuffer("int");
                break;
            }
            case 'J': {
                stringBuffer = new StringBuffer("long");
                break;
            }
            case 'F': {
                stringBuffer = new StringBuffer("float");
                break;
            }
            case 'D': {
                stringBuffer = new StringBuffer("double");
                break;
            }
            case 'V': {
                stringBuffer = new StringBuffer("void");
                break;
            }
            case '[': {
                ++n2;
                stringBuffer = InternalNameUtils._decodeType(string.substring(1));
                break;
            }
            case 'L': {
                stringBuffer = InternalNameUtils._decodeSimpleClassType(string);
                break;
            }
            default: {
                throw new TypeFormatException(string + " is not a valid inernal type name.");
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("[]");
        }
        return stringBuffer;
    }

    private static StringBuffer _decodeSimpleClassType(String string) throws TypeFormatException {
        int n2 = string.length();
        if (string.charAt(0) != 'L' || string.charAt(n2 - 1) != ';') {
            throw new TypeFormatException(string + " is not a valid representation of a simple class type.");
        }
        return InternalNameUtils._dottifySlashesAndDollarSigns(string.substring(1, n2 - 1));
    }

    private static StringBuffer _dottifySlashesAndDollarSigns(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = stringBuffer.charAt(i2);
            if (c2 != '/' && c2 != '$') continue;
            stringBuffer.setCharAt(i2, '.');
        }
        return stringBuffer;
    }

    private InternalNameUtils() {
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(InternalNameUtils.decodeTypeList(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

