/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.IntEnumeration;
import com.mchange.util.IntObjectMap;
import com.mchange.util.impl.IOHRecElem;
import com.mchange.util.impl.IOHRecord;
import com.mchange.util.impl.IntEnumerationHelperBase;
import java.util.NoSuchElementException;

public class IntObjectHash
implements IntObjectMap {
    IOHRecord[] records;
    int init_capacity;
    float load_factor;
    int threshold;
    int size;

    public IntObjectHash(int n2, float f2) {
        this.init_capacity = n2;
        this.load_factor = f2;
        this.clear();
    }

    public IntObjectHash() {
        this(101, 0.75f);
    }

    @Override
    public synchronized Object get(int n2) {
        int n3 = this.getIndex(n2);
        Object object = null;
        if (this.records[n3] != null) {
            object = this.records[n3].get(n2);
        }
        return object;
    }

    @Override
    public synchronized void put(int n2, Object object) {
        boolean bl2;
        if (object == null) {
            throw new NullPointerException("Null values not permitted.");
        }
        int n3 = this.getIndex(n2);
        if (this.records[n3] == null) {
            this.records[n3] = new IOHRecord(n3);
        }
        if (!(bl2 = this.records[n3].add(n2, object, true))) {
            ++this.size;
        }
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    @Override
    public synchronized boolean putNoReplace(int n2, Object object) {
        boolean bl2;
        if (object == null) {
            throw new NullPointerException("Null values not permitted.");
        }
        int n3 = this.getIndex(n2);
        if (this.records[n3] == null) {
            this.records[n3] = new IOHRecord(n3);
        }
        if (bl2 = this.records[n3].add(n2, object, false)) {
            return false;
        }
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public synchronized boolean containsInt(int n2) {
        int n3 = this.getIndex(n2);
        return this.records[n3] != null && this.records[n3].findInt(n2) != null;
    }

    private int getIndex(int n2) {
        return Math.abs(n2 % this.records.length);
    }

    @Override
    public synchronized Object remove(int n2) {
        Object object;
        IOHRecord iOHRecord = this.records[this.getIndex(n2)];
        Object object2 = object = iOHRecord == null ? null : iOHRecord.remove(n2);
        if (object != null) {
            --this.size;
        }
        return object;
    }

    @Override
    public synchronized void clear() {
        this.records = new IOHRecord[this.init_capacity];
        this.threshold = (int)(this.load_factor * (float)this.init_capacity);
        this.size = 0;
    }

    @Override
    public synchronized IntEnumeration ints() {
        return new IntEnumerationHelperBase(){
            int index = -1;
            IOHRecElem finger;
            {
                this.nextIndex();
            }

            @Override
            public boolean hasMoreInts() {
                return this.index < IntObjectHash.this.records.length;
            }

            @Override
            public int nextInt() {
                try {
                    int n2 = this.finger.num;
                    this.findNext();
                    return n2;
                }
                catch (NullPointerException nullPointerException) {
                    throw new NoSuchElementException();
                }
            }

            private void findNext() {
                if (this.finger.next != null) {
                    this.finger = this.finger.next;
                } else {
                    this.nextIndex();
                }
            }

            private void nextIndex() {
                try {
                    int n2 = IntObjectHash.this.records.length;
                    do {
                        ++this.index;
                    } while (IntObjectHash.this.records[this.index] == null && this.index <= n2);
                    this.finger = IntObjectHash.this.records[this.index].next;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.finger = null;
                }
            }
        };
    }

    protected void rehash() {
        IOHRecord[] iOHRecordArray = new IOHRecord[this.records.length * 2];
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            if (this.records[i2] == null) continue;
            iOHRecordArray[i2] = this.records[i2];
            iOHRecordArray[i2 * 2] = this.records[i2].split(iOHRecordArray.length);
        }
        this.records = iOHRecordArray;
        this.threshold = (int)(this.load_factor * (float)this.records.length);
    }
}

