/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

public enum TabBehaviour {
    IGNORE(null, null),
    CONVERT_TO_ONE_SPACE(1, null),
    CONVERT_TO_TWO_SPACES(2, null),
    CONVERT_TO_THREE_SPACES(3, null),
    CONVERT_TO_FOUR_SPACES(4, null),
    CONVERT_TO_EIGHT_SPACES(8, null),
    ALIGN_TO_COLUMN_4(null, 4),
    ALIGN_TO_COLUMN_8(null, 8);

    private final Integer replaceFactor;
    private final Integer alignFactor;

    private TabBehaviour(Integer replaceFactor, Integer alignFactor) {
        this.replaceFactor = replaceFactor;
        this.alignFactor = alignFactor;
    }

    public String replaceTabs(String string, int columnIndex) {
        int tabPosition = string.indexOf(9);
        while (tabPosition != -1) {
            String tabReplacementHere = this.getTabReplacement(columnIndex + tabPosition);
            string = string.substring(0, tabPosition) + tabReplacementHere + string.substring(tabPosition + 1);
            tabPosition += tabReplacementHere.length();
            tabPosition = string.indexOf(9, tabPosition);
        }
        return string;
    }

    public String getTabReplacement(int columnIndex) {
        int replaceCount;
        StringBuilder replace = new StringBuilder();
        if (this.replaceFactor != null) {
            replaceCount = this.replaceFactor;
        } else if (this.alignFactor != null) {
            replaceCount = this.alignFactor - columnIndex % this.alignFactor;
        } else {
            return "\t";
        }
        for (int i2 = 0; i2 < replaceCount; ++i2) {
            replace.append(" ");
        }
        return replace.toString();
    }
}

