/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyDecodingProfile;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputDecoder {
    private final Reader source;
    private final List<CharacterPattern> bytePatterns;
    private final List<Character> currentMatching;
    private boolean seenEOF;
    private int timeoutUnits;

    public InputDecoder(Reader source2) {
        this.source = new BufferedReader(source2);
        this.bytePatterns = new ArrayList<CharacterPattern>();
        this.currentMatching = new ArrayList<Character>();
        this.seenEOF = false;
        this.timeoutUnits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfile(KeyDecodingProfile profile) {
        for (CharacterPattern pattern : profile.getPatterns()) {
            List<CharacterPattern> list = this.bytePatterns;
            synchronized (list) {
                this.bytePatterns.remove(pattern);
                this.bytePatterns.add(pattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<CharacterPattern> getPatterns() {
        List<CharacterPattern> list = this.bytePatterns;
        synchronized (list) {
            return new ArrayList<CharacterPattern>(this.bytePatterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePattern(CharacterPattern pattern) {
        List<CharacterPattern> list = this.bytePatterns;
        synchronized (list) {
            return this.bytePatterns.remove(pattern);
        }
    }

    public void setTimeoutUnits(int units) {
        this.timeoutUnits = units < 0 ? 0 : (units > 240 ? 240 : units);
    }

    public int getTimeoutUnits() {
        return this.timeoutUnits;
    }

    public synchronized KeyStroke getNextCharacter(boolean blockingIO) throws IOException {
        KeyStroke bestMatch = null;
        int bestLen = 0;
        int curLen = 0;
        while (true) {
            if (curLen < this.currentMatching.size()) {
                ++curLen;
            } else {
                if (bestMatch != null) {
                    int timeout2 = this.getTimeoutUnits();
                    while (timeout2 > 0 && !this.source.ready()) {
                        try {
                            --timeout2;
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e2) {
                            timeout2 = 0;
                        }
                    }
                }
                if (this.source.ready() || blockingIO && bestMatch == null) {
                    int readChar = this.source.read();
                    if (readChar == -1) {
                        this.seenEOF = true;
                        if (!this.currentMatching.isEmpty()) break;
                        return new KeyStroke(KeyType.EOF);
                    }
                    this.currentMatching.add(Character.valueOf((char)readChar));
                    ++curLen;
                } else {
                    if (bestMatch != null) break;
                    return null;
                }
            }
            List<Character> curSub = this.currentMatching.subList(0, curLen);
            CharacterPattern.Matching matching = this.getBestMatch(curSub);
            if (matching.fullMatch != null) {
                bestMatch = matching.fullMatch;
                bestLen = curLen;
                if (matching.partialMatch) continue;
                break;
            }
            if (matching.partialMatch) continue;
            if (bestMatch != null) break;
            curSub.clear();
            curLen = 0;
        }
        if (bestMatch == null) {
            if (this.seenEOF) {
                this.currentMatching.clear();
                return new KeyStroke(KeyType.EOF);
            }
            return null;
        }
        List<Character> bestSub = this.currentMatching.subList(0, bestLen);
        bestSub.clear();
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharacterPattern.Matching getBestMatch(List<Character> characterSequence) {
        boolean partialMatch = false;
        KeyStroke bestMatch = null;
        List<CharacterPattern> list = this.bytePatterns;
        synchronized (list) {
            for (CharacterPattern pattern : this.bytePatterns) {
                CharacterPattern.Matching res = pattern.match(characterSequence);
                if (res == null) continue;
                if (res.partialMatch) {
                    partialMatch = true;
                }
                if (res.fullMatch == null) continue;
                bestMatch = res.fullMatch;
            }
        }
        return new CharacterPattern.Matching(partialMatch, bestMatch);
    }
}

