/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.table.DefaultTableCellRenderer;
import com.googlecode.lanterna.gui2.table.DefaultTableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.DefaultTableRenderer;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;
import com.googlecode.lanterna.gui2.table.TableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.TableModel;
import com.googlecode.lanterna.gui2.table.TableRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;
import java.util.List;

public class Table<V>
extends AbstractInteractableComponent<Table<V>> {
    private TableModel<V> tableModel;
    private TableModel.Listener<V> tableModelListener;
    private TableHeaderRenderer<V> tableHeaderRenderer;
    private TableCellRenderer<V> tableCellRenderer;
    private Runnable selectAction;
    private boolean cellSelection;
    private int visibleRows;
    private int visibleColumns;
    private int selectedRow;
    private int selectedColumn;
    private boolean escapeByArrowKey;

    public Table(String ... columnLabels) {
        if (columnLabels.length == 0) {
            throw new IllegalArgumentException("Table needs at least one column");
        }
        this.tableHeaderRenderer = new DefaultTableHeaderRenderer();
        this.tableCellRenderer = new DefaultTableCellRenderer();
        this.tableModel = new TableModel(columnLabels);
        this.selectAction = null;
        this.visibleColumns = 0;
        this.visibleRows = 0;
        this.cellSelection = false;
        this.selectedRow = 0;
        this.selectedColumn = -1;
        this.escapeByArrowKey = true;
        this.tableModelListener = new TableModel.Listener<V>(){

            @Override
            public void onRowAdded(TableModel<V> model, int index) {
                if (index <= Table.this.selectedRow) {
                    Table.this.selectedRow = Math.min(model.getRowCount() - 1, Table.this.selectedRow + 1);
                }
                Table.this.invalidate();
            }

            @Override
            public void onRowRemoved(TableModel<V> model, int index, List<V> oldRow) {
                if (index < Table.this.selectedRow) {
                    Table.this.selectedRow = Math.max(0, Table.this.selectedRow - 1);
                } else {
                    int rowCount = model.getRowCount();
                    if (Table.this.selectedRow > rowCount - 1) {
                        Table.this.selectedRow = Math.max(0, rowCount - 1);
                    }
                }
                Table.this.invalidate();
            }

            @Override
            public void onColumnAdded(TableModel<V> model, int index) {
                Table.this.invalidate();
            }

            @Override
            public void onColumnRemoved(TableModel<V> model, int index, String oldHeader, List<V> oldColumn) {
                Table.this.invalidate();
            }

            @Override
            public void onCellChanged(TableModel<V> model, int row, int column, V oldValue, V newValue) {
                Table.this.invalidate();
            }
        };
        this.tableModel.addListener(this.tableModelListener);
    }

    public TableModel<V> getTableModel() {
        return this.tableModel;
    }

    public synchronized Table<V> setTableModel(TableModel<V> tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot assign a null TableModel");
        }
        this.tableModel.removeListener(this.tableModelListener);
        this.tableModel = tableModel;
        this.tableModel.addListener(this.tableModelListener);
        this.invalidate();
        return this;
    }

    public TableCellRenderer<V> getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public synchronized Table<V> setTableCellRenderer(TableCellRenderer<V> tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
        this.invalidate();
        return this;
    }

    public TableHeaderRenderer<V> getTableHeaderRenderer() {
        return this.tableHeaderRenderer;
    }

    public synchronized Table<V> setTableHeaderRenderer(TableHeaderRenderer<V> tableHeaderRenderer) {
        this.tableHeaderRenderer = tableHeaderRenderer;
        this.invalidate();
        return this;
    }

    public synchronized void setVisibleColumns(int visibleColumns) {
        this.visibleColumns = visibleColumns;
        this.invalidate();
    }

    public int getVisibleColumns() {
        return this.visibleColumns;
    }

    public synchronized void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
        this.invalidate();
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    @Deprecated
    public int getViewTopRow() {
        return this.getRenderer().getViewTopRow();
    }

    public int getFirstViewedRowIndex() {
        return this.getRenderer().getViewTopRow();
    }

    public int getLastViewedRowIndex() {
        int visibleRows = this.getRenderer().getVisibleRowsOnLastDraw();
        return Math.min(this.getRenderer().getViewTopRow() + visibleRows - 1, this.tableModel.getRowCount() - 1);
    }

    @Deprecated
    public synchronized Table<V> setViewTopRow(int viewTopRow) {
        this.getRenderer().setViewTopRow(viewTopRow);
        return this;
    }

    @Deprecated
    public int getViewLeftColumn() {
        return this.getRenderer().getViewLeftColumn();
    }

    @Deprecated
    public synchronized Table<V> setViewLeftColumn(int viewLeftColumn) {
        this.getRenderer().setViewLeftColumn(viewLeftColumn);
        return this;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public synchronized Table<V> setSelectedColumn(int selectedColumn) {
        if (this.cellSelection) {
            this.selectedColumn = selectedColumn;
        }
        return this;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public synchronized Table<V> setSelectedRow(int selectedRow) {
        if (selectedRow < 0) {
            throw new IllegalArgumentException("selectedRow must be >= 0 but was " + selectedRow);
        }
        int rowCount = this.tableModel.getRowCount();
        if (rowCount == 0) {
            selectedRow = 0;
        } else if (selectedRow > rowCount - 1) {
            selectedRow = rowCount - 1;
        }
        this.selectedRow = selectedRow;
        return this;
    }

    public synchronized Table<V> setCellSelection(boolean cellSelection) {
        this.cellSelection = cellSelection;
        if (cellSelection && this.selectedColumn == -1) {
            this.selectedColumn = 0;
        } else if (!cellSelection) {
            this.selectedColumn = -1;
        }
        return this;
    }

    public boolean isCellSelection() {
        return this.cellSelection;
    }

    public synchronized Table<V> setSelectAction(Runnable selectAction) {
        this.selectAction = selectAction;
        return this;
    }

    public boolean isEscapeByArrowKey() {
        return this.escapeByArrowKey;
    }

    public synchronized Table<V> setEscapeByArrowKey(boolean escapeByArrowKey) {
        this.escapeByArrowKey = escapeByArrowKey;
        return this;
    }

    @Override
    protected TableRenderer<V> createDefaultRenderer() {
        return new DefaultTableRenderer();
    }

    @Override
    public TableRenderer<V> getRenderer() {
        return (TableRenderer)super.getRenderer();
    }

    @Override
    public Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        switch (keyStroke.getKeyType()) {
            case ArrowUp: {
                if (this.selectedRow > 0) {
                    --this.selectedRow;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_UP;
            }
            case ArrowDown: {
                if (this.selectedRow < this.tableModel.getRowCount() - 1) {
                    ++this.selectedRow;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_DOWN;
            }
            case PageUp: {
                if (this.getRenderer().getVisibleRowsOnLastDraw() <= 0 || this.selectedRow <= 0) break;
                this.selectedRow -= Math.min(this.getRenderer().getVisibleRowsOnLastDraw() - 1, this.selectedRow);
                break;
            }
            case PageDown: {
                if (this.getRenderer().getVisibleRowsOnLastDraw() <= 0 || this.selectedRow >= this.tableModel.getRowCount() - 1) break;
                int toEndDistance = this.tableModel.getRowCount() - 1 - this.selectedRow;
                this.selectedRow += Math.min(this.getRenderer().getVisibleRowsOnLastDraw() - 1, toEndDistance);
                break;
            }
            case Home: {
                this.selectedRow = 0;
                break;
            }
            case End: {
                this.selectedRow = this.tableModel.getRowCount() - 1;
                break;
            }
            case ArrowLeft: {
                if (this.cellSelection && this.selectedColumn > 0) {
                    --this.selectedColumn;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_LEFT;
            }
            case ArrowRight: {
                if (this.cellSelection && this.selectedColumn < this.tableModel.getColumnCount() - 1) {
                    ++this.selectedColumn;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_RIGHT;
            }
            case Character: 
            case Enter: {
                if (this.isKeyboardActivationStroke(keyStroke)) {
                    Runnable runnable2 = this.selectAction;
                    if (runnable2 != null) {
                        runnable2.run();
                        break;
                    }
                    return Interactable.Result.HANDLED;
                }
                return super.handleKeyStroke(keyStroke);
            }
            case MouseEvent: {
                MouseAction action = (MouseAction)keyStroke;
                MouseActionType actionType = action.getActionType();
                if (actionType == MouseActionType.MOVE) {
                    return Interactable.Result.UNHANDLED;
                }
                if (!this.isFocused()) {
                    super.handleKeyStroke(keyStroke);
                }
                int mouseRow = this.getRowByMouseAction((MouseAction)keyStroke);
                int mouseColumn = this.getColumnByMouseAction((MouseAction)keyStroke);
                boolean isDifferentCell = mouseRow != this.selectedRow || mouseColumn != this.selectedColumn;
                this.selectedRow = mouseRow;
                this.selectedColumn = mouseColumn;
                if (!isDifferentCell) break;
                return this.handleKeyStroke(new KeyStroke(KeyType.Enter));
            }
            default: {
                return super.handleKeyStroke(keyStroke);
            }
        }
        this.invalidate();
        return Interactable.Result.HANDLED;
    }

    protected int getRowByMouseAction(MouseAction mouseAction) {
        int minPossible = this.getFirstViewedRowIndex();
        int maxPossible = this.getLastViewedRowIndex();
        int mouseSpecified = mouseAction.getPosition().getRow() - this.getGlobalPosition().getRow() - 1;
        return Math.max(minPossible, Math.min(mouseSpecified, maxPossible));
    }

    protected int getColumnByMouseAction(MouseAction mouseAction) {
        int maxColumnIndex = this.tableModel.getColumnCount() - 1;
        int column = 0;
        int columnSize = this.tableHeaderRenderer.getPreferredSize(this, this.tableModel.getColumnLabel(column), column).getColumns();
        int globalColumnMoused = mouseAction.getPosition().getColumn() - this.getGlobalPosition().getColumn();
        while (globalColumnMoused - columnSize - 1 >= 0 && column < maxColumnIndex) {
            globalColumnMoused -= columnSize;
            columnSize = this.tableHeaderRenderer.getPreferredSize(this, this.tableModel.getColumnLabel(++column), column).getColumns();
        }
        return column;
    }
}

