/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.TextGUIGraphics;

public class Separator
extends AbstractComponent<Separator> {
    private final Direction direction;

    public Separator(Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Cannot create a separator with a null direction");
        }
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected DefaultSeparatorRenderer createDefaultRenderer() {
        return new DefaultSeparatorRenderer();
    }

    public static class DefaultSeparatorRenderer
    extends SeparatorRenderer {
        @Override
        public TerminalSize getPreferredSize(Separator component) {
            return TerminalSize.ONE;
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, Separator component) {
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            graphics.applyThemeStyle(themeDefinition.getNormal());
            char character = themeDefinition.getCharacter(component.getDirection().name().toUpperCase(), component.getDirection() == Direction.HORIZONTAL ? (char)'\u2500' : '\u2502');
            graphics.fill(character);
        }
    }

    public static abstract class SeparatorRenderer
    implements ComponentRenderer<Separator> {
    }
}

