/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIThread;
import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractTextGUIThread
implements TextGUIThread {
    protected final TextGUI textGUI;
    protected final Queue<Runnable> customTasks;
    protected TextGUIThread.ExceptionHandler exceptionHandler = new TextGUIThread.ExceptionHandler(){

        @Override
        public boolean onIOException(IOException e2) {
            e2.printStackTrace();
            return true;
        }

        @Override
        public boolean onRuntimeException(RuntimeException e2) {
            e2.printStackTrace();
            return true;
        }
    };

    public AbstractTextGUIThread(TextGUI textGUI) {
        this.textGUI = textGUI;
        this.customTasks = new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public void invokeLater(Runnable runnable2) throws IllegalStateException {
        this.customTasks.add(runnable2);
    }

    @Override
    public void setExceptionHandler(TextGUIThread.ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("Cannot call setExceptionHandler(null)");
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public synchronized boolean processEventsAndUpdate() throws IOException {
        if (this.getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Calling processEventAndUpdate outside of GUI thread");
        }
        try {
            this.textGUI.processInput();
            while (!this.customTasks.isEmpty()) {
                Runnable r2 = this.customTasks.poll();
                if (r2 == null) continue;
                r2.run();
            }
            if (this.textGUI.isPendingUpdate()) {
                this.textGUI.updateScreen();
                return true;
            }
            return false;
        }
        catch (EOFException e2) {
            throw e2;
        }
        catch (IOException e3) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onIOException(e3);
            }
            throw e3;
        }
        catch (RuntimeException e4) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onRuntimeException(e4);
            }
            throw e4;
        }
        return true;
    }

    @Override
    public void invokeAndWait(Runnable runnable2) throws IllegalStateException, InterruptedException {
        Thread guiThread = this.getThread();
        if (guiThread == null || Thread.currentThread() == guiThread) {
            runnable2.run();
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.invokeLater(() -> {
                try {
                    runnable2.run();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
        }
    }
}

