/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.crypto.tink.subtle.Validators;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class RsaSsaPssVerifyJce
implements PublicKeyVerify {
    private final RSAPublicKey publicKey;
    private final Enums.HashType sigHash;
    private final Enums.HashType mgf1Hash;
    private final int saltLength;

    public RsaSsaPssVerifyJce(RSAPublicKey pubKey, Enums.HashType sigHash, Enums.HashType mgf1Hash, int saltLength) throws GeneralSecurityException {
        Validators.validateSignatureHash(sigHash);
        Validators.validateRsaModulusSize(pubKey.getModulus().bitLength());
        Validators.validateRsaPublicExponent(pubKey.getPublicExponent());
        this.publicKey = pubKey;
        this.sigHash = sigHash;
        this.mgf1Hash = mgf1Hash;
        this.saltLength = saltLength;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        BigInteger e2 = this.publicKey.getPublicExponent();
        BigInteger n2 = this.publicKey.getModulus();
        int nLengthInBytes = (n2.bitLength() + 7) / 8;
        int mLen = (n2.bitLength() - 1 + 7) / 8;
        if (nLengthInBytes != signature.length) {
            throw new GeneralSecurityException("invalid signature's length");
        }
        BigInteger s2 = SubtleUtil.bytes2Integer(signature);
        if (s2.compareTo(n2) >= 0) {
            throw new GeneralSecurityException("signature out of range");
        }
        BigInteger m3 = s2.modPow(e2, n2);
        byte[] em2 = SubtleUtil.integer2Bytes(m3, mLen);
        this.emsaPssVerify(data, em2, n2.bitLength() - 1);
    }

    private void emsaPssVerify(byte[] m3, byte[] em2, int emBits) throws GeneralSecurityException {
        int i2;
        Validators.validateSignatureHash(this.sigHash);
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(this.sigHash));
        byte[] mHash = digest.digest(m3);
        int hLen = digest.getDigestLength();
        int emLen = em2.length;
        if (emLen < hLen + this.saltLength + 2) {
            throw new GeneralSecurityException("inconsistent");
        }
        if (em2[em2.length - 1] != -68) {
            throw new GeneralSecurityException("inconsistent");
        }
        byte[] maskedDb = Arrays.copyOf(em2, emLen - hLen - 1);
        byte[] h2 = Arrays.copyOfRange(em2, maskedDb.length, maskedDb.length + hLen);
        int i3 = 0;
        while ((long)i3 < (long)emLen * 8L - (long)emBits) {
            int bytePos = i3 / 8;
            int bitPos = 7 - i3 % 8;
            if ((maskedDb[bytePos] >> bitPos & 1) != 0) {
                throw new GeneralSecurityException("inconsistent");
            }
            ++i3;
        }
        byte[] dbMask = SubtleUtil.mgf1(h2, emLen - hLen - 1, this.mgf1Hash);
        byte[] db2 = new byte[dbMask.length];
        for (i2 = 0; i2 < db2.length; ++i2) {
            db2[i2] = (byte)(dbMask[i2] ^ maskedDb[i2]);
        }
        i2 = 0;
        while ((long)i2 <= (long)emLen * 8L - (long)emBits) {
            int bytePos = i2 / 8;
            int bitPos = 7 - i2 % 8;
            db2[bytePos] = (byte)(db2[bytePos] & ~(1 << bitPos));
            ++i2;
        }
        for (i2 = 0; i2 < emLen - hLen - this.saltLength - 2; ++i2) {
            if (db2[i2] == 0) continue;
            throw new GeneralSecurityException("inconsistent");
        }
        if (db2[emLen - hLen - this.saltLength - 2] != 1) {
            throw new GeneralSecurityException("inconsistent");
        }
        byte[] salt = Arrays.copyOfRange(db2, db2.length - this.saltLength, db2.length);
        byte[] mPrime = new byte[8 + hLen + this.saltLength];
        System.arraycopy(mHash, 0, mPrime, 8, mHash.length);
        System.arraycopy(salt, 0, mPrime, 8 + hLen, salt.length);
        byte[] hPrime = digest.digest(mPrime);
        if (!Bytes.equal(hPrime, h2)) {
            throw new GeneralSecurityException("inconsistent");
        }
    }
}

