/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

public final class Hex {
    public static String encode(byte[] bytes) {
        String chars = "0123456789abcdef";
        StringBuilder result = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            int val = b2 & 0xFF;
            result.append(chars.charAt(val / 16));
            result.append(chars.charAt(val % 16));
        }
        return result.toString();
    }

    public static byte[] decode(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Expected a string of even length");
        }
        int size = hex.length() / 2;
        byte[] result = new byte[size];
        for (int i2 = 0; i2 < size; ++i2) {
            int hi2 = Character.digit(hex.charAt(2 * i2), 16);
            int lo2 = Character.digit(hex.charAt(2 * i2 + 1), 16);
            if (hi2 == -1 || lo2 == -1) {
                throw new IllegalArgumentException("input is not hexadecimal");
            }
            result[i2] = (byte)(16 * hi2 + lo2);
        }
        return result;
    }
}

