/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public final class Bytes {
    public static final boolean equal(byte[] x2, byte[] y2) {
        if (x2 == null || y2 == null) {
            return false;
        }
        if (x2.length != y2.length) {
            return false;
        }
        int res = 0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            res |= x2[i2] ^ y2[i2];
        }
        return res == 0;
    }

    public static byte[] concat(byte[] ... chunks) throws GeneralSecurityException {
        int length = 0;
        for (byte[] chunk : chunks) {
            if (length > Integer.MAX_VALUE - chunk.length) {
                throw new GeneralSecurityException("exceeded size limit");
            }
            length += chunk.length;
        }
        byte[] res = new byte[length];
        int pos = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, res, pos, chunk.length);
            pos += chunk.length;
        }
        return res;
    }

    public static final byte[] xor(byte[] x2, int offsetX, byte[] y2, int offsetY, int len) {
        if (len < 0 || x2.length - len < offsetX || y2.length - len < offsetY) {
            throw new IllegalArgumentException("That combination of buffers, offsets and length to xor result in out-of-bond accesses.");
        }
        byte[] res = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = (byte)(x2[i2 + offsetX] ^ y2[i2 + offsetY]);
        }
        return res;
    }

    public static final void xor(ByteBuffer output, ByteBuffer x2, ByteBuffer y2, int len) {
        if (len < 0 || x2.remaining() < len || y2.remaining() < len || output.remaining() < len) {
            throw new IllegalArgumentException("That combination of buffers, offsets and length to xor result in out-of-bond accesses.");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            output.put((byte)(x2.get() ^ y2.get()));
        }
    }

    public static final byte[] xor(byte[] x2, byte[] y2) {
        if (x2.length != y2.length) {
            throw new IllegalArgumentException("The lengths of x and y should match.");
        }
        return Bytes.xor(x2, 0, y2, 0, x2.length);
    }

    public static final byte[] xorEnd(byte[] a2, byte[] b2) {
        if (a2.length < b2.length) {
            throw new IllegalArgumentException("xorEnd requires a.length >= b.length");
        }
        int paddingLength = a2.length - b2.length;
        byte[] res = Arrays.copyOf(a2, a2.length);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            int n2 = paddingLength + i2;
            res[n2] = (byte)(res[n2] ^ b2[i2]);
        }
        return res;
    }

    public static byte[] intToByteArray(int capacity, int value) {
        byte[] result = new byte[capacity];
        for (int i2 = 0; i2 < capacity; ++i2) {
            result[i2] = (byte)(value >> 8 * i2 & 0xFF);
        }
        return result;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return Bytes.byteArrayToInt(bytes, bytes.length);
    }

    public static int byteArrayToInt(byte[] bytes, int length) {
        return Bytes.byteArrayToInt(bytes, 0, length);
    }

    public static int byteArrayToInt(byte[] bytes, int offset, int length) {
        int value = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            value += (bytes[i2 + offset] & 0xFF) << i2 * 8;
        }
        return value;
    }
}

