/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.collect.$ImmutableSortedSet;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.TypeMirrorSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

final class TypeSimplifier {
    private final Map<String, Spelling> imports;
    private static final TypeVisitor<Boolean, Void> CASTING_UNCHECKED_VISITOR = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitUnknown(TypeMirror t2, Void p2) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType t2, Void p2) {
            return (Boolean)this.visit(t2.getComponentType(), p2);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t2, Void p2) {
            return t2.getTypeArguments().stream().anyMatch(x$0 -> TypeSimplifier.uncheckedTypeArgument(x$0));
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable t2, Void p2) {
            return true;
        }
    };

    TypeSimplifier(Elements elementUtils, Types typeUtils, String packageName, Set<TypeMirror> types, TypeMirror base) {
        TypeMirrorSet typesPlusBase = new TypeMirrorSet(types);
        if (base != null) {
            typesPlusBase.add(base);
        }
        Set<TypeMirror> topLevelTypes = TypeSimplifier.topLevelTypes(typeUtils, typesPlusBase);
        Set<TypeMirror> defined = TypeSimplifier.nonPrivateDeclaredTypes(typeUtils, base);
        this.imports = TypeSimplifier.findImports(elementUtils, typeUtils, packageName, topLevelTypes, defined);
    }

    $ImmutableSortedSet<String> typesToImport() {
        $ImmutableSortedSet.Builder typesToImport = $ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, Spelling> entry : this.imports.entrySet()) {
            if (!entry.getValue().importIt) continue;
            typesToImport.add(entry.getKey());
        }
        return typesToImport.build();
    }

    String simplifiedClassName(DeclaredType type) {
        TypeElement typeElement = $MoreElements.asType(type.asElement());
        TypeElement top = TypeSimplifier.topLevelType(typeElement);
        String topString = top.getQualifiedName().toString();
        if (this.imports.containsKey(topString)) {
            String suffix = typeElement.getQualifiedName().toString().substring(topString.length());
            return this.imports.get((Object)topString).spelling + suffix;
        }
        return typeElement.getQualifiedName().toString();
    }

    static String actualTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return typeParameters.stream().map(e2 -> e2.getSimpleName().toString()).collect(Collectors.joining(", ", "<", ">"));
    }

    static String classNameOf(TypeElement type) {
        String name = type.getQualifiedName().toString();
        String pkgName = TypeSimplifier.packageNameOf(type);
        return pkgName.isEmpty() ? name : name.substring(pkgName.length() + 1);
    }

    private static TypeElement topLevelType(TypeElement type) {
        while (type.getNestingKind() != NestingKind.TOP_LEVEL) {
            type = $MoreElements.asType(type.getEnclosingElement());
        }
        return type;
    }

    static String packageNameOf(TypeElement type) {
        return $MoreElements.getPackage(type).getQualifiedName().toString();
    }

    static String simpleNameOf(String s2) {
        if (s2.contains(".")) {
            return s2.substring(s2.lastIndexOf(46) + 1);
        }
        return s2;
    }

    private static Map<String, Spelling> findImports(Elements elementUtils, Types typeUtils, String codePackageName, Set<TypeMirror> referenced, Set<TypeMirror> defined) {
        HashMap<String, Spelling> imports = new HashMap<String, Spelling>();
        TypeMirrorSet typesInScope = new TypeMirrorSet();
        typesInScope.addAll(referenced);
        typesInScope.addAll(defined);
        Set<String> ambiguous = TypeSimplifier.ambiguousNames(typeUtils, typesInScope);
        for (TypeMirror type : referenced) {
            String spelling;
            boolean importIt;
            TypeElement typeElement = (TypeElement)typeUtils.asElement(type);
            String fullName = typeElement.getQualifiedName().toString();
            String simpleName = typeElement.getSimpleName().toString();
            String pkg = TypeSimplifier.packageNameOf(typeElement);
            if (ambiguous.contains(simpleName)) {
                importIt = false;
                spelling = fullName;
            } else if (pkg.equals("java.lang")) {
                importIt = false;
                spelling = TypeSimplifier.javaLangSpelling(elementUtils, codePackageName, typeElement);
            } else if (pkg.equals(codePackageName)) {
                importIt = false;
                spelling = fullName.substring(pkg.isEmpty() ? 0 : pkg.length() + 1);
            } else {
                importIt = true;
                spelling = simpleName;
            }
            imports.put(fullName, new Spelling(spelling, importIt));
        }
        return imports;
    }

    private static String javaLangSpelling(Elements elementUtils, String codePackageName, TypeElement typeElement) {
        TypeElement topLevelType = TypeSimplifier.topLevelType(typeElement);
        TypeElement clash = elementUtils.getTypeElement(codePackageName + "." + topLevelType.getSimpleName());
        String fullName = typeElement.getQualifiedName().toString();
        return clash == null ? fullName.substring("java.lang.".length()) : fullName;
    }

    private static Set<TypeMirror> topLevelTypes(Types typeUtil, Set<TypeMirror> types) {
        return types.stream().map(typeMirror -> $MoreElements.asType(typeUtil.asElement((TypeMirror)typeMirror))).map(typeElement -> TypeSimplifier.topLevelType(typeElement).asType()).collect(Collectors.toCollection(TypeMirrorSet::new));
    }

    private static Set<TypeMirror> nonPrivateDeclaredTypes(Types typeUtils, TypeMirror type) {
        if (type == null) {
            return new TypeMirrorSet();
        }
        TypeMirrorSet declared = new TypeMirrorSet();
        declared.add(type);
        List<TypeElement> nestedTypes = ElementFilter.typesIn(typeUtils.asElement(type).getEnclosedElements());
        for (TypeElement typeElement : nestedTypes) {
            if (typeElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            declared.add(typeElement.asType());
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(type)) {
            declared.addAll(TypeSimplifier.nonPrivateDeclaredTypes(typeUtils, typeMirror));
        }
        return declared;
    }

    private static Set<String> ambiguousNames(Types typeUtils, Set<TypeMirror> types) {
        HashSet<String> ambiguous = new HashSet<String>();
        HashMap<String, Name> simpleNamesToQualifiedNames = new HashMap<String, Name>();
        for (TypeMirror type : types) {
            Name qualifiedName;
            if (type.getKind() == TypeKind.ERROR) {
                throw new MissingTypes.MissingTypeException($MoreTypes.asError(type));
            }
            String simpleName = typeUtils.asElement(type).getSimpleName().toString();
            Name previous = simpleNamesToQualifiedNames.put(simpleName, qualifiedName = ((QualifiedNameable)typeUtils.asElement(type)).getQualifiedName());
            if (previous == null || previous.equals(qualifiedName)) continue;
            ambiguous.add(simpleName);
        }
        return ambiguous;
    }

    static boolean isCastingUnchecked(TypeMirror type) {
        return CASTING_UNCHECKED_VISITOR.visit(type, null);
    }

    private static boolean uncheckedTypeArgument(TypeMirror arg) {
        WildcardType wildcard;
        if (arg.getKind() == TypeKind.WILDCARD && ((wildcard = (WildcardType)arg).getExtendsBound() == null || TypeSimplifier.isJavaLangObject(wildcard.getExtendsBound()))) {
            return wildcard.getSuperBound() != null;
        }
        return true;
    }

    private static boolean isJavaLangObject(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)type;
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        return typeElement.getQualifiedName().contentEquals("java.lang.Object");
    }

    private static class Spelling {
        final String spelling;
        final boolean importIt;

        Spelling(String spelling, boolean importIt) {
            this.spelling = spelling;
            this.importIt = importIt;
        }
    }
}

