/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Streams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SimpleServiceLoader {
    private SimpleServiceLoader() {
    }

    public static <T> $ImmutableList<T> load(Class<? extends T> service, ClassLoader loader) {
        return SimpleServiceLoader.load(service, loader, Optional.empty());
    }

    public static <T> $ImmutableList<T> load(Class<? extends T> service, ClassLoader loader, Optional<Pattern> allowedMissingClasses) {
        ArrayList<URL> resourceUrls;
        String resourceName = "META-INF/services/" + service.getName();
        try {
            resourceUrls = Collections.list(loader.getResources(resourceName));
        }
        catch (IOException e2) {
            throw new ServiceConfigurationError("Could not look up " + resourceName, e2);
        }
        $ImmutableSet.Builder providerClasses = $ImmutableSet.builder();
        for (URL resourceUrl : resourceUrls) {
            try {
                providerClasses.addAll(SimpleServiceLoader.providerClassesFromUrl(resourceUrl, service, loader, allowedMissingClasses));
            }
            catch (IOException e3) {
                throw new ServiceConfigurationError("Could not read " + resourceUrl, e3);
            }
        }
        $ImmutableList.Builder providers = $ImmutableList.builder();
        for (Class providerClass : providerClasses.build()) {
            try {
                Object provider = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                providers.add(provider);
            }
            catch (ReflectiveOperationException e4) {
                throw new ServiceConfigurationError("Could not construct " + providerClass.getName(), e4);
            }
        }
        return providers.build();
    }

    private static <T> $ImmutableSet<Class<? extends T>> providerClassesFromUrl(URL resourceUrl, Class<? extends T> service, ClassLoader loader, Optional<Pattern> allowedMissingClasses) throws IOException {
        List lines;
        $ImmutableSet.Builder providerClasses = $ImmutableSet.builder();
        URLConnection urlConnection = resourceUrl.openConnection();
        urlConnection.setUseCaches(false);
        InputStream in2 = urlConnection.getInputStream();
        Object object = null;
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(in2, StandardCharsets.UTF_8));){
            lines = reader2.lines().collect(Collectors.toList());
        }
        catch (Throwable reader2) {
            object = reader2;
            throw reader2;
        }
        finally {
            if (in2 != null) {
                if (object != null) {
                    try {
                        in2.close();
                    }
                    catch (Throwable reader2) {
                        ((Throwable)object).addSuppressed(reader2);
                    }
                } else {
                    in2.close();
                }
            }
        }
        List classNames = lines.stream().map(SimpleServiceLoader::parseClassName).flatMap($Streams::stream).collect(Collectors.toList());
        for (String className : classNames) {
            Class<?> c2;
            try {
                c2 = Class.forName(className, false, loader);
            }
            catch (ClassNotFoundException e2) {
                if (allowedMissingClasses.isPresent() && allowedMissingClasses.get().matcher(className).matches()) continue;
                throw new ServiceConfigurationError("Could not load " + className, e2);
            }
            if (!service.isAssignableFrom(c2)) {
                throw new ServiceConfigurationError("Class " + className + " is not assignable to " + service.getName());
            }
            providerClasses.add(c2.asSubclass(service));
        }
        return providerClasses.build();
    }

    private static Optional<String> parseClassName(String line) {
        int hash = line.indexOf(35);
        if (hash >= 0) {
            line = line.substring(0, hash);
        }
        return (line = line.trim()).isEmpty() ? Optional.empty() : Optional.of(line);
    }
}

