/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

class GwtCompatibility {
    private final Optional<AnnotationMirror> gwtCompatibleAnnotation;

    GwtCompatibility(TypeElement type) {
        Optional<Object> gwtCompatibleAnnotation = Optional.empty();
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Name name = annotationMirror.getAnnotationType().asElement().getSimpleName();
            if (!name.contentEquals("GwtCompatible")) continue;
            gwtCompatibleAnnotation = Optional.of(annotationMirror);
        }
        this.gwtCompatibleAnnotation = gwtCompatibleAnnotation;
    }

    Optional<AnnotationMirror> gwtCompatibleAnnotation() {
        return this.gwtCompatibleAnnotation;
    }

    static Map<ExecutableElement, AnnotationValue> getElementValues(AnnotationMirror annotation) {
        return Collections.unmodifiableMap(annotation.getElementValues());
    }

    String gwtCompatibleAnnotationString() {
        if (this.gwtCompatibleAnnotation.isPresent()) {
            AnnotationMirror annotation = this.gwtCompatibleAnnotation.get();
            TypeElement annotationElement = (TypeElement)annotation.getAnnotationType().asElement();
            String annotationArguments = annotation.getElementValues().isEmpty() ? "" : GwtCompatibility.getElementValues(annotation).entrySet().stream().map(e2 -> ((ExecutableElement)e2.getKey()).getSimpleName() + " = " + e2.getValue()).collect(Collectors.joining(", ", "(", ")"));
            return "@" + annotationElement.getQualifiedName() + annotationArguments;
        }
        return "";
    }
}

