/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google;
import com.google.auto.value.processor.AbortProcessingException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ErrorReporter {
    private final Messager messager;
    private int errorCount;

    ErrorReporter(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @google..FormatMethod
    void reportNote(Element e2, String format, Object ... args2) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(format, args2), e2);
    }

    @google..FormatMethod
    void reportWarning(Element e2, String format, Object ... args2) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(format, args2), e2);
    }

    @google..FormatMethod
    void reportError(Element e2, String format, Object ... args2) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(format, args2), e2);
        ++this.errorCount;
    }

    @google..FormatMethod
    AbortProcessingException abortWithError(Element e2, String format, Object ... args2) {
        this.reportError(e2, format, args2);
        throw new AbortProcessingException();
    }

    int errorCount() {
        return this.errorCount;
    }

    void abortIfAnyError() {
        if (this.errorCount > 0) {
            throw new AbortProcessingException();
        }
    }
}

