/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.toprettystring.processor;

import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$GeneratedAnnotationSpecs;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.common.$Visibility;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Sets;
import autovalue.shaded.com.squareup.javapoet$.$AnnotationSpec;
import autovalue.shaded.com.squareup.javapoet$.$ClassName;
import autovalue.shaded.com.squareup.javapoet$.$MethodSpec;
import autovalue.shaded.com.squareup.javapoet$.$ParameterizedTypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeSpec;
import autovalue.shaded.com.squareup.javapoet$.$TypeVariableName;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.extension.toprettystring.processor.Annotations;
import com.google.auto.value.extension.toprettystring.processor.ToPrettyStringExtension;
import java.lang.annotation.Inherited;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ExtensionClassTypeSpecBuilder {
    private static final String AUTO_VALUE_PACKAGE_NAME = "com.google.auto.value.";
    private static final String AUTO_VALUE_NAME = "com.google.auto.value.AutoValue";
    private static final String COPY_ANNOTATIONS_NAME = "com.google.auto.value.AutoValue.CopyAnnotations";
    private final AutoValueExtension.Context context;
    private final String className;
    private final String classToExtend;
    private final boolean isFinal;
    private final Types types;
    private final Elements elements;
    private final SourceVersion sourceVersion;

    private ExtensionClassTypeSpecBuilder(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        this.context = context;
        this.className = className;
        this.classToExtend = classToExtend;
        this.isFinal = isFinal;
        this.types = context.processingEnvironment().getTypeUtils();
        this.elements = context.processingEnvironment().getElementUtils();
        this.sourceVersion = context.processingEnvironment().getSourceVersion();
    }

    static $TypeSpec.Builder extensionClassTypeSpecBuilder(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        return new ExtensionClassTypeSpecBuilder(context, className, classToExtend, isFinal).extensionClassBuilder();
    }

    $TypeSpec.Builder extensionClassBuilder() {
        $TypeSpec.Builder builder = $TypeSpec.classBuilder(this.className).superclass(this.superType()).addAnnotations(this.copiedClassAnnotations(this.context.autoValueClass())).addTypeVariables(this.annotatedTypeVariableNames()).addModifiers(this.isFinal ? Modifier.FINAL : Modifier.ABSTRACT).addMethod(this.constructor());
        $GeneratedAnnotationSpecs.generatedAnnotationSpec(this.elements, this.sourceVersion, ToPrettyStringExtension.class).ifPresent(builder::addAnnotation);
        return builder;
    }

    private $TypeName superType() {
        $ClassName superType = $ClassName.get(this.context.packageName(), this.classToExtend, new String[0]);
        $ImmutableList<$TypeVariableName> typeVariableNames = this.typeVariableNames();
        return typeVariableNames.isEmpty() ? superType : $ParameterizedTypeName.get(superType, typeVariableNames.toArray(new $TypeName[0]));
    }

    private $ImmutableList<$TypeVariableName> typeVariableNames() {
        return this.context.autoValueClass().getTypeParameters().stream().map($TypeVariableName::get).collect($ImmutableList.toImmutableList());
    }

    private $ImmutableList<$TypeVariableName> annotatedTypeVariableNames() {
        return this.context.autoValueClass().getTypeParameters().stream().map(p2 -> $TypeVariableName.get(p2).annotated((List)p2.getAnnotationMirrors().stream().map($AnnotationSpec::get).collect($ImmutableList.toImmutableList()))).collect($ImmutableList.toImmutableList());
    }

    private $MethodSpec constructor() {
        $MethodSpec.Builder constructor = $MethodSpec.constructorBuilder();
        this.context.propertyTypes().forEach((name, type) -> constructor.addParameter(ExtensionClassTypeSpecBuilder.annotatedType(type), name + "$", new Modifier[0]));
        String superParams = this.context.properties().keySet().stream().map(n2 -> n2 + "$").collect(Collectors.joining(", "));
        constructor.addStatement("super($L)", superParams);
        return constructor.build();
    }

    private boolean isInAutoValuePackage(String className) {
        return className.startsWith(AUTO_VALUE_PACKAGE_NAME) && !className.contains("Test");
    }

    private static String getAnnotationFqName(AnnotationMirror annotation) {
        return ((QualifiedNameable)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
    }

    private boolean annotationVisibleFrom(AnnotationMirror annotation, Element from) {
        Element annotationElement = annotation.getAnnotationType().asElement();
        $Visibility visibility = $Visibility.effectiveVisibilityOfElement(annotationElement);
        switch (visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from)) || this.types.isSubtype(from.asType(), annotationElement.getEnclosingElement().asType());
            }
            case DEFAULT: {
                return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from));
            }
        }
        return false;
    }

    private $ImmutableList<AnnotationMirror> annotationsToCopy(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
        $ImmutableList.Builder result = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : typeOrMethod.getAnnotationMirrors()) {
            String annotationFqName = ExtensionClassTypeSpecBuilder.getAnnotationFqName(annotationMirror);
            if (this.isInAutoValuePackage(annotationFqName) || excludedAnnotations.contains(annotationFqName) || !this.annotationVisibleFrom(annotationMirror, autoValueType)) continue;
            result.add(annotationMirror);
        }
        return result.build();
    }

    private $ImmutableList<$AnnotationSpec> copyAnnotations(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
        $ImmutableList<AnnotationMirror> annotationsToCopy = this.annotationsToCopy(autoValueType, typeOrMethod, excludedAnnotations);
        return annotationsToCopy.stream().map($AnnotationSpec::get).collect($ImmutableList.toImmutableList());
    }

    private static boolean hasAnnotationMirror(Element element, String annotationName) {
        return Annotations.getAnnotationMirror(element, annotationName).isPresent();
    }

    private $ImmutableSet<TypeMirror> getExcludedAnnotationTypes(Element element) {
        Optional<AnnotationMirror> maybeAnnotation = Annotations.getAnnotationMirror(element, COPY_ANNOTATIONS_NAME);
        if (!maybeAnnotation.isPresent()) {
            return $ImmutableSet.of();
        }
        List excludedClasses = (List)$AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "exclude").getValue();
        return excludedClasses.stream().map(annotationValue -> $MoreTypes.equivalence().wrap((TypeMirror)annotationValue.getValue())).distinct().map($Equivalence.Wrapper::get).collect($ImmutableSet.toImmutableSet());
    }

    private Set<String> getExcludedAnnotationClassNames(Element element) {
        return this.getExcludedAnnotationTypes(element).stream().map($MoreTypes::asTypeElement).map(typeElement -> typeElement.getQualifiedName().toString()).collect(Collectors.toSet());
    }

    private static Set<String> getAnnotationsMarkedWithInherited(Element element) {
        return element.getAnnotationMirrors().stream().filter(a2 -> $MoreElements.isAnnotationPresent(a2.getAnnotationType().asElement(), Inherited.class)).map(ExtensionClassTypeSpecBuilder::getAnnotationFqName).collect(Collectors.toSet());
    }

    private $ImmutableList<$AnnotationSpec> copiedClassAnnotations(TypeElement type) {
        if (ExtensionClassTypeSpecBuilder.hasAnnotationMirror(type, COPY_ANNOTATIONS_NAME)) {
            $Sets.SetView<String> excludedAnnotations = $Sets.union(this.getExcludedAnnotationClassNames(type), ExtensionClassTypeSpecBuilder.getAnnotationsMarkedWithInherited(type));
            return this.copyAnnotations(type, type, excludedAnnotations);
        }
        return $ImmutableList.of();
    }

    private static $TypeName annotatedType(TypeMirror type) {
        List<$AnnotationSpec> annotations = type.getAnnotationMirrors().stream().map($AnnotationSpec::get).collect(Collectors.toList());
        return $TypeName.get(type).annotated(annotations);
    }
}

