/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueue;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueConsumerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueProducerFields;
import com.github.benmanes.caffeine.cache.MpscAccess;
import com.github.benmanes.caffeine.cache.UnsafeAccess;
import java.lang.reflect.Field;

final class UnsafeMpscAccess
implements MpscAccess {
    static final long P_INDEX_OFFSET;
    static final long C_INDEX_OFFSET;
    static final long P_LIMIT_OFFSET;
    static final long REF_ARRAY_BASE;
    static final int REF_ELEMENT_SHIFT;

    UnsafeMpscAccess() {
    }

    @Override
    public long lvProducerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return UnsafeAccess.UNSAFE.getLongVolatile(self, P_INDEX_OFFSET);
    }

    @Override
    public long lvConsumerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return UnsafeAccess.UNSAFE.getLongVolatile(self, C_INDEX_OFFSET);
    }

    @Override
    public void soProducerIndex(BaseMpscLinkedArrayQueue<?> self, long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(self, P_INDEX_OFFSET, v2);
    }

    @Override
    public boolean casProducerIndex(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(self, P_INDEX_OFFSET, expect, newValue);
    }

    @Override
    public void soConsumerIndex(BaseMpscLinkedArrayQueue<?> self, long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(self, C_INDEX_OFFSET, v2);
    }

    @Override
    public boolean casProducerLimit(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(self, P_LIMIT_OFFSET, expect, newValue);
    }

    @Override
    public void soProducerLimit(BaseMpscLinkedArrayQueue<?> self, long v2) {
        UnsafeAccess.UNSAFE.putOrderedLong(self, P_LIMIT_OFFSET, v2);
    }

    @Override
    public <E> void spElement(E[] buffer, long offset, E e2) {
        UnsafeAccess.UNSAFE.putObject(buffer, offset, e2);
    }

    @Override
    public <E> void soElement(E[] buffer, long offset, E e2) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e2);
    }

    @Override
    public <E> E lpElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObject(buffer, offset);
    }

    @Override
    public <E> E lvElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    @Override
    public long calcElementOffset(long index) {
        return REF_ARRAY_BASE + (index << REF_ELEMENT_SHIFT);
    }

    @Override
    public long modifiedCalcElementOffset(long index, long mask) {
        return REF_ARRAY_BASE + ((index & mask) << REF_ELEMENT_SHIFT - 1);
    }

    static {
        Field iField;
        try {
            iField = BaseMpscLinkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
        try {
            iField = BaseMpscLinkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException(e3);
        }
        try {
            iField = BaseMpscLinkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e4) {
            throw new RuntimeException(e4);
        }
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    }
}

