/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.ProcessListener;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.RendererRegistry;
import com.floreysoft.jmte.ScopedMap;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.encoder.Encoder;
import com.floreysoft.jmte.message.DefaultErrorHandler;
import com.floreysoft.jmte.message.ErrorEntry;
import com.floreysoft.jmte.message.SilentErrorHandler;
import com.floreysoft.jmte.renderer.DefaultCollectionRenderer;
import com.floreysoft.jmte.renderer.DefaultIterableRenderer;
import com.floreysoft.jmte.renderer.DefaultMapRenderer;
import com.floreysoft.jmte.renderer.DefaultObjectRenderer;
import com.floreysoft.jmte.template.DefaultOutputAppender;
import com.floreysoft.jmte.template.InterpretedTemplate;
import com.floreysoft.jmte.template.OutputAppender;
import com.floreysoft.jmte.template.Template;
import com.floreysoft.jmte.template.VariableDescription;
import com.floreysoft.jmte.token.IfToken;
import com.floreysoft.jmte.token.Token;
import com.floreysoft.jmte.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Engine
implements RendererRegistry {
    public static final String VERSION = "@version@";
    private String exprStartToken = "${";
    private String exprEndToken = "}";
    private double expansionSizeFactor = 2.0;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private ModelAdaptor modelAdaptor = new DefaultModelAdaptor();
    private Encoder encoder = null;
    private OutputAppender outputAppender = new DefaultOutputAppender();
    private final Map<Class<?>, Renderer<?>> renderers = new HashMap();
    private final Map<Class<?>, Renderer<?>> resolvedRendererCache = new HashMap();
    private final Map<String, AnnotationProcessor<?>> annotationProcessors = new HashMap();
    private final Map<String, NamedRenderer> namedRenderers = new HashMap<String, NamedRenderer>();
    private final Map<Class<?>, Set<NamedRenderer>> namedRenderersForClass = new HashMap();

    public static Engine createEngine() {
        Engine engine = new Engine();
        return engine;
    }

    public Engine() {
        this.init();
    }

    private void init() {
        this.registerRenderer(Object.class, new DefaultObjectRenderer());
        this.registerRenderer(Map.class, new DefaultMapRenderer());
        this.registerRenderer(Collection.class, new DefaultCollectionRenderer());
        this.registerRenderer(Iterable.class, new DefaultIterableRenderer());
    }

    public boolean variablesAvailable(Map<String, Object> model, String ... vars) {
        TemplateContext context = new TemplateContext(null, null, null, new ScopedMap(model), this.modelAdaptor, this, new SilentErrorHandler(), null);
        for (String var : vars) {
            IfToken token = new IfToken(var, false);
            if (((Boolean)token.evaluate(context)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized String transform(String template, Locale locale, String sourceName, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, locale, sourceName, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, String sourceName, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, sourceName, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, Locale locale, String sourceName, Map<String, Object> model) {
        return this.transformInternal(template, locale, sourceName, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, String sourceName, Map<String, Object> model) {
        return this.transformInternal(template, sourceName, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Locale locale, Map<String, Object> model) {
        return this.transformInternal(template, locale, null, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Map<String, Object> model) {
        return this.transformInternal(template, null, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, null, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, Locale locale, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, locale, null, model, this.getModelAdaptor(), processListener);
    }

    String transformInternal(String template, String sourceName, Map<String, Object> model, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        Locale locale = Locale.getDefault();
        return this.transformInternal(template, locale, sourceName, model, modelAdaptor, processListener);
    }

    String transformInternal(String template, Locale locale, String sourceName, Map<String, Object> model, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        if (template == null) {
            return null;
        }
        Template templateImpl = this.getTemplate(template, sourceName);
        String output = templateImpl.transform(model, locale, modelAdaptor, processListener);
        return output;
    }

    public synchronized String format(String pattern, final Object ... args2) {
        Map<String, Object> model = Collections.emptyMap();
        ModelAdaptor modelAdaptor = new ModelAdaptor(){

            @Override
            public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
                int index = Integer.parseInt(expression) - 1;
                return args2[index];
            }

            @Override
            public Iterable<Object> getIterable(Object value) {
                return null;
            }

            @Override
            public String getSpecialIteratorVariable() {
                return null;
            }
        };
        String output = this.transformInternal(pattern, null, model, modelAdaptor, null);
        return output;
    }

    @Deprecated
    public synchronized Set<String> getUsedVariables(String template) {
        Template templateImpl = this.getTemplate(template, null);
        return templateImpl.getUsedVariables();
    }

    public synchronized List<VariableDescription> getUsedVariableDescriptions(String template) {
        Template templateImpl = this.getTemplate(template, null);
        return templateImpl.getUsedVariableDescriptions();
    }

    public synchronized List<ErrorEntry> getStaticErrors(String template) {
        Template templateImpl = this.getTemplate(template, null);
        return templateImpl.getStaticErrors();
    }

    @Override
    public synchronized Engine registerNamedRenderer(NamedRenderer renderer) {
        this.namedRenderers.put(renderer.getName(), renderer);
        Set<Class<?>> supportedClasses = Util.asSet(renderer.getSupportedClasses());
        Iterator<Class<?>> iterator2 = supportedClasses.iterator();
        while (iterator2.hasNext()) {
            Class<?> clazz;
            for (Class<?> classInHierarchy = clazz = iterator2.next(); classInHierarchy != null; classInHierarchy = classInHierarchy.getSuperclass()) {
                this.addSupportedRenderer(classInHierarchy, renderer);
            }
        }
        return this;
    }

    @Override
    public synchronized Engine deregisterNamedRenderer(NamedRenderer renderer) {
        this.namedRenderers.remove(renderer.getName());
        Set<Class<?>> supportedClasses = Util.asSet(renderer.getSupportedClasses());
        Iterator<Class<?>> iterator2 = supportedClasses.iterator();
        while (iterator2.hasNext()) {
            Class<?> clazz;
            for (Class<?> classInHierarchy = clazz = iterator2.next(); classInHierarchy != null; classInHierarchy = classInHierarchy.getSuperclass()) {
                Set<NamedRenderer> renderers = this.namedRenderersForClass.get(classInHierarchy);
                renderers.remove(renderer);
            }
        }
        return this;
    }

    private void addSupportedRenderer(Class<?> clazz, NamedRenderer renderer) {
        Collection<NamedRenderer> compatibleRenderers = this.getCompatibleRenderers(clazz);
        compatibleRenderers.add(renderer);
    }

    @Override
    public synchronized Collection<NamedRenderer> getCompatibleRenderers(Class<?> inputType) {
        Set<NamedRenderer> renderers = this.namedRenderersForClass.get(inputType);
        if (renderers == null) {
            renderers = new HashSet<NamedRenderer>();
            this.namedRenderersForClass.put(inputType, renderers);
        }
        return renderers;
    }

    @Override
    public synchronized Collection<NamedRenderer> getAllNamedRenderers() {
        Collection<NamedRenderer> values2 = this.namedRenderers.values();
        return values2;
    }

    @Override
    public NamedRenderer resolveNamedRenderer(String rendererName) {
        return this.namedRenderers.get(rendererName);
    }

    public synchronized Engine registerAnnotationProcessor(AnnotationProcessor<?> annotationProcessor) {
        this.annotationProcessors.put(annotationProcessor.getType(), annotationProcessor);
        return this;
    }

    public synchronized Engine deregisterAnnotationProcessor(AnnotationProcessor<?> annotationProcessor) {
        this.annotationProcessors.remove(annotationProcessor.getType());
        return this;
    }

    AnnotationProcessor<?> resolveAnnotationProcessor(String type) {
        return this.annotationProcessors.get(type);
    }

    @Override
    public synchronized <C> Engine registerRenderer(Class<C> clazz, Renderer<C> renderer) {
        this.renderers.put(clazz, renderer);
        this.resolvedRendererCache.clear();
        return this;
    }

    @Override
    public synchronized Engine deregisterRenderer(Class<?> clazz) {
        this.renderers.remove(clazz);
        this.resolvedRendererCache.clear();
        return this;
    }

    @Override
    public <C> Renderer<C> resolveRendererForClass(Class<C> clazz) {
        Class<C> superclass;
        Renderer<Object> resolvedRenderer = this.resolvedRendererCache.get(clazz);
        if (resolvedRenderer != null) {
            return resolvedRenderer;
        }
        resolvedRenderer = this.renderers.get(clazz);
        if (resolvedRenderer == null) {
            Class<?> interfaze;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2 && (resolvedRenderer = this.resolveRendererForClass(interfaze = classArray[i2])) == null; ++i2) {
            }
        }
        if (resolvedRenderer == null && (superclass = clazz.getSuperclass()) != null) {
            resolvedRenderer = this.resolveRendererForClass(superclass);
        }
        if (resolvedRenderer != null) {
            this.resolvedRendererCache.put(clazz, resolvedRenderer);
        }
        return resolvedRenderer;
    }

    public synchronized void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public synchronized Encoder getEncoder() {
        return this.encoder;
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public synchronized ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized String getExprStartToken() {
        return this.exprStartToken;
    }

    public synchronized String getExprEndToken() {
        return this.exprEndToken;
    }

    public synchronized void setExprStartToken(String exprStartToken) {
        this.exprStartToken = exprStartToken;
    }

    public synchronized void setExprEndToken(String exprEndToken) {
        this.exprEndToken = exprEndToken;
    }

    public synchronized void setExpansionSizeFactor(double expansionSizeFactor) {
        this.expansionSizeFactor = expansionSizeFactor;
    }

    public synchronized double getExpansionSizeFactor() {
        return this.expansionSizeFactor;
    }

    public synchronized void setModelAdaptor(ModelAdaptor modelAdaptor) {
        this.modelAdaptor = modelAdaptor;
    }

    public synchronized ModelAdaptor getModelAdaptor() {
        return this.modelAdaptor;
    }

    public Template getTemplate(String template) {
        return this.getTemplate(template, null);
    }

    public Template getTemplate(String template, String sourceName) {
        return new InterpretedTemplate(template, sourceName, this);
    }

    public OutputAppender getOutputAppender() {
        return this.outputAppender;
    }

    public void setOutputAppender(OutputAppender outputAppender) {
        this.outputAppender = outputAppender;
    }
}

