/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalDateTimeDeserializer(format);
    }

    @Override
    public LocalDateTime deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, this, this.handledType()));
            }
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._fromArray(p2, ctxt);
        }
        return (LocalDateTime)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p2, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (LocalDateTime)this._fromEmptyString(p2, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        return this._format.createParser(ctxt).parseLocalDateTime(value);
    }

    protected LocalDateTime _fromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p2.nextToken();
        LocalDateTime dt2 = null;
        if (t2.isNumeric()) {
            int year = p2.getIntValue();
            t2 = p2.nextToken();
            if (t2.isNumeric()) {
                int month = p2.getIntValue();
                t2 = p2.nextToken();
                if (t2.isNumeric()) {
                    int day = p2.getIntValue();
                    t2 = p2.nextToken();
                    if (t2.isNumeric()) {
                        int hour = p2.getIntValue();
                        t2 = p2.nextToken();
                        if (t2.isNumeric()) {
                            int minute = p2.getIntValue();
                            t2 = p2.nextToken();
                            if (t2.isNumeric()) {
                                int second = p2.getIntValue();
                                t2 = p2.nextToken();
                                int millisecond = 0;
                                if (t2.isNumeric()) {
                                    millisecond = p2.getIntValue();
                                    t2 = p2.nextToken();
                                }
                                dt2 = new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                            }
                        }
                    }
                }
            }
        }
        if (t2 == JsonToken.END_ARRAY) {
            return dt2;
        }
        throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.END_ARRAY, "after LocalDateTime ints");
    }

    protected LocalDateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new LocalDateTime(ts, tz);
    }
}

