/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.sender;

import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.sender.AbstractSyslogMessageSender;
import com.cloudbees.syslog.util.CachingReference;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UdpSyslogMessageSender
extends AbstractSyslogMessageSender
implements Closeable {
    protected CachingReference<InetAddress> syslogServerHostnameReference;
    protected int syslogServerPort = 514;
    private DatagramSocket datagramSocket;

    public UdpSyslogMessageSender() {
        try {
            this.setSyslogServerHostname("localhost");
            this.datagramSocket = new DatagramSocket();
        }
        catch (IOException e2) {
            throw new IllegalStateException("Exception initializing datagramSocket", e2);
        }
    }

    @Override
    public void sendMessage(SyslogMessage message) throws IOException {
        this.sendCounter.incrementAndGet();
        long nanosBefore = System.nanoTime();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, UTF_8);
            message.toSyslogMessage(this.messageFormat, out);
            ((Writer)out).flush();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Send syslog message " + new String(baos.toByteArray(), UTF_8));
            }
            byte[] bytes = baos.toByteArray();
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.syslogServerHostnameReference.get(), this.syslogServerPort);
            this.datagramSocket.send(packet);
        }
        catch (IOException e2) {
            this.sendErrorCounter.incrementAndGet();
            throw e2;
        }
        catch (RuntimeException e3) {
            this.sendErrorCounter.incrementAndGet();
            throw e3;
        }
        finally {
            this.sendDurationInNanosCounter.addAndGet(System.nanoTime() - nanosBefore);
        }
    }

    @Override
    public void setSyslogServerHostname(final String syslogServerHostname) {
        this.syslogServerHostnameReference = new CachingReference<InetAddress>(DEFAULT_INET_ADDRESS_TTL_IN_NANOS){

            @Override
            @Nullable
            protected InetAddress newObject() {
                try {
                    return InetAddress.getByName(syslogServerHostname);
                }
                catch (UnknownHostException e2) {
                    throw new IllegalStateException(e2);
                }
            }
        };
    }

    @Override
    public void setSyslogServerPort(int syslogServerPort) {
        this.syslogServerPort = syslogServerPort;
    }

    @Nullable
    public String getSyslogServerHostname() {
        InetAddress inetAddress = this.syslogServerHostnameReference.get();
        return inetAddress == null ? null : inetAddress.getHostName();
    }

    public int getSyslogServerPort() {
        return this.syslogServerPort;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{syslogServerHostname='" + this.getSyslogServerHostname() + '\'' + ", syslogServerPort='" + this.getSyslogServerPort() + '\'' + ", defaultAppName='" + this.defaultAppName + '\'' + ", defaultFacility=" + this.defaultFacility + ", defaultMessageHostname='" + this.defaultMessageHostname + '\'' + ", defaultSeverity=" + (Object)((Object)this.defaultSeverity) + ", messageFormat=" + (Object)((Object)this.messageFormat) + ", sendCounter=" + this.sendCounter + ", sendDurationInNanosCounter=" + this.sendDurationInNanosCounter + ", sendErrorCounter=" + this.sendErrorCounter + '}';
    }

    @Override
    public void close() throws IOException {
        this.datagramSocket.close();
    }
}

