/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.integration.jul.util;

import com.cloudbees.syslog.Severity;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class LevelHelper {
    public static final List<Level> levels = Collections.unmodifiableList(Arrays.asList(Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL));
    public static final Map<String, Level> levelsByName;
    public static final Map<Integer, Level> levelsByValue;
    private static final Map<Level, Severity> julLevelToSyslogSeverity;

    @Nullable
    public static Level findLevel(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return Level.parse(name);
    }

    @Nullable
    public static Severity toSeverity(@Nullable Level level) {
        return julLevelToSyslogSeverity.get(level);
    }

    public static Comparator<Level> comparator() {
        return new Comparator<Level>(){

            @Override
            public int compare(Level l1, Level l2) {
                return Integer.compare(l1.intValue(), l2.intValue());
            }
        };
    }

    static {
        HashMap<String, Level> levelsByNameMap = new HashMap<String, Level>();
        HashMap<Integer, Level> levelsByValueMap = new HashMap<Integer, Level>();
        for (Level level : levels) {
            levelsByNameMap.put(level.getName(), level);
            levelsByValueMap.put(level.intValue(), level);
        }
        levelsByName = Collections.unmodifiableMap(levelsByNameMap);
        levelsByValue = Collections.unmodifiableMap(levelsByValueMap);
        julLevelToSyslogSeverity = Collections.unmodifiableMap(new HashMap<Level, Severity>(){
            {
                this.put(Level.CONFIG, Severity.INFORMATIONAL);
                this.put(Level.FINE, Severity.DEBUG);
                this.put(Level.FINER, Severity.DEBUG);
                this.put(Level.FINEST, Severity.DEBUG);
                this.put(Level.INFO, Severity.INFORMATIONAL);
                this.put(Level.SEVERE, Severity.ERROR);
                this.put(Level.WARNING, Severity.WARNING);
            }
        });
    }
}

