/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.FuzzyMap;
import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.IStringConverterInstanceFactory;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.IVariableArity;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.StringKey;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.converters.DefaultListConverter;
import com.beust.jcommander.converters.EnumConverter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.JDK6Console;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;

public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<FuzzyMap.IKey, ParameterDescription> descriptions;
    private List<Object> objects = Lists.newArrayList();
    private IUsageFormatter usageFormatter = new DefaultUsageFormatter(this);
    private MainParameter mainParameter = null;
    private Map<Parameterized, ParameterDescription> requiredFields = Maps.newHashMap();
    private Map<Parameterized, ParameterDescription> fields = Maps.newHashMap();
    private Map<ProgramName, JCommander> commands = Maps.newLinkedHashMap();
    private Map<FuzzyMap.IKey, ProgramName> aliasMap = Maps.newLinkedHashMap();
    private String parsedCommand;
    private String parsedAlias;
    private ProgramName programName;
    private boolean helpWasSpecified;
    private List<String> unknownArgs = Lists.newArrayList();
    private Console console;
    private final Options options;
    private final IVariableArity DEFAULT_VARIABLE_ARITY = new DefaultVariableArity();

    private JCommander(Options options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        if (options.converterInstanceFactories.isEmpty()) {
            this.addConverterFactory(new DefaultConverterFactory());
        }
    }

    public JCommander() {
        this(new Options());
    }

    public JCommander(Object object) {
        this(object, (ResourceBundle)null);
    }

    public JCommander(Object object, @Nullable ResourceBundle bundle) {
        this(object, bundle, (String[])null);
    }

    public JCommander(Object object, @Nullable ResourceBundle bundle, String ... args2) {
        this();
        this.addObject(object);
        if (bundle != null) {
            this.setDescriptionsBundle(bundle);
        }
        this.createDescriptions();
        if (args2 != null) {
            this.parse(args2);
        }
    }

    @Deprecated
    public JCommander(Object object, String ... args2) {
        this(object);
        this.parse(args2);
    }

    public void setExpandAtSign(boolean expandAtSign) {
        this.options.expandAtSign = expandAtSign;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public synchronized Console getConsole() {
        if (this.console == null) {
            try {
                Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
                Object console = consoleMethod.invoke(null, new Object[0]);
                this.console = new JDK6Console(console);
            }
            catch (Throwable t2) {
                this.console = new DefaultConsole();
            }
        }
        return this.console;
    }

    public final void addObject(Object object) {
        if (object instanceof Iterable) {
            for (Object o2 : (Iterable)object) {
                this.objects.add(o2);
            }
        } else if (object.getClass().isArray()) {
            for (Object o3 : (Object[])object) {
                this.objects.add(o3);
            }
        } else {
            this.objects.add(object);
        }
    }

    public final void setDescriptionsBundle(ResourceBundle bundle) {
        this.options.bundle = bundle;
    }

    public void parse(String ... args2) {
        try {
            this.parse(true, args2);
        }
        catch (ParameterException ex2) {
            ex2.setJCommander(this);
            throw ex2;
        }
    }

    public void parseWithoutValidation(String ... args2) {
        this.parse(false, args2);
    }

    private void parse(boolean validate, String ... args2) {
        StringBuilder sb = new StringBuilder("Parsing \"");
        sb.append(Strings.join(" ", args2)).append("\"\n  with:").append(Strings.join(" ", this.objects.toArray()));
        this.p(sb.toString());
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args2), validate);
        if (validate) {
            this.validateOptions();
        }
    }

    private void initializeDefaultValues() {
        if (this.options.defaultProvider != null) {
            for (ParameterDescription parameterDescription : this.descriptions.values()) {
                this.initializeDefaultValue(parameterDescription);
            }
            for (Map.Entry entry : this.commands.entrySet()) {
                ((JCommander)entry.getValue()).initializeDefaultValues();
            }
        }
    }

    private void validateOptions() {
        if (this.helpWasSpecified) {
            return;
        }
        if (!this.requiredFields.isEmpty()) {
            ArrayList<String> missingFields = new ArrayList<String>();
            for (ParameterDescription pd : this.requiredFields.values()) {
                missingFields.add("[" + Strings.join(" | ", pd.getParameter().names()) + "]");
            }
            String message = Strings.join(", ", missingFields);
            throw new ParameterException("The following " + JCommander.pluralize(this.requiredFields.size(), "option is required: ", "options are required: ") + message);
        }
        if (this.mainParameter != null && this.mainParameter.description != null) {
            int size;
            Object value;
            ParameterDescription mainParameterDescription = this.mainParameter.description;
            if (mainParameterDescription.getParameter().required() && !mainParameterDescription.isAssigned()) {
                throw new ParameterException("Main parameters are required (\"" + mainParameterDescription.getDescription() + "\")");
            }
            int arity = mainParameterDescription.getParameter().arity();
            if (arity != -1 && List.class.isAssignableFrom((value = mainParameterDescription.getParameterized().get(this.mainParameter.object)).getClass()) && (size = ((List)value).size()) != arity) {
                throw new ParameterException("There should be exactly " + arity + " main parameters but " + size + " were found");
            }
        }
    }

    private static String pluralize(int quantity, String singular, String plural) {
        return quantity == 1 ? singular : plural;
    }

    private String[] expandArgs(String[] originalArgv) {
        List<String> vResult1 = Lists.newArrayList();
        for (String arg : originalArgv) {
            if (arg.startsWith("@") && this.options.expandAtSign) {
                String fileName = arg.substring(1);
                vResult1.addAll(this.readFile(fileName));
                continue;
            }
            List<String> expanded = this.expandDynamicArg(arg);
            vResult1.addAll(expanded);
        }
        List vResult2 = Lists.newArrayList();
        for (String arg : vResult1) {
            if (this.isOption(arg)) {
                String sep = this.getSeparatorFor(arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    for (String ssp : sp = arg.split("[" + sep + "]", 2)) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private List<String> expandDynamicArg(String arg) {
        for (ParameterDescription pd : this.descriptions.values()) {
            if (!pd.isDynamicParameter()) continue;
            for (String name : pd.getParameter().names()) {
                if (!arg.startsWith(name) || arg.equals(name)) continue;
                return Arrays.asList(name, arg.substring(name.length()));
            }
        }
        return Arrays.asList(arg);
    }

    private boolean matchArg(String arg, FuzzyMap.IKey key) {
        String separator;
        ParameterDescription pd;
        String kn2;
        String string = kn2 = this.options.caseSensitiveOptions ? key.getName() : key.getName().toLowerCase();
        return this.options.allowAbbreviatedOptions ? kn2.startsWith(arg) : ((pd = this.descriptions.get(key)) != null ? (!" ".equals(separator = this.getSeparatorFor(arg)) ? arg.startsWith(kn2) : kn2.equals(arg)) : kn2.equals(arg));
    }

    private boolean isOption(String passedArg) {
        if (this.options.acceptUnknownOptions) {
            return true;
        }
        String arg = this.options.caseSensitiveOptions ? passedArg : passedArg.toLowerCase();
        for (FuzzyMap.IKey iKey : this.descriptions.keySet()) {
            if (!this.matchArg(arg, iKey)) continue;
            return true;
        }
        for (FuzzyMap.IKey iKey : this.commands.keySet()) {
            if (!this.matchArg(arg, iKey)) continue;
            return true;
        }
        return false;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<FuzzyMap.IKey, ParameterDescription> es2 : this.descriptions.entrySet()) {
            if (!Strings.startsWith(arg, es2.getKey().getName(), this.options.caseSensitiveOptions)) continue;
            return es2.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String arg) {
        return this.getPrefixDescriptionFor(arg);
    }

    private String getSeparatorFor(String arg) {
        Parameters p2;
        ParameterDescription pd = this.getDescriptionFor(arg);
        if (pd != null && (p2 = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p2.separators();
        }
        return " ";
    }

    private List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try (BufferedReader bufRead = Files.newBufferedReader(Paths.get(fileName, new String[0]), this.options.atFileCharset);){
            String line;
            while ((line = bufRead.readLine()) != null) {
                if (line.length() <= 0 || line.trim().startsWith("#")) continue;
                result.add(line);
            }
        }
        catch (IOException e2) {
            throw new ParameterException("Could not read file " + fileName + ": " + e2);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"") && result.endsWith("\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public void createDescriptions() {
        this.descriptions = Maps.newHashMap();
        for (Object object : this.objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        List<Parameterized> parameterizeds = Parameterized.parseArg(object);
        for (Parameterized parameterized : parameterizeds) {
            WrappedParameter wp = parameterized.getWrappedParameter();
            if (wp != null && wp.getParameter() != null) {
                Parameter annotation = wp.getParameter();
                Parameter p2 = annotation;
                if (p2.names().length == 0) {
                    this.p("Found main parameter:" + parameterized);
                    if (this.mainParameter != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.mainParameter + " and " + parameterized);
                    }
                    this.mainParameter = new MainParameter();
                    this.mainParameter.parameterized = parameterized;
                    this.mainParameter.object = object;
                    this.mainParameter.annotation = p2;
                    this.mainParameter.description = new ParameterDescription(object, p2, parameterized, this.options.bundle, this);
                    continue;
                }
                ParameterDescription pd = new ParameterDescription(object, p2, parameterized, this.options.bundle, this);
                for (String name : p2.names()) {
                    if (this.descriptions.containsKey(new StringKey(name))) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    this.fields.put(parameterized, pd);
                    this.descriptions.put(new StringKey(name), pd);
                    if (!p2.required()) continue;
                    this.requiredFields.put(parameterized, pd);
                }
                continue;
            }
            if (parameterized.getDelegateAnnotation() != null) {
                Object delegateObject = parameterized.get(object);
                if (delegateObject == null) {
                    throw new ParameterException("Delegate field '" + parameterized.getName() + "' cannot be null.");
                }
                this.addDescription(delegateObject);
                continue;
            }
            if (wp == null || wp.getDynamicParameter() == null) continue;
            DynamicParameter dp2 = wp.getDynamicParameter();
            for (String name : dp2.names()) {
                if (this.descriptions.containsKey(name)) {
                    throw new ParameterException("Found the option " + name + " multiple times");
                }
                this.p("Adding description for " + name);
                ParameterDescription pd = new ParameterDescription(object, dp2, parameterized, this.options.bundle, this);
                this.fields.put(parameterized, pd);
                this.descriptions.put(new StringKey(name), pd);
                if (!dp2.required()) continue;
                this.requiredFields.put(parameterized, pd);
            }
        }
    }

    private void initializeDefaultValue(ParameterDescription pd) {
        for (String optionName : pd.getParameter().names()) {
            String def = this.options.defaultProvider.getDefaultValueFor(optionName);
            if (def == null) continue;
            this.p("Initializing " + optionName + " with default value:" + def);
            pd.addValue(def, true);
            this.requiredFields.remove(pd.getParameterized());
            return;
        }
    }

    private void parseValues(String[] args2, boolean validate) {
        int increment;
        boolean commandParsed = false;
        boolean isDashDash = false;
        for (int i2 = 0; i2 < args2.length && !commandParsed; i2 += increment) {
            String a2;
            String arg = args2[i2];
            args2[i2] = a2 = JCommander.trim(arg);
            this.p("Parsing arg: " + a2);
            JCommander jc2 = this.findCommandByAlias(arg);
            increment = 1;
            if (!isDashDash && !"--".equals(a2) && this.isOption(a2) && jc2 == null) {
                ParameterDescription pd = this.findParameterDescription(a2);
                if (pd != null) {
                    if (pd.getParameter().password()) {
                        increment = this.processPassword(args2, i2, pd, validate);
                        continue;
                    }
                    if (pd.getParameter().variableArity()) {
                        increment = this.processVariableArity(args2, i2, pd, validate);
                        continue;
                    }
                    Class<?> fieldType = pd.getParameterized().getType();
                    if (pd.getParameter().arity() == -1 && this.isBooleanType(fieldType)) {
                        this.handleBooleanOption(pd, fieldType);
                    } else {
                        increment = this.processFixedArity(args2, i2, pd, validate, fieldType);
                    }
                    if (!pd.isHelp()) continue;
                    this.helpWasSpecified = true;
                    continue;
                }
                if (this.options.acceptUnknownOptions) {
                    this.unknownArgs.add(arg);
                    ++i2;
                    while (i2 < args2.length && !this.isOption(args2[i2])) {
                        this.unknownArgs.add(args2[i2++]);
                    }
                    increment = 0;
                    continue;
                }
                throw new ParameterException("Unknown option: " + arg);
            }
            if ("--".equals(arg) && !isDashDash) {
                isDashDash = true;
                continue;
            }
            if (this.commands.isEmpty()) {
                ParameterizedType p2;
                Type cls;
                Type genericType;
                this.initMainParameterValue(arg);
                String value = a2;
                Object convertedValue = value;
                if (this.mainParameter.annotation.converter() != null && this.mainParameter.annotation.converter() != NoConverter.class) {
                    convertedValue = this.convertValue(this.mainParameter.parameterized, this.mainParameter.parameterized.getType(), null, value);
                }
                if ((genericType = this.mainParameter.parameterized.getGenericType()) instanceof ParameterizedType && (cls = (p2 = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
                    convertedValue = this.convertValue(this.mainParameter.parameterized, (Class)cls, null, value);
                }
                for (Class<? extends IParameterValidator> validator : this.mainParameter.annotation.validateWith()) {
                    this.mainParameter.description.validateParameter(validator, "Default", value);
                }
                this.mainParameter.description.setAssigned(true);
                this.mainParameter.addValue(convertedValue);
                continue;
            }
            if (jc2 == null && validate) {
                throw new MissingCommandException("Expected a command, got " + arg, arg);
            }
            if (jc2 == null) continue;
            this.parsedCommand = jc2.programName.name;
            this.parsedAlias = arg;
            jc2.parse(validate, this.subArray(args2, i2 + 1));
            commandParsed = true;
        }
        for (ParameterDescription parameterDescription : this.descriptions.values()) {
            if (!parameterDescription.isAssigned()) continue;
            this.fields.get(parameterDescription.getParameterized()).setAssigned(true);
        }
    }

    private boolean isBooleanType(Class<?> fieldType) {
        return Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType);
    }

    private void handleBooleanOption(ParameterDescription pd, Class<?> fieldType) {
        Boolean value = (Boolean)pd.getParameterized().get(pd.getObject());
        if (value != null) {
            pd.addValue(value != false ? "false" : "true");
        } else if (!fieldType.isPrimitive()) {
            pd.addValue("true");
        }
        this.requiredFields.remove(pd.getParameterized());
    }

    private final int determineArity(String[] args2, int index, ParameterDescription pd, IVariableArity va) {
        List currentArgs = Lists.newArrayList();
        for (int j2 = index + 1; j2 < args2.length; ++j2) {
            currentArgs.add(args2[j2]);
        }
        return va.processVariableArity(pd.getParameter().names()[0], currentArgs.toArray(new String[0]));
    }

    private int processPassword(String[] args2, int index, ParameterDescription pd, boolean validate) {
        int passwordArity = this.determineArity(args2, index, pd, this.DEFAULT_VARIABLE_ARITY);
        if (passwordArity == 0) {
            char[] password = this.readPassword(pd.getDescription(), pd.getParameter().echoInput());
            pd.addValue(new String(password));
            this.requiredFields.remove(pd.getParameterized());
            return 1;
        }
        if (passwordArity == 1) {
            return this.processFixedArity(args2, index, pd, validate, List.class, 1);
        }
        throw new ParameterException("Password parameter must have at most 1 argument.");
    }

    private int processVariableArity(String[] args2, int index, ParameterDescription pd, boolean validate) {
        Object arg = pd.getObject();
        IVariableArity va = !(arg instanceof IVariableArity) ? this.DEFAULT_VARIABLE_ARITY : (IVariableArity)arg;
        int arity = this.determineArity(args2, index, pd, va);
        int result = this.processFixedArity(args2, index, pd, validate, List.class, arity);
        return result;
    }

    private int processFixedArity(String[] args2, int index, ParameterDescription pd, boolean validate, Class<?> fieldType) {
        int arity = pd.getParameter().arity();
        int n2 = arity != -1 ? arity : 1;
        return this.processFixedArity(args2, index, pd, validate, fieldType, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processFixedArity(String[] args2, int originalIndex, ParameterDescription pd, boolean validate, Class<?> fieldType, int arity) {
        int index = originalIndex;
        String arg = args2[index];
        if (arity == 0 && this.isBooleanType(fieldType)) {
            this.handleBooleanOption(pd, fieldType);
            return arity + 1;
        } else {
            if (arity == 0) {
                throw new ParameterException("Expected a value after parameter " + arg);
            }
            if (index >= args2.length - 1) throw new ParameterException("Expected a value after parameter " + arg);
            int offset = "--".equals(args2[index + 1]) ? 1 : 0;
            Object finalValue = null;
            if (index + arity >= args2.length) throw new ParameterException("Expected " + arity + " values after " + arg);
            for (int j2 = 1; j2 <= arity; ++j2) {
                String value = args2[index + j2 + offset];
                finalValue = pd.addValue(arg, value, false, validate, j2 - 1);
                this.requiredFields.remove(pd.getParameterized());
            }
            if (finalValue != null && validate) {
                pd.validateValueParameter(arg, finalValue);
            }
            index += arity + offset;
        }
        return arity + 1;
    }

    private char[] readPassword(String description, boolean echoInput) {
        this.getConsole().print(description + ": ");
        return this.getConsole().readPassword(echoInput);
    }

    private String[] subArray(String[] args2, int index) {
        int l2 = args2.length - index;
        String[] result = new String[l2];
        System.arraycopy(args2, index, result, 0, l2);
        return result;
    }

    private void initMainParameterValue(String arg) {
        if (this.mainParameter == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined in your arg class");
        }
        Object object = this.mainParameter.parameterized.get(this.mainParameter.object);
        Class<?> type = this.mainParameter.parameterized.getType();
        if (List.class.isAssignableFrom(type)) {
            List result = object == null ? Lists.newArrayList() : (List)object;
            if (this.mainParameter.firstTimeMainParameter) {
                result.clear();
                this.mainParameter.firstTimeMainParameter = false;
            }
            this.mainParameter.multipleValue = result;
            this.mainParameter.parameterized.set(this.mainParameter.object, result);
        }
    }

    public String getMainParameterDescription() {
        if (this.descriptions == null) {
            this.createDescriptions();
        }
        return this.mainParameter.annotation != null ? this.mainParameter.annotation.description() : null;
    }

    public void setProgramName(String name) {
        this.setProgramName(name, new String[0]);
    }

    public String getProgramName() {
        return this.programName == null ? null : this.programName.getName();
    }

    public String getProgramDisplayName() {
        return this.programName == null ? null : this.programName.getDisplayName();
    }

    public void setProgramName(String name, String ... aliases) {
        this.programName = new ProgramName(name, Arrays.asList(aliases));
    }

    public void usage() {
        StringBuilder sb = new StringBuilder();
        this.usageFormatter.usage(sb);
        this.getConsole().println(sb.toString());
    }

    public void setUsageFormatter(IUsageFormatter usageFormatter) {
        if (usageFormatter == null) {
            throw new IllegalArgumentException("Argument UsageFormatter must not be null");
        }
        this.usageFormatter = usageFormatter;
    }

    public IUsageFormatter getUsageFormatter() {
        return this.usageFormatter;
    }

    public Options getOptions() {
        return this.options;
    }

    public Map<FuzzyMap.IKey, ParameterDescription> getDescriptions() {
        return this.descriptions;
    }

    public MainParameter getMainParameter() {
        return this.mainParameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<Parameterized, ParameterDescription> getFields() {
        return this.fields;
    }

    public Comparator<? super ParameterDescription> getParameterDescriptionComparator() {
        return this.options.parameterDescriptionComparator;
    }

    public void setParameterDescriptionComparator(Comparator<? super ParameterDescription> c2) {
        this.options.parameterDescriptionComparator = c2;
    }

    public void setColumnSize(int columnSize) {
        this.options.columnSize = columnSize;
    }

    public int getColumnSize() {
        return this.options.columnSize;
    }

    public ResourceBundle getBundle() {
        return this.options.bundle;
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.fields.values());
    }

    public ParameterDescription getMainParameterValue() {
        return this.mainParameter.description;
    }

    private void p(String string) {
        if (this.options.verbose > 0 || System.getProperty(DEBUG_PROPERTY) != null) {
            this.getConsole().println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        this.options.defaultProvider = defaultProvider;
    }

    public void addConverterFactory(final IStringConverterFactory converterFactory) {
        this.addConverterInstanceFactory(new IStringConverterInstanceFactory(){

            @Override
            public IStringConverter<?> getConverterInstance(Parameter parameter, Class<?> forType, String optionName) {
                Class<? extends IStringConverter<?>> converterClass = converterFactory.getConverter(forType);
                try {
                    if (optionName == null) {
                        optionName = parameter.names().length > 0 ? parameter.names()[0] : "[Main class]";
                    }
                    return converterClass != null ? (IStringConverter)JCommander.instantiateConverter(optionName, converterClass) : null;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
                    throw new ParameterException(e2);
                }
            }
        });
    }

    public void addConverterInstanceFactory(IStringConverterInstanceFactory converterInstanceFactory) {
        this.options.converterInstanceFactories.add(0, converterInstanceFactory);
    }

    private IStringConverter<?> findConverterInstance(Parameter parameter, Class<?> forType, String optionName) {
        for (IStringConverterInstanceFactory f2 : this.options.converterInstanceFactories) {
            IStringConverter<?> result = f2.getConverterInstance(parameter, forType, optionName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(final Parameterized parameterized, Class type, String optionName, String value) {
        Parameter annotation = parameterized.getParameter();
        if (annotation == null) {
            return value;
        }
        if (optionName == null) {
            optionName = annotation.names().length > 0 ? annotation.names()[0] : "[Main class]";
        }
        IStringConverter<String> converter = null;
        if (type.isAssignableFrom(List.class)) {
            converter = JCommander.tryInstantiateConverter(optionName, annotation.listConverter());
        }
        if (type.isAssignableFrom(List.class) && converter == null) {
            IParameterSplitter splitter = JCommander.tryInstantiateConverter(null, annotation.splitter());
            converter = new DefaultListConverter(splitter, new IStringConverter(){

                public Object convert(String value) {
                    Type genericType = parameterized.findFieldGenericType();
                    return JCommander.this.convertValue(parameterized, genericType instanceof Class ? (Class)genericType : String.class, null, value);
                }
            });
        }
        if (converter == null) {
            converter = JCommander.tryInstantiateConverter(optionName, annotation.converter());
        }
        if (converter == null) {
            converter = this.findConverterInstance(annotation, type, optionName);
        }
        if (converter == null && type.isEnum()) {
            converter = new EnumConverter(optionName, type);
        }
        if (converter == null) {
            converter = new StringConverter();
        }
        return converter.convert(value);
    }

    private static <T> T tryInstantiateConverter(String optionName, Class<T> converterClass) {
        if (converterClass == NoConverter.class || converterClass == null) {
            return null;
        }
        try {
            return JCommander.instantiateConverter(optionName, converterClass);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ignore) {
            return null;
        }
    }

    private static <T> T instantiateConverter(String optionName, Class<? extends T> converterClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        for (Constructor<?> c2 : converterClass.getDeclaredConstructors()) {
            c2.setAccessible(true);
            Class<?>[] types = c2.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c2;
                continue;
            }
            if (types.length != 0) continue;
            ctor = c2;
        }
        return stringCtor != null ? (T)stringCtor.newInstance(optionName) : (ctor != null ? (T)ctor.newInstance(new Object[0]) : null);
    }

    public void addCommand(String name, Object object) {
        this.addCommand(name, object, new String[0]);
    }

    public void addCommand(Object object) {
        Parameters p2 = object.getClass().getAnnotation(Parameters.class);
        if (p2 != null && p2.commandNames().length > 0) {
            for (String commandName : p2.commandNames()) {
                this.addCommand(commandName, object);
            }
        } else {
            throw new ParameterException("Trying to add command " + object.getClass().getName() + " without specifying its names in @Parameters");
        }
    }

    public void addCommand(String name, Object object, String ... aliases) {
        JCommander jc2 = new JCommander(this.options);
        jc2.addObject(object);
        jc2.createDescriptions();
        jc2.setProgramName(name, aliases);
        ProgramName progName = jc2.programName;
        this.commands.put(progName, jc2);
        this.aliasMap.put(new StringKey(name), progName);
        for (String a2 : aliases) {
            StringKey alias = new StringKey(a2);
            if (((Object)alias).equals(name)) continue;
            ProgramName mappedName = this.aliasMap.get(alias);
            if (mappedName != null && !mappedName.equals(progName)) {
                throw new ParameterException("Cannot set alias " + alias + " for " + name + " command because it has already been defined for " + mappedName.name + " command");
            }
            this.aliasMap.put(alias, progName);
        }
    }

    public Map<String, JCommander> getCommands() {
        Map<String, JCommander> res = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.commands.entrySet()) {
            res.put(entry.getKey().name, entry.getValue());
        }
        return res;
    }

    public Map<ProgramName, JCommander> getRawCommands() {
        Map<ProgramName, JCommander> res = Maps.newLinkedHashMap();
        for (Map.Entry<ProgramName, JCommander> entry : this.commands.entrySet()) {
            res.put(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public String getParsedCommand() {
        return this.parsedCommand;
    }

    public String getParsedAlias() {
        return this.parsedAlias;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < count; ++i2) {
            result.append(" ");
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    private ParameterDescription findParameterDescription(String arg) {
        return FuzzyMap.findInMap(this.descriptions, new StringKey(arg), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private JCommander findCommand(ProgramName name) {
        return FuzzyMap.findInMap(this.commands, name, this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    private ProgramName findProgramName(String name) {
        return FuzzyMap.findInMap(this.aliasMap, new StringKey(name), this.options.caseSensitiveOptions, this.options.allowAbbreviatedOptions);
    }

    public JCommander findCommandByAlias(String commandOrAlias) {
        ProgramName progName = this.findProgramName(commandOrAlias);
        if (progName == null) {
            return null;
        }
        JCommander jc2 = this.findCommand(progName);
        if (jc2 == null) {
            throw new IllegalStateException("There appears to be inconsistency in the internal command database.  This is likely a bug. Please report.");
        }
        return jc2;
    }

    public void setVerbose(int verbose) {
        this.options.verbose = verbose;
    }

    public void setCaseSensitiveOptions(boolean b2) {
        this.options.caseSensitiveOptions = b2;
    }

    public void setAllowAbbreviatedOptions(boolean b2) {
        this.options.allowAbbreviatedOptions = b2;
    }

    public void setAcceptUnknownOptions(boolean b2) {
        this.options.acceptUnknownOptions = b2;
    }

    public List<String> getUnknownOptions() {
        return this.unknownArgs;
    }

    public void setAllowParameterOverwriting(boolean b2) {
        this.options.allowParameterOverwriting = b2;
    }

    public boolean isParameterOverwritingAllowed() {
        return this.options.allowParameterOverwriting;
    }

    public void setAtFileCharset(Charset charset) {
        this.options.atFileCharset = charset;
    }

    public static final class ProgramName
    implements FuzzyMap.IKey {
        private final String name;
        private final List<String> aliases;

        ProgramName(String name, List<String> aliases) {
            this.name = name;
            this.aliases = aliases;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            if (!this.aliases.isEmpty()) {
                sb.append("(");
                Iterator<String> aliasesIt = this.aliases.iterator();
                while (aliasesIt.hasNext()) {
                    sb.append(aliasesIt.next());
                    if (!aliasesIt.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProgramName other = (ProgramName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    public static class Builder {
        private JCommander jCommander = new JCommander();
        private String[] args = null;

        public Builder addObject(Object o2) {
            this.jCommander.addObject(o2);
            return this;
        }

        public Builder resourceBundle(ResourceBundle bundle) {
            this.jCommander.setDescriptionsBundle(bundle);
            return this;
        }

        public Builder args(String[] args2) {
            this.args = args2;
            return this;
        }

        public Builder console(Console console) {
            this.jCommander.setConsole(console);
            return this;
        }

        public Builder expandAtSign(Boolean expand) {
            this.jCommander.setExpandAtSign(expand);
            return this;
        }

        public Builder programName(String name) {
            this.jCommander.setProgramName(name);
            return this;
        }

        public Builder columnSize(int columnSize) {
            this.jCommander.setColumnSize(columnSize);
            return this;
        }

        public Builder defaultProvider(IDefaultProvider provider) {
            this.jCommander.setDefaultProvider(provider);
            return this;
        }

        public Builder addConverterFactory(IStringConverterFactory factory2) {
            this.jCommander.addConverterFactory(factory2);
            return this;
        }

        public Builder verbose(int verbose) {
            this.jCommander.setVerbose(verbose);
            return this;
        }

        public Builder allowAbbreviatedOptions(boolean b2) {
            this.jCommander.setAllowAbbreviatedOptions(b2);
            return this;
        }

        public Builder acceptUnknownOptions(boolean b2) {
            this.jCommander.setAcceptUnknownOptions(b2);
            return this;
        }

        public Builder allowParameterOverwriting(boolean b2) {
            this.jCommander.setAllowParameterOverwriting(b2);
            return this;
        }

        public Builder atFileCharset(Charset charset) {
            this.jCommander.setAtFileCharset(charset);
            return this;
        }

        public Builder addConverterInstanceFactory(IStringConverterInstanceFactory factory2) {
            this.jCommander.addConverterInstanceFactory(factory2);
            return this;
        }

        public Builder addCommand(Object command) {
            this.jCommander.addCommand(command);
            return this;
        }

        public Builder addCommand(String name, Object command, String ... aliases) {
            this.jCommander.addCommand(name, command, aliases);
            return this;
        }

        public Builder usageFormatter(IUsageFormatter usageFormatter) {
            this.jCommander.setUsageFormatter(usageFormatter);
            return this;
        }

        public JCommander build() {
            if (this.args != null) {
                this.jCommander.parse(this.args);
            }
            return this.jCommander;
        }
    }

    private class DefaultVariableArity
    implements IVariableArity {
        private DefaultVariableArity() {
        }

        @Override
        public int processVariableArity(String optionName, String[] options) {
            int i2;
            for (i2 = 0; i2 < options.length && !JCommander.this.isOption(options[i2]); ++i2) {
            }
            return i2;
        }
    }

    private static class Options {
        private ResourceBundle bundle;
        private IDefaultProvider defaultProvider;
        private Comparator<? super ParameterDescription> parameterDescriptionComparator = new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                WrappedParameter a0 = p0.getParameter();
                WrappedParameter a1 = p1.getParameter();
                if (a0 != null && a0.order() != -1 && a1 != null && a1.order() != -1) {
                    return Integer.compare(a0.order(), a1.order());
                }
                if (a0 != null && a0.order() != -1) {
                    return -1;
                }
                if (a1 != null && a1.order() != -1) {
                    return 1;
                }
                return p0.getLongestName().compareTo(p1.getLongestName());
            }
        };
        private int columnSize = 79;
        private boolean acceptUnknownOptions = false;
        private boolean allowParameterOverwriting = false;
        private boolean expandAtSign = true;
        private int verbose = 0;
        private boolean caseSensitiveOptions = true;
        private boolean allowAbbreviatedOptions = false;
        private final List<IStringConverterInstanceFactory> converterInstanceFactories = new CopyOnWriteArrayList<IStringConverterInstanceFactory>();
        private Charset atFileCharset = Charset.defaultCharset();

        private Options() {
        }
    }

    static class MainParameter {
        Parameterized parameterized;
        Object object;
        private Parameter annotation;
        private ParameterDescription description;
        private List<Object> multipleValue = null;
        private Object singleValue = null;
        private boolean firstTimeMainParameter = true;

        MainParameter() {
        }

        public ParameterDescription getDescription() {
            return this.description;
        }

        public void addValue(Object convertedValue) {
            if (this.multipleValue != null) {
                this.multipleValue.add(convertedValue);
            } else {
                if (this.singleValue != null) {
                    throw new ParameterException("Only one main parameter allowed but found several: \"" + this.singleValue + "\" and \"" + convertedValue + "\"");
                }
                this.singleValue = convertedValue;
                this.parameterized.set(this.object, convertedValue);
            }
        }
    }
}

