/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.GeneralizedRenderer;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.neo4j.shell.parameter.ParameterPrettyRenderer;
import org.neo4j.values.storable.DurationValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ParameterPrettyRendererImpl
implements ParameterPrettyRenderer {
    private static final Configuration CYPHER_DSL_PRETTY_CONF = Configuration.newConfig().withPrettyPrint(true).alwaysEscapeNames(false).withIndentStyle(Configuration.IndentStyle.SPACE).build();
    private final GeneralizedRenderer renderer = (GeneralizedRenderer)Renderer.getRenderer((Configuration)CYPHER_DSL_PRETTY_CONF, GeneralizedRenderer.class);

    ParameterPrettyRendererImpl() {
    }

    @Override
    public String pretty(Map<String, Value> value) {
        return this.renderer.render((Visitable)this.asCypherDslAst(value));
    }

    private Expression asCypherDslAst(Object input) {
        Value driverValue;
        Object object;
        if (input instanceof Value && ((object = (driverValue = (Value)input).asObject()) == null || object.getClass() != input.getClass())) {
            return this.asCypherDslAst(object);
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            return Cypher.sortedMapOf((Object[])map.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), this.asCypherDslAst(e.getValue()))).toArray());
        }
        if (input instanceof Iterable) {
            Iterable iterable = (Iterable)input;
            return Cypher.listOf(StreamSupport.stream(iterable.spliterator(), false).map(this::asCypherDslAst).toList());
        }
        if (input instanceof IsoDuration) {
            IsoDuration d = (IsoDuration)input;
            DurationValue neo4jDuration = DurationValue.duration((long)d.months(), (long)d.days(), (long)d.seconds(), (long)d.nanoseconds());
            return Cypher.duration((String)neo4jDuration.prettyPrint());
        }
        if (input instanceof Point) {
            Point p = (Point)input;
            if (Double.isNaN(p.z())) {
                return Cypher.point((Expression)this.literalMap("srid", p.srid(), "x", p.x(), "y", p.y()));
            }
            return Cypher.point((Expression)this.literalMap("srid", p.srid(), "x", p.x(), "y", p.y(), "z", p.z()));
        }
        return Cypher.literalOf((Object)input);
    }

    private Expression literalMap(Object ... entries) {
        Object[] expressions = new Object[entries.length];
        for (int i = 0; i < entries.length; i += 2) {
            expressions[i] = entries[i];
            expressions[i + 1] = Cypher.literalOf((Object)entries[i + 1]);
        }
        return Cypher.mapOf((Object[])expressions);
    }
}

