/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.GrowingArray;
import org.neo4j.cypher.internal.runtime.memory.DelegatingScopedHeapMemoryTracker;
import org.neo4j.cypher.internal.runtime.memory.MemoryTrackerForOperatorProvider;
import org.neo4j.cypher.internal.runtime.memory.QueryMemoryTracker;
import org.neo4j.cypher.internal.runtime.memory.TransactionBoundMemoryTrackerForOperatorProvider;
import org.neo4j.memory.HeapMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Uq!\u0002\u000b\u0016\u0011\u0003\u0011c!\u0002\u0013\u0016\u0011\u0003)\u0003\"\u0002\u0017\u0002\t\u0003ic\u0001\u0002\u0018\u0002\u0001=B\u0001bM\u0002\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0007Y\r!\t!!\u0005\u0007\tU\u000b\u0001A\u0016\u0005\t\u007f\u0019\u0011\t\u0011)A\u0005s!)AF\u0002C\u0001;\u001a!A%\u0006\u00016\u0011\u0015a\u0013\u0002\"\u0001?\u0011\u0019y\u0014\u0002)A\u0005\u0001\"11)\u0003Q\u0001\n\u0011Ca\u0001Y\u0005!\u0002\u0013\t\u0007\"B3\n\t\u00032\u0007\"\u00026\n\t\u0003Z\u0007\"B9\n\t\u0003\u0012\b\"\u0002;\n\t\u0003*\b\"\u0002@\n\t\u0003z\b\u0002CA\u0006\u0013\u0011\u0005Q#!\u0004\u00025Q\u0013\u0018mY6j]\u001e\fV/\u001a:z\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u000b\u0005Y9\u0012AB7f[>\u0014\u0018P\u0003\u0002\u00193\u00059!/\u001e8uS6,'B\u0001\u000e\u001c\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000f\u001e\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011adH\u0001\u0006]\u0016|GG\u001b\u0006\u0002A\u0005\u0019qN]4\u0004\u0001A\u00111%A\u0007\u0002+\tQBK]1dW&tw-U;feflU-\\8ssR\u0013\u0018mY6feN\u0011\u0011A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011#!F(qKJ\fGo\u001c:NK6|'/\u001f+sC\u000e\\WM]\n\u0003\u0007A\u0002\"aI\u0019\n\u0005I*\"!\t#fY\u0016<\u0017\r^5oON\u001bw\u000e]3e\u0011\u0016\f\u0007/T3n_JLHK]1dW\u0016\u0014\u0018AE9vKJLX*Z7pef$&/Y2lKJ\u0004\"aI\u0005\u0014\t%1c'\u000f\t\u0003G]J!\u0001O\u000b\u0003%E+XM]=NK6|'/\u001f+sC\u000e\\WM\u001d\t\u0003uqj\u0011a\u000f\u0006\u0003-uI!!P\u001e\u0003#!+\u0017\r]'f[>\u0014\u0018\u0010\u0016:bG.,'\u000fF\u00015\u00035iW-\\8ssR\u0013\u0018mY6feB\u0011!(Q\u0005\u0003\u0005n\u0012!\u0003T8dC2lU-\\8ssR\u0013\u0018mY6fe\u0006AR.Z7pef$&/Y2lKJ\u0004VM](qKJ\fGo\u001c:\u0011\u0005\u00153aB\u0001$\u0001\u001d\t9EK\u0004\u0002I':\u0011\u0011J\u0015\b\u0003\u0015Fs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059\u000b\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u00031eI!AF\f\u000315+Wn\u001c:z)J\f7m[3s!\u0016\u0014x\n]3sCR|'o\u0005\u0002\u0007/B\u0019\u0001,W.\u000e\u0003]I!AW\f\u0003\u0019\u001d\u0013xn^5oO\u0006\u0013(/Y=\u0011\u0005q\u001bQ\"A\u0001\u0015\u0005y{\u0006C\u0001/\u0007\u0011\u0015y\u0004\u00021\u0001:\u0003)qWm\u001e+sC\u000e\\WM\u001d\t\u0004O\t$\u0017BA2)\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002F\u0007\u0005\t\u0002.Z1q\u0011&<\u0007nV1uKJl\u0015M]6\u0015\u0003\u001d\u0004\"a\n5\n\u0005%D#\u0001\u0002'p]\u001e\fA\"\u00197m_\u000e\fG/\u001a%fCB$\"\u0001\\8\u0011\u0005\u001dj\u0017B\u00018)\u0005\u0011)f.\u001b;\t\u000bA|\u0001\u0019A4\u0002\u000b\tLH/Z:\u0002\u0017I,G.Z1tK\"+\u0017\r\u001d\u000b\u0003YNDQ\u0001\u001d\tA\u0002\u001d\f1E\\3x\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:G_J|\u0005/\u001a:bi>\u0014\bK]8wS\u0012,'\u000f\u0006\u0002wsB\u00111e^\u0005\u0003qV\u0011\u0001%T3n_JLHK]1dW\u0016\u0014hi\u001c:Pa\u0016\u0014\u0018\r^8s!J|g/\u001b3fe\")!0\u0005a\u0001w\u0006ABO]1og\u0006\u001cG/[8o\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0011\u0005ib\u0018BA?<\u00055iU-\\8ssR\u0013\u0018mY6fe\u0006Y\u0002.Z1q\u0011&<\u0007nV1uKJl\u0015M]6PM>\u0003XM]1u_J$2aZA\u0001\u0011\u001d\t\u0019A\u0005a\u0001\u0003\u000b\t!b\u001c9fe\u0006$xN]%e!\r9\u0013qA\u0005\u0004\u0003\u0013A#aA%oi\u0006AR.Z7pef$&/Y2lKJ4uN](qKJ\fGo\u001c:\u0015\u0007\u0011\fy\u0001C\u0004\u0002\u0004M\u0001\r!!\u0002\u0015\u0007m\u000b\u0019\u0002C\u00034\u000b\u0001\u0007A\u0007")
public class TrackingQueryMemoryTracker
implements QueryMemoryTracker,
HeapMemoryTracker {
    private final LocalMemoryTracker memoryTracker;
    private final MemoryTrackerPerOperator memoryTrackerPerOperator;
    private final Function0<OperatorMemoryTracker> newTracker;

    @Override
    public void debugPrintSummary() {
        QueryMemoryTracker.debugPrintSummary$(this);
    }

    public long heapHighWaterMark() {
        return this.memoryTracker.heapHighWaterMark();
    }

    public void allocateHeap(long bytes) {
        this.memoryTracker.allocateHeap(bytes);
    }

    public void releaseHeap(long bytes) {
        this.memoryTracker.releaseHeap(bytes);
    }

    @Override
    public MemoryTrackerForOperatorProvider newMemoryTrackerForOperatorProvider(MemoryTracker transactionMemoryTracker) {
        return new TransactionBoundMemoryTrackerForOperatorProvider(transactionMemoryTracker, this);
    }

    @Override
    public long heapHighWaterMarkOfOperator(int operatorId) {
        if (this.memoryTrackerPerOperator.isDefinedAt(operatorId)) {
            return ((DelegatingScopedHeapMemoryTracker)this.memoryTrackerPerOperator.get(operatorId)).heapHighWaterMark();
        }
        return -1L;
    }

    public OperatorMemoryTracker memoryTrackerForOperator(int operatorId) {
        return this.memoryTrackerPerOperator.computeIfAbsent(operatorId, this.newTracker);
    }

    public TrackingQueryMemoryTracker() {
        QueryMemoryTracker.$init$(this);
        this.memoryTracker = new LocalMemoryTracker();
        this.memoryTrackerPerOperator = new MemoryTrackerPerOperator(this);
        this.newTracker = (Function0 & Serializable)() -> new OperatorMemoryTracker(this);
    }

    public static class MemoryTrackerPerOperator
    extends GrowingArray<OperatorMemoryTracker> {
        public MemoryTrackerPerOperator(HeapMemoryTracker memoryTracker) {
            super(memoryTracker);
        }
    }

    public static class OperatorMemoryTracker
    extends DelegatingScopedHeapMemoryTracker {
        public OperatorMemoryTracker(TrackingQueryMemoryTracker queryMemoryTracker) {
            super(queryMemoryTracker);
        }
    }
}

