/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.string.Mask;

public class DynamicRecord
extends AbstractBaseRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DynamicRecord.class);
    public static final byte[] NO_DATA = ArrayUtils.EMPTY_BYTE_ARRAY;
    private static final int MAX_BYTES_IN_TO_STRING = 8;
    private static final int MAX_CHARS_IN_TO_STRING = 16;
    private byte[] data;
    private long nextBlock;
    private int type;
    private boolean startRecord;

    public DynamicRecord(DynamicRecord other) {
        super(other);
        this.data = Arrays.copyOf(other.data, other.data.length);
        this.nextBlock = other.nextBlock;
        this.type = other.type;
        this.startRecord = other.startRecord;
    }

    public DynamicRecord(long id) {
        super(id);
    }

    public DynamicRecord initialize(boolean inUse, boolean isStartRecord, long nextBlock, int type) {
        super.initialize(inUse);
        this.startRecord = isStartRecord;
        this.nextBlock = nextBlock;
        this.type = type;
        this.data = NO_DATA;
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, true, Record.NO_NEXT_BLOCK.intValue(), -1);
    }

    public void setStartRecord(boolean startRecord) {
        this.startRecord = startRecord;
    }

    public boolean isStartRecord() {
        return this.startRecord;
    }

    public PropertyType getType() {
        return PropertyType.getPropertyTypeOrNull(this.type << 24);
    }

    public int getTypeAsInt() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setInUse(boolean inUse, int type) {
        this.type = type;
        this.setInUse(inUse);
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getLength() {
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public String toString(Mask mask) {
        StringBuilder buf = new StringBuilder();
        buf.append("DynamicRecord[").append(this.getId()).append(",used=").append(this.inUse()).append(',').append('(').append(mask.filter((Object)this.data.length)).append("),type=");
        PropertyType type = this.getType();
        if (type == null) {
            buf.append(this.type);
        } else {
            buf.append(type.name());
        }
        buf.append(",data=");
        mask.build(buf, this::buildDataString);
        buf.append(",start=").append(this.startRecord).append(",next=").append(this.nextBlock).append(",created=").append(this.isCreated()).append(']');
        return buf.toString();
    }

    private void buildDataString(StringBuilder buf) {
        if (this.getType() == PropertyType.STRING && this.data.length <= 16) {
            buf.append('\"');
            buf.append(PropertyStore.decodeString(this.data));
            buf.append("\"");
        } else {
            buf.append("byte[");
            if (this.data.length <= 8) {
                for (int i = 0; i < this.data.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(this.data[i]);
                }
            } else {
                buf.append("size=").append(this.data.length);
            }
            buf.append("]");
        }
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.nextBlock, this.type, this.startRecord);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicRecord that = (DynamicRecord)o;
        return this.nextBlock == that.nextBlock && this.type == that.type && this.startRecord == that.startRecord && Arrays.equals(this.data, that.data);
    }
}

