/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.BitBuffer;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DynamicArrayStore
extends AbstractDynamicStore {
    public static final int NUMBER_HEADER_SIZE = 3;
    public static final int STRING_HEADER_SIZE = 5;
    public static final int GEOMETRY_HEADER_SIZE = 6;
    public static final int TEMPORAL_HEADER_SIZE = 2;
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";

    public DynamicArrayStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config configuration, RecordIdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, int dataSizeFromConfiguration, RecordFormats recordFormats, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, configuration, (IdType)idType, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, TYPE_DESCRIPTOR, dataSizeFromConfiguration, recordFormats.dynamic(), readOnly, databaseName, openOptions);
    }

    public static byte[] encodeFromNumbers(Object array, int offsetBytes) {
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        if (type == ShortArray.DOUBLE || type == ShortArray.FLOAT) {
            return DynamicArrayStore.createUncompactedArray(type, array, offsetBytes);
        }
        return DynamicArrayStore.createBitCompactedArray(type, array, offsetBytes);
    }

    private static byte[] createBitCompactedArray(ShortArray type, Object array, int offsetBytes) {
        Class<?> componentType = array.getClass().getComponentType();
        boolean isPrimitiveByteArray = componentType.equals(Byte.TYPE);
        boolean isByteArray = componentType.equals(Byte.class) || isPrimitiveByteArray;
        int arrayLength = Array.getLength(array);
        int requiredBits = isByteArray ? 8 : type.calculateRequiredBitsForArray(array, arrayLength);
        int totalBits = requiredBits * arrayLength;
        int bitsUsedInLastByte = totalBits % 8;
        int n = bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        if (isByteArray) {
            return DynamicArrayStore.createBitCompactedByteArray(type, isPrimitiveByteArray, array, bitsUsedInLastByte, requiredBits, offsetBytes);
        }
        int numberOfBytes = (totalBits - 1) / 8 + 1;
        BitBuffer bits = BitBuffer.bits((int)(numberOfBytes += 3));
        bits.put((byte)type.intValue());
        bits.put((byte)bitsUsedInLastByte);
        bits.put((byte)requiredBits);
        type.writeAll(array, arrayLength, requiredBits, bits);
        return bits.asBytes(offsetBytes);
    }

    private static byte[] createBitCompactedByteArray(ShortArray type, boolean isPrimitiveByteArray, Object array, int bitsUsedInLastByte, int requiredBits, int offsetBytes) {
        int arrayLength = Array.getLength(array);
        byte[] bytes = new byte[3 + arrayLength + offsetBytes];
        bytes[offsetBytes] = (byte)type.intValue();
        bytes[offsetBytes + 1] = (byte)bitsUsedInLastByte;
        bytes[offsetBytes + 2] = (byte)requiredBits;
        if (isPrimitiveByteArray) {
            System.arraycopy(array, 0, bytes, 3 + offsetBytes, arrayLength);
        } else {
            Byte[] source = (Byte[])array;
            for (int i = 0; i < source.length; ++i) {
                bytes[3 + offsetBytes + i] = source[i];
            }
        }
        return bytes;
    }

    private static byte[] createUncompactedArray(ShortArray type, Object array, int offsetBytes) {
        int arrayLength = Array.getLength(array);
        int bytesPerElement = type.maxBits / 8;
        byte[] bytes = new byte[3 + bytesPerElement * arrayLength + offsetBytes];
        bytes[offsetBytes] = (byte)type.intValue();
        bytes[offsetBytes + 1] = 8;
        bytes[offsetBytes + 2] = (byte)type.maxBits;
        type.writeAll(array, bytes, 3 + offsetBytes);
        return bytes;
    }

    public static void allocateFromNumbers(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        byte[] bytes = DynamicArrayStore.encodeFromNumbers(array, 0);
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes, recordAllocator, cursorContext, memoryTracker);
    }

    private static void allocateFromCompositeType(Collection<DynamicRecord> target, byte[] bytes, DynamicRecordAllocator recordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        DynamicArrayStore.allocateRecordsFromBytes(target, bytes, recordAllocator, cursorContext, memoryTracker);
    }

    private static void allocateFromString(Collection<DynamicRecord> target, String[] array, DynamicRecordAllocator recordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        byte[][] stringsAsBytes = new byte[array.length][];
        int totalBytesRequired = 5;
        for (int i = 0; i < array.length; ++i) {
            String string = array[i];
            byte[] bytes = PropertyStore.encodeString(string);
            stringsAsBytes[i] = bytes;
            totalBytesRequired += 4 + bytes.length;
        }
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(totalBytesRequired, ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            buffer.put(PropertyType.STRING.byteValue());
            buffer.putInt(array.length);
            for (byte[] stringAsBytes : stringsAsBytes) {
                buffer.putInt(stringAsBytes.length);
                buffer.put(stringAsBytes);
            }
            DynamicArrayStore.allocateRecordsFromBytes(target, buffer.array(), recordAllocator, cursorContext, memoryTracker);
        }
    }

    public static void allocateRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator recordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            DynamicArrayStore.allocateFromString(target, (String[])array, recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(PointValue.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, GeometryType.encodePointArray((PointValue[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(LocalDate.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDateArray((LocalDate[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(LocalTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeLocalTimeArray((LocalTime[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(LocalDateTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeLocalDateTimeArray((LocalDateTime[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(OffsetTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeTimeArray((OffsetTime[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(ZonedDateTime.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDateTimeArray((ZonedDateTime[])array), recordAllocator, cursorContext, memoryTracker);
        } else if (type.equals(DurationValue.class)) {
            DynamicArrayStore.allocateFromCompositeType(target, TemporalType.encodeDurationArray((DurationValue[])array), recordAllocator, cursorContext, memoryTracker);
        } else {
            DynamicArrayStore.allocateFromNumbers(target, array, recordAllocator, cursorContext, memoryTracker);
        }
    }

    public static ArrayValue getRightArray(byte[] header, byte[] bArray) {
        byte typeId = header[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header, 1, header.length - 1);
            int arrayLength = headerBuffer.getInt();
            String[] result = new String[arrayLength];
            ByteBuffer dataBuffer = ByteBuffer.wrap(bArray);
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = dataBuffer.getInt();
                byte[] stringByteArray = new byte[byteLength];
                dataBuffer.get(stringByteArray);
                result[i] = PropertyStore.decodeString(stringByteArray);
            }
            return Values.stringArray((String[])result);
        }
        if (typeId == PropertyType.GEOMETRY.intValue()) {
            GeometryType.GeometryHeader geometryHeader = GeometryType.GeometryHeader.fromArrayHeaderBytes(header);
            return GeometryType.decodeGeometryArray(geometryHeader, bArray);
        }
        if (typeId == PropertyType.TEMPORAL.intValue()) {
            TemporalType.TemporalHeader temporalHeader = TemporalType.TemporalHeader.fromArrayHeaderBytes(header);
            return TemporalType.decodeTemporalArray(temporalHeader, bArray);
        }
        return DynamicArrayStore.getNumbersArray(header, bArray);
    }

    public static ArrayValue getNumbersArray(byte[] header, byte[] bArray) {
        byte typeId = header[0];
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = header[1];
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        if (type == ShortArray.BYTE && requiredBits == 8) {
            return Values.byteArray((byte[])bArray);
        }
        BitBuffer bits = BitBuffer.bitsFromBytes((byte[])bArray);
        int length = (bArray.length * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
        return type.createArray(length, bits, requiredBits);
    }

    public Value getArrayFor(Iterable<DynamicRecord> records, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        AbstractDynamicStore.HeavyRecordData data = this.readFullByteArray(records, PropertyType.ARRAY, storeCursors, memoryTracker);
        byte[] header = data.header();
        byte[] bArray = data.data();
        return DynamicArrayStore.getRightArray(header, bArray);
    }
}

