/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

class NodeContext {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeContext.class);
    private final MemoryTracker memoryTracker;
    private boolean hasExclusiveGroupLock;
    private boolean hasAnyEmptyGroup;
    private boolean hasEmptyFirstGroup;
    private RecordAccess.RecordProxy<NodeRecord, Void> node;
    private MutableIntObjectMap<DenseContext> denseContexts;
    private long groupStartingId;
    private long groupStartingPrevId = Record.NULL_REFERENCE.longValue();

    static NodeContext createNodeContext(RecordAccess.RecordProxy<NodeRecord, Void> node, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new NodeContext(node, memoryTracker);
    }

    private NodeContext(RecordAccess.RecordProxy<NodeRecord, Void> node, MemoryTracker memoryTracker) {
        this.node = node;
        this.groupStartingId = node.forReadingLinkage().getNextRel();
        this.memoryTracker = memoryTracker;
    }

    DenseContext denseContext(int type) {
        if (this.denseContexts == null) {
            this.denseContexts = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)this.memoryTracker);
        }
        return (DenseContext)this.denseContexts.getIfAbsentPut(type, (Function0 & Serializable)() -> new DenseContext(this.memoryTracker));
    }

    DenseContext denseContextIfExists(int type) {
        return this.denseContexts != null ? (DenseContext)this.denseContexts.get(type) : null;
    }

    void clearDenseContext() {
        if (this.denseContexts != null) {
            this.denseContexts.forEachValue((Procedure & Serializable)ctx -> {
                ctx.group = null;
            });
        }
        this.groupStartingPrevId = Record.NULL_REFERENCE.longValue();
    }

    void markExclusiveGroupLock() {
        this.hasExclusiveGroupLock = true;
        this.clearDenseContext();
    }

    boolean hasExclusiveGroupLock() {
        return this.hasExclusiveGroupLock;
    }

    RecordAccess.RecordProxy<NodeRecord, Void> node() {
        return this.node;
    }

    void setNode(RecordAccess.RecordProxy<NodeRecord, Void> node) {
        this.node = node;
    }

    void setCurrentGroup(RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group) {
        if (group != null) {
            this.groupStartingId = group.getKey();
            this.groupStartingPrevId = group.forReadingLinkage().getPrev();
        } else {
            this.groupStartingId = Record.NULL_REFERENCE.longValue();
            this.groupStartingPrevId = Record.NULL_REFERENCE.longValue();
        }
    }

    void checkEmptyGroup(RelationshipGroupRecord group) {
        if (!group.isCreated() && group.inUse() && RelationshipGroupGetter.groupIsEmpty(group)) {
            this.hasAnyEmptyGroup = true;
            if (Record.isNull(group.getPrev())) {
                this.hasEmptyFirstGroup = true;
            }
        }
    }

    boolean hasAnyEmptyGroup() {
        return this.hasAnyEmptyGroup;
    }

    boolean hasEmptyFirstGroup() {
        return this.hasEmptyFirstGroup;
    }

    long groupStartingId() {
        return this.groupStartingId;
    }

    long groupStartingPrevId() {
        return this.groupStartingPrevId;
    }

    static class DenseContext {
        private static final int NUM_INSERTION_POINTS = 3;
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DenseContext.class) + HeapEstimator.shallowSizeOfObjectArray((int)3);
        private final RecordAccess.RecordProxy<RelationshipRecord, Void>[] insertionPoints = new RecordAccess.RecordProxy[3];
        private long groupId = Record.NULL_REFERENCE.longValue();
        private RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group;

        DenseContext(MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(SHALLOW_SIZE);
        }

        RelationshipGroupRecord getOrLoadGroup(RelationshipGroupGetter relationshipGroupGetter, NodeRecord node, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
            if (this.group == null) {
                if (!Record.isNull(this.groupId)) {
                    this.group = relGroupRecords.getOrLoad(this.groupId, null);
                } else {
                    this.setGroup(relationshipGroupGetter.getRelationshipGroup(node, type, relGroupRecords, RelationshipGroupGetter.RelationshipGroupMonitor.EMPTY).group());
                }
            }
            return this.group.forReadingLinkage();
        }

        void setGroup(RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group) {
            this.group = group;
            this.groupId = group.getKey();
        }

        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group() {
            return this.group;
        }

        RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint(int directionIndex) {
            return this.insertionPoints[directionIndex];
        }

        void setInsertionPoint(int directionIndex, RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint) {
            this.insertionPoints[directionIndex] = insertionPoint;
        }

        void markInsertionPointsAsChanged() {
            for (RecordAccess.RecordProxy<RelationshipRecord, Void> insertion : this.insertionPoints) {
                if (insertion == null) continue;
                insertion.forChangingData();
            }
        }
    }
}

