/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.storageengine.api.CommandVersion;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class NeoStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final CommandVersion version;
    private final TransactionApplicationMode mode;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;

    NeoStoreTransactionApplierFactory(TransactionApplicationMode mode, NeoStores store, CacheAccessBackDoor cacheAccess) {
        this.version = mode.version();
        this.mode = mode;
        this.neoStores = store;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        return new NeoStoreTransactionApplier(this.mode, this.version, this.neoStores, this.cacheAccess, batchContext, transaction.cursorContext(), transaction.storeCursors());
    }
}

