/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsStore;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.MultiVersionCountsStoreTransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

class MultiversionCountStoreTransactionApplierFactory
implements TransactionApplierFactory {
    private final TransactionApplicationMode mode;
    private final CountsStore countsStore;

    MultiversionCountStoreTransactionApplierFactory(TransactionApplicationMode mode, CountsStore countsStore) {
        this.mode = mode;
        this.countsStore = countsStore;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        return switch (this.mode) {
            case TransactionApplicationMode.REVERSE_RECOVERY -> new TransactionApplier.Adapter();
            case TransactionApplicationMode.MVCC_ROLLBACK -> new MultiVersionCountsStoreTransactionApplier(() -> this.countsStore.rollbackUpdater(transaction.transactionId(), transaction.cursorContext()));
            default -> new MultiVersionCountsStoreTransactionApplier(() -> this.countsStore.updater(transaction.transactionId(), transaction.commandBatch().isLast(), transaction.cursorContext()));
        };
    }
}

