/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.storageengine.api.UpdateMode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CommandSelector {
    NORMAL{

        @Override
        <RECORD extends AbstractBaseRecord> RECORD getBefore(Command.BaseCommand<RECORD> command) {
            return command.before;
        }

        @Override
        <RECORD extends AbstractBaseRecord> RECORD getAfter(Command.BaseCommand<RECORD> command) {
            return command.after;
        }

        @Override
        <T> T getBefore(IndexUpdateCommand<T> command) {
            return command.getBefore();
        }

        @Override
        <T> T getAfter(IndexUpdateCommand<T> command) {
            return command.getAfter();
        }

        @Override
        <T> UpdateMode mode(IndexUpdateCommand<T> command) {
            return command.getUpdateMode();
        }
    }
    ,
    REVERSE{

        @Override
        <RECORD extends AbstractBaseRecord> RECORD getBefore(Command.BaseCommand<RECORD> command) {
            return command.after;
        }

        @Override
        <RECORD extends AbstractBaseRecord> RECORD getAfter(Command.BaseCommand<RECORD> command) {
            return command.before;
        }

        @Override
        <T> T getBefore(IndexUpdateCommand<T> command) {
            return command.getAfter();
        }

        @Override
        <T> T getAfter(IndexUpdateCommand<T> command) {
            return command.getBefore();
        }

        @Override
        <T> UpdateMode mode(IndexUpdateCommand<T> command) {
            return switch (command.getUpdateMode()) {
                default -> throw new IncompatibleClassChangeError();
                case UpdateMode.ADDED -> UpdateMode.REMOVED;
                case UpdateMode.REMOVED -> UpdateMode.ADDED;
                case UpdateMode.CHANGED -> UpdateMode.CHANGED;
            };
        }
    };


    abstract <RECORD extends AbstractBaseRecord> RECORD getBefore(Command.BaseCommand<RECORD> var1);

    abstract <RECORD extends AbstractBaseRecord> RECORD getAfter(Command.BaseCommand<RECORD> var1);

    abstract <T> T getBefore(IndexUpdateCommand<T> var1);

    abstract <T> T getAfter(IndexUpdateCommand<T> var1);

    abstract <T> UpdateMode mode(IndexUpdateCommand<T> var1);
}

