/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.annotations.documented.DocumentedUtils;
import org.neo4j.annotations.documented.Warning;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.synthetic.CountsEntry;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class ConsistencyReporter
implements ConsistencyReport.Reporter {
    private static final ProxyFactory<ConsistencyReport.SchemaConsistencyReport> SCHEMA_REPORT = ProxyFactory.create(ConsistencyReport.SchemaConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.NodeConsistencyReport> NODE_REPORT = ProxyFactory.create(ConsistencyReport.NodeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipConsistencyReport> RELATIONSHIP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyConsistencyReport> PROPERTY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipTypeConsistencyReport> RELATIONSHIP_TYPE_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipTypeConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelTokenConsistencyReport> LABEL_KEY_REPORT = ProxyFactory.create(ConsistencyReport.LabelTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.PropertyKeyTokenConsistencyReport> PROPERTY_KEY_REPORT = ProxyFactory.create(ConsistencyReport.PropertyKeyTokenConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicConsistencyReport> DYNAMIC_REPORT = ProxyFactory.create(ConsistencyReport.DynamicConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.DynamicLabelConsistencyReport> DYNAMIC_LABEL_REPORT = ProxyFactory.create(ConsistencyReport.DynamicLabelConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.LabelScanConsistencyReport> LABEL_SCAN_REPORT = ProxyFactory.create(ConsistencyReport.LabelScanConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipTypeScanConsistencyReport> RELATIONSHIP_TYPE_SCAN_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipTypeScanConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.IndexConsistencyReport> INDEX_REPORT = ProxyFactory.create(ConsistencyReport.IndexConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.RelationshipGroupConsistencyReport> RELATIONSHIP_GROUP_REPORT = ProxyFactory.create(ConsistencyReport.RelationshipGroupConsistencyReport.class);
    private static final ProxyFactory<ConsistencyReport.CountsConsistencyReport> COUNTS_REPORT = ProxyFactory.create(ConsistencyReport.CountsConsistencyReport.class);
    private final InconsistencyReport report;
    private final Monitor monitor;
    public static final Monitor NO_MONITOR = (report, method, message, isError) -> {};

    public ConsistencyReporter(InconsistencyReport report) {
        this(report, NO_MONITOR);
    }

    public ConsistencyReporter(InconsistencyReport report, Monitor monitor) {
        this.report = report;
        this.monitor = monitor;
    }

    public static FormattingDocumentedHandler formattingHandler(InconsistencyReport report, RecordType type) {
        return new FormattingDocumentedHandler(report, type);
    }

    @Override
    public ConsistencyReport.SchemaConsistencyReport forSchema(SchemaRecord schema) {
        return this.report(SCHEMA_REPORT, RecordType.SCHEMA, schema);
    }

    @Override
    public ConsistencyReport.NodeConsistencyReport forNode(NodeRecord node) {
        return this.report(NODE_REPORT, RecordType.NODE, node);
    }

    @Override
    public ConsistencyReport.RelationshipConsistencyReport forRelationship(RelationshipRecord relationship) {
        return this.report(RELATIONSHIP_REPORT, RecordType.RELATIONSHIP, relationship);
    }

    @Override
    public ConsistencyReport.PropertyConsistencyReport forProperty(PropertyRecord property) {
        return this.report(PROPERTY_REPORT, RecordType.PROPERTY, property);
    }

    @Override
    public ConsistencyReport.RelationshipTypeConsistencyReport forRelationshipTypeName(RelationshipTypeTokenRecord relationshipType) {
        return this.report(RELATIONSHIP_TYPE_REPORT, RecordType.RELATIONSHIP_TYPE, relationshipType);
    }

    @Override
    public ConsistencyReport.LabelTokenConsistencyReport forLabelName(LabelTokenRecord label) {
        return this.report(LABEL_KEY_REPORT, RecordType.LABEL, label);
    }

    @Override
    public ConsistencyReport.PropertyKeyTokenConsistencyReport forPropertyKey(PropertyKeyTokenRecord key) {
        return this.report(PROPERTY_KEY_REPORT, RecordType.PROPERTY_KEY, key);
    }

    @Override
    public ConsistencyReport.DynamicConsistencyReport forDynamicBlock(RecordType type, DynamicRecord record) {
        return this.report(DYNAMIC_REPORT, type, record);
    }

    @Override
    public ConsistencyReport.DynamicLabelConsistencyReport forDynamicLabelBlock(RecordType type, DynamicRecord record) {
        return this.report(DYNAMIC_LABEL_REPORT, type, record);
    }

    @Override
    public ConsistencyReport.LabelScanConsistencyReport forNodeLabelScan(TokenScanDocument document) {
        return this.report(LABEL_SCAN_REPORT, RecordType.LABEL_SCAN_DOCUMENT, document);
    }

    @Override
    public ConsistencyReport.RelationshipTypeScanConsistencyReport forRelationshipTypeScan(TokenScanDocument document) {
        return this.report(RELATIONSHIP_TYPE_SCAN_REPORT, RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, document);
    }

    @Override
    public ConsistencyReport.IndexConsistencyReport forIndexEntry(IndexEntry entry) {
        return this.report(INDEX_REPORT, RecordType.INDEX, entry);
    }

    @Override
    public ConsistencyReport.RelationshipGroupConsistencyReport forRelationshipGroup(RelationshipGroupRecord group) {
        return this.report(RELATIONSHIP_GROUP_REPORT, RecordType.RELATIONSHIP_GROUP, group);
    }

    @Override
    public ConsistencyReport.CountsConsistencyReport forCounts(CountsEntry countsEntry) {
        return this.report(COUNTS_REPORT, RecordType.COUNTS, countsEntry);
    }

    private <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> REPORT report(ProxyFactory<REPORT> factory, RecordType type, RECORD record) {
        return new ReportHandler<REPORT>(this.report, factory, type, record, this.monitor).report();
    }

    public static interface Monitor {
        public void reported(Class<?> var1, String var2, String var3, boolean var4);
    }

    public static class FormattingDocumentedHandler
    implements InvocationHandler {
        private final InconsistencyReport report;
        private final RecordType type;
        private short errors;
        private short warnings;

        FormattingDocumentedHandler(InconsistencyReport report, RecordType type) {
            this.report = report;
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String message = DocumentedUtils.extractFormattedMessage((Method)method, (Object[])args);
            if (method.getAnnotation(Warning.class) == null) {
                this.errors = (short)(this.errors + 1);
                this.report.error(message);
            } else {
                this.warnings = (short)(this.warnings + 1);
                this.report.warning(message);
            }
            return null;
        }

        public void updateSummary() {
            this.report.updateSummary(this.type, this.errors, this.warnings);
        }
    }

    public static class ProxyFactory<T> {
        private final Class<T> type;

        ProxyFactory(Class<T> type) {
            this.type = type;
        }

        Class<?> type() {
            return this.type;
        }

        public T create(InvocationHandler handler) {
            return (T)Proxy.newProxyInstance(ConsistencyReporter.class.getClassLoader(), new Class[]{this.type}, handler);
        }

        public static <T> ProxyFactory<T> create(Class<T> type) {
            return new ProxyFactory<T>(type);
        }
    }

    public static class ReportHandler<REPORT extends ConsistencyReport>
    extends ReportInvocationHandler<REPORT> {
        private final AbstractBaseRecord record;

        public ReportHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, AbstractBaseRecord record, Monitor monitor) {
            super(report, factory, type, monitor);
            this.record = record;
        }

        @Override
        protected void logError(String message, Object ... args) {
            this.report.error(this.type, this.record, message, args);
        }

        @Override
        protected void logWarning(String message, Object ... args) {
            this.report.warning(this.type, this.record, message, args);
        }
    }

    public static abstract class ReportInvocationHandler<REPORT extends ConsistencyReport>
    implements InvocationHandler {
        final InconsistencyReport report;
        private final ProxyFactory<REPORT> factory;
        final RecordType type;
        private final Monitor monitor;

        private ReportInvocationHandler(InconsistencyReport report, ProxyFactory<REPORT> factory, RecordType type, Monitor monitor) {
            this.report = report;
            this.factory = factory;
            this.type = type;
            this.monitor = monitor;
        }

        REPORT report() {
            return (REPORT)((ConsistencyReport)this.factory.create(this));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            boolean isError;
            if (method.getName().equals("toString")) {
                return this.factory.type.getName();
            }
            String message = DocumentedUtils.extractMessage((Method)method);
            boolean bl = isError = method.getAnnotation(Warning.class) == null;
            if (isError) {
                this.logError(message, args);
                this.report.updateSummary(this.type, 1, 0);
            } else {
                this.logWarning(message, args);
                this.report.updateSummary(this.type, 0, 1);
            }
            this.monitor.reported(this.factory.type(), method.getName(), message, isError);
            this.inconsistencyReported();
            return null;
        }

        protected void inconsistencyReported() {
        }

        protected abstract void logError(String var1, Object ... var2);

        protected abstract void logWarning(String var1, Object ... var2);
    }
}

