/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.cursor;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.FeatureToggles;

public abstract class AbstractCachedStoreCursors
implements StoreCursors {
    private static final boolean CHECK_READ_CURSORS = FeatureToggles.flag(AbstractCachedStoreCursors.class, (String)"CHECK_READ_CURSORS", (boolean)false);
    protected CursorContext cursorContext;
    private final int numTypes;
    protected PageCursor[] cursorsByType;

    public AbstractCachedStoreCursors(CursorContext cursorContext, int numTypes) {
        this.cursorContext = cursorContext;
        this.numTypes = numTypes;
        this.cursorsByType = this.createEmptyCursorArray();
    }

    public void reset(CursorContext cursorContext) {
        this.cursorContext = cursorContext;
        this.resetCursors();
    }

    private void resetCursors() {
        for (int i = 0; i < this.cursorsByType.length; ++i) {
            PageCursor pageCursor = this.cursorsByType[i];
            if (pageCursor == null) continue;
            if (CHECK_READ_CURSORS) {
                AbstractCachedStoreCursors.checkReadCursor(pageCursor, Numbers.safeCastIntToShort((int)i));
            }
            pageCursor.close();
        }
        this.cursorsByType = this.createEmptyCursorArray();
    }

    public PageCursor readCursor(CursorType type) {
        short value = type.value();
        PageCursor cursor = this.cursorsByType[value];
        if (cursor == null) {
            this.cursorsByType[value] = cursor = this.createReadCursor(type);
        }
        return cursor;
    }

    protected abstract PageCursor createReadCursor(CursorType var1);

    public void close() {
        this.resetCursors();
    }

    private PageCursor[] createEmptyCursorArray() {
        return new PageCursor[this.numTypes];
    }

    private static void checkReadCursor(PageCursor pageCursor, short type) {
        if (pageCursor.getRawCurrentFile() == null) {
            throw new IllegalStateException("Read cursor " + ReflectionToStringBuilder.toString((Object)pageCursor) + " with type: " + type + " is closed outside of owning store cursors.");
        }
    }
}

