/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.nio.file.Path;
import picocli.CommandLine;

public class PathOptions {
    private static final String DEFAULT_DATA_PATH = "<config: server.directories.data>/databases";
    private static final String DEFAULT_TXN_PATH = "<config: server.directories.transaction.logs.root>";

    public static class TargetOptions {
        @CommandLine.Option(names={"--to-path-data"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="<path>", description={"Path to the databases directory, containing the database directory to target from.%n  Default: <config: server.directories.data>/databases"}, required=true)
        private Path dataPath;
        @CommandLine.Option(names={"--to-path-txn"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="<path>", description={"Path to the transactions directory containing the transaction directory for the database to target from.%n  Default: <config: server.directories.transaction.logs.root>"}, required=true)
        private Path txnPath;

        public Path dataPath() {
            return this.dataPath.toAbsolutePath().normalize();
        }

        public Path txnPath() {
            return this.txnPath.toAbsolutePath().normalize();
        }
    }

    public static class SourceOptions {
        @CommandLine.Option(names={"--from-path-data"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="<path>", description={"Path to the databases directory, containing the database directory to source from.%n  Default: <config: server.directories.data>/databases"}, required=true)
        private Path dataPath;
        @CommandLine.Option(names={"--from-path-txn"}, arity="1", showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="<path>", description={"Path to the transactions directory, containing the transaction directory for the database to source from.%n  Default: <config: server.directories.transaction.logs.root>"}, required=true)
        private Path txnPath;

        public Path dataPath() {
            return this.dataPath.toAbsolutePath().normalize();
        }

        public Path txnPath() {
            return this.txnPath.toAbsolutePath().normalize();
        }
    }
}

