/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collections;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.LocalConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class DatabaseConfig
extends LocalConfig
implements Lifecycle {
    private final Map<Setting<?>, Object> databaseSpecificSettings;
    private final Config globalConfig;
    private final Map<Setting<?>, Object> overriddenSettings;

    public DatabaseConfig(Config globalConfig) {
        this(Collections.emptyMap(), globalConfig);
    }

    public DatabaseConfig(Map<Setting<?>, Object> databaseSpecificSettings, Config globalConfig) {
        super(globalConfig);
        this.databaseSpecificSettings = databaseSpecificSettings;
        this.globalConfig = globalConfig;
        this.overriddenSettings = null;
    }

    @Override
    public <T> T get(Setting<T> setting) {
        Object o;
        if (this.overriddenSettings != null && (o = this.overriddenSettings.get(setting)) != null) {
            return (T)o;
        }
        Object dbSpecific = this.databaseSpecificSettings.get(setting);
        if (dbSpecific != null) {
            return (T)dbSpecific;
        }
        return super.get(setting);
    }

    @Override
    public <T> Config.ValueSource getValueSource(Setting<T> setting) {
        boolean overridden = this.overriddenSettings != null && this.overriddenSettings.containsKey(setting) || this.databaseSpecificSettings != null && this.databaseSpecificSettings.containsKey(setting);
        return overridden ? Config.ValueSource.SYSTEM : super.getValueSource(setting);
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() throws Exception {
    }

    public void shutdown() {
        this.removeAllLocalListeners();
    }

    Config getGlobalConfig() {
        return this.globalConfig;
    }
}

