/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.schema.SchemaCommandConverter;
import org.neo4j.importer.SchemaCommandReader;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;

class SchemaCommandsBuilder {
    private static final String NODE_LOOKUP_KEY = SchemaCommandsBuilder.schemaKey(EntityType.NODE, List.of(), List.of());
    private static final String REL_LOOKUP_KEY = SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, List.of(), List.of());
    private final List<SchemaCommand> allCommands = Lists.mutable.empty();
    private final SchemaCommandReader.ReaderConfig readerConfig;
    private final SchemaCommandConverter schemaCommandConverter;

    SchemaCommandsBuilder(SchemaCommandReader.ReaderConfig readerConfig, CypherVersion cypherVersion) {
        this.readerConfig = Objects.requireNonNull(readerConfig);
        this.schemaCommandConverter = new SchemaCommandConverter(cypherVersion, readerConfig.latestVectorIndexVersion());
    }

    List<SchemaCommand> build() {
        return this.validateParsedCommands();
    }

    SchemaCommandsBuilder withCommand(org.neo4j.cypher.internal.ast.SchemaCommand ast) throws SchemaCommand.SchemaCommandReaderException {
        SchemaCommand command = this.schemaCommandConverter.apply(ast);
        if (!this.readerConfig.allowEnterpriseFeatures()) {
            if (SchemaCommandsBuilder.isEnterpriseOnly(command)) {
                throw new SchemaCommand.SchemaCommandReaderException("Enterprise features are not currently supported");
            }
        } else if (!this.readerConfig.allowConstraints()) {
            if (command instanceof SchemaCommand.ConstraintCommand) {
                throw new SchemaCommand.SchemaCommandReaderException("Constraint commands are not currently supported");
            }
        } else if (!this.readerConfig.allowDropOperations() && SchemaCommandsBuilder.isDropCommand(command)) {
            throw new SchemaCommand.SchemaCommandReaderException("Dropping indexes or constraints is not currently supported");
        }
        this.allCommands.add(command);
        return this;
    }

    private List<SchemaCommand> validateParsedCommands() throws SchemaCommand.SchemaCommandReaderException {
        MutableList result = Lists.mutable.empty();
        LinkedHashMap<String, SchemaCommand> namedCommands = new LinkedHashMap<String, SchemaCommand>();
        MutableListMultimap allSchemas = Multimaps.mutable.list.empty();
        for (SchemaCommand command : this.allCommands) {
            if (command instanceof SchemaCommand.IndexCommand.Create) {
                SchemaCommand.IndexCommand.Create index = (SchemaCommand.IndexCommand.Create)command;
                allSchemas.put((Object)SchemaCommandsBuilder.schemaKey(index), (Object)index);
            } else if (command instanceof SchemaCommand.ConstraintCommand.Create) {
                SchemaCommand.ConstraintCommand.Create constraint = (SchemaCommand.ConstraintCommand.Create)command;
                allSchemas.put((Object)SchemaCommandsBuilder.schemaKey(constraint), (Object)constraint);
            }
            String trackingName = SchemaCommandsBuilder.trackingName(command);
            SchemaCommand previousCommand = namedCommands.computeIfAbsent(trackingName, key -> command);
            if (previousCommand == command) {
                result.add((Object)command);
                continue;
            }
            if (SchemaCommandsBuilder.isDropCommand(command)) {
                if (!SchemaCommandsBuilder.isDropCommand(previousCommand)) {
                    result.remove((Object)previousCommand);
                }
                namedCommands.remove(trackingName);
                continue;
            }
            if (SchemaCommandsBuilder.isDropCommand(previousCommand)) {
                result.add((Object)command);
                continue;
            }
            throw new SchemaCommand.SchemaCommandReaderException("Multiple operations for the schema command with name " + command.name());
        }
        MutableList nodeLookups = allSchemas.removeAll((Object)NODE_LOOKUP_KEY);
        if (nodeLookups != null && nodeLookups.size() > 1) {
            throw new SchemaCommand.SchemaCommandReaderException("Multiple node lookup indexes found - only 1 is allowed per database: " + nodeLookups.stream().map(SchemaCommand::name).sorted().collect(Collectors.joining(",")));
        }
        MutableList relLookups = allSchemas.removeAll((Object)REL_LOOKUP_KEY);
        if (relLookups != null && relLookups.size() > 1) {
            throw new SchemaCommand.SchemaCommandReaderException("Multiple relationship lookup indexes found - only 1 is allowed per database: " + relLookups.stream().map(SchemaCommand::name).sorted().collect(Collectors.joining(",")));
        }
        allSchemas.forEachKeyMultiValues((Procedure2 & Serializable)(key, schemas) -> {
            MutableList indexCommands = Lists.mutable.empty();
            MutableList constraintCommands = Lists.mutable.empty();
            for (SchemaCommand schema : schemas) {
                if (schema instanceof SchemaCommand.IndexCommand.Create) {
                    SchemaCommand.IndexCommand.Create command = (SchemaCommand.IndexCommand.Create)schema;
                    indexCommands.add((Object)command);
                    continue;
                }
                if (!(schema instanceof SchemaCommand.ConstraintCommand.Create)) continue;
                SchemaCommand.ConstraintCommand.Create command = (SchemaCommand.ConstraintCommand.Create)schema;
                constraintCommands.add((Object)command);
            }
            SchemaCommandsBuilder.validateRelatedSchemaCommands((RichIterable<SchemaCommand.IndexCommand.Create>)indexCommands, (RichIterable<SchemaCommand.ConstraintCommand.Create>)constraintCommands);
        });
        return result;
    }

    private static void validateRelatedSchemaCommands(RichIterable<SchemaCommand.IndexCommand.Create> indexCommands, RichIterable<SchemaCommand.ConstraintCommand.Create> constraintCommands) throws SchemaCommand.SchemaCommandReaderException {
        SchemaCommandsBuilder.validatePropertyTypes(constraintCommands);
        LinkedHashMap<SchemaCommand.ConstraintCommand.Create, IndexType> backedConstraints = new LinkedHashMap<SchemaCommand.ConstraintCommand.Create, IndexType>();
        MutableList nonBackedConstraints = Lists.mutable.empty();
        for (SchemaCommand.ConstraintCommand.Create constraint2 : constraintCommands) {
            SchemaCommandsBuilder.backingIndexType(constraint2).ifPresentOrElse(type -> backedConstraints.put(constraint2, (IndexType)type), () -> nonBackedConstraints.add((Object)constraint2));
        }
        backedConstraints.forEach((backed1, backingType1) -> backedConstraints.forEach((backed2, backingType2) -> {
            if (backed1 != backed2 && backed1.constraintType() == backed2.constraintType()) {
                throw new SchemaCommand.SchemaCommandReaderException("Duplicate backing indexes found for constraints '%s' and '%s'".formatted(backed1.name(), backed2.name()));
            }
        }));
        for (SchemaCommand.ConstraintCommand.Create nonBacked1 : nonBackedConstraints) {
            for (SchemaCommand.ConstraintCommand.Create nonBacked2 : nonBackedConstraints) {
                if (nonBacked1 == nonBacked2 || nonBacked1.constraintType() != nonBacked2.constraintType()) continue;
                throw new SchemaCommand.SchemaCommandReaderException("Duplicate schemas found for constraints '%s' and '%s'".formatted(nonBacked1.name(), nonBacked2.name()));
            }
        }
        MutableSet indexTypes = Sets.mutable.empty();
        for (SchemaCommand.IndexCommand.Create command : indexCommands) {
            IndexType indexType = command.indexType();
            if (!indexTypes.add((Object)indexType)) {
                throw new SchemaCommand.SchemaCommandReaderException("An index of type '%s' is also specified - unable to create index '%s'".formatted(indexType, command.name()));
            }
            backedConstraints.forEach((constraint, backingType) -> {
                if (backingType == indexType) {
                    throw new SchemaCommand.SchemaCommandReaderException("Cannot create index '%s' as it clashes with the constraint '%s' also having a backing index of type '%s'".formatted(command.name(), constraint.name(), indexType));
                }
            });
        }
    }

    private static void validatePropertyTypes(RichIterable<SchemaCommand.ConstraintCommand.Create> constraintCommands) throws SchemaCommand.SchemaCommandReaderException {
        PropertyTypeSet lastProperties = null;
        for (SchemaCommand.ConstraintCommand.Create constraint : constraintCommands.partition((Predicate & Serializable)c -> c.constraintType().enforcesPropertyType()).getSelected()) {
            PropertyTypeSet propertyTypes;
            if (constraint instanceof SchemaCommand.ConstraintCommand.Create.NodePropertyType) {
                SchemaCommand.ConstraintCommand.Create.NodePropertyType nodeType = (SchemaCommand.ConstraintCommand.Create.NodePropertyType)constraint;
                v0 = nodeType.propertyTypes();
            } else {
                v0 = propertyTypes = ((SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType)constraint).propertyTypes();
            }
            if (lastProperties != null && !lastProperties.equals((Object)propertyTypes)) {
                throw new SchemaCommand.SchemaCommandReaderException("A property type constraint of '%s' is also specified - unable to create '%s' with type '%s'".formatted(lastProperties.userDescription(), constraint.name(), propertyTypes.userDescription()));
            }
            lastProperties = propertyTypes;
        }
    }

    private static Optional<IndexType> backingIndexType(SchemaCommand.ConstraintCommand.Create constraint) {
        if (constraint.hasBackingIndex()) {
            return Optional.of(IndexType.RANGE);
        }
        return Optional.empty();
    }

    private static boolean isDropCommand(SchemaCommand command) {
        return command instanceof SchemaCommand.ConstraintCommand.Drop || command instanceof SchemaCommand.IndexCommand.Drop;
    }

    private static boolean isEnterpriseOnly(SchemaCommand command) {
        SchemaCommand.ConstraintCommand.Create constraint;
        return command instanceof SchemaCommand.ConstraintCommand.Create && (constraint = (SchemaCommand.ConstraintCommand.Create)command).constraintType() != ConstraintType.UNIQUE;
    }

    private static String trackingName(SchemaCommand command) {
        String name = command.name();
        return name == null ? command.toString() : name;
    }

    private static String schemaKey(SchemaCommand.IndexCommand.Create indexCommand) {
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodeLookup) {
            return NODE_LOOKUP_KEY;
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipLookup) {
            return REL_LOOKUP_KEY;
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodeRange) {
            SchemaCommand.IndexCommand.Create.NodeRange command = (SchemaCommand.IndexCommand.Create.NodeRange)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), (List<String>)command.properties());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipRange) {
            SchemaCommand.IndexCommand.Create.RelationshipRange command = (SchemaCommand.IndexCommand.Create.RelationshipRange)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), (List<String>)command.properties());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodeText) {
            SchemaCommand.IndexCommand.Create.NodeText command = (SchemaCommand.IndexCommand.Create.NodeText)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), command.property());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipText) {
            SchemaCommand.IndexCommand.Create.RelationshipText command = (SchemaCommand.IndexCommand.Create.RelationshipText)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), command.property());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodePoint) {
            SchemaCommand.IndexCommand.Create.NodePoint command = (SchemaCommand.IndexCommand.Create.NodePoint)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), command.property());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipPoint) {
            SchemaCommand.IndexCommand.Create.RelationshipPoint command = (SchemaCommand.IndexCommand.Create.RelationshipPoint)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), command.property());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodeFulltext) {
            SchemaCommand.IndexCommand.Create.NodeFulltext command = (SchemaCommand.IndexCommand.Create.NodeFulltext)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.labels(), (List<String>)command.properties());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipFulltext) {
            SchemaCommand.IndexCommand.Create.RelationshipFulltext command = (SchemaCommand.IndexCommand.Create.RelationshipFulltext)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.types(), (List<String>)command.properties());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.NodeVector) {
            SchemaCommand.IndexCommand.Create.NodeVector command = (SchemaCommand.IndexCommand.Create.NodeVector)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), command.property());
        }
        if (indexCommand instanceof SchemaCommand.IndexCommand.Create.RelationshipVector) {
            SchemaCommand.IndexCommand.Create.RelationshipVector command = (SchemaCommand.IndexCommand.Create.RelationshipVector)indexCommand;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), command.property());
        }
        throw new IllegalStateException("Unknown index operation: " + indexCommand);
    }

    private static String schemaKey(SchemaCommand.ConstraintCommand.Create constraint) {
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.NodeUniqueness) {
            SchemaCommand.ConstraintCommand.Create.NodeUniqueness command = (SchemaCommand.ConstraintCommand.Create.NodeUniqueness)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), (List<String>)command.properties());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness) {
            SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness command = (SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), (List<String>)command.properties());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.NodeKey) {
            SchemaCommand.ConstraintCommand.Create.NodeKey command = (SchemaCommand.ConstraintCommand.Create.NodeKey)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), (List<String>)command.properties());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.RelationshipKey) {
            SchemaCommand.ConstraintCommand.Create.RelationshipKey command = (SchemaCommand.ConstraintCommand.Create.RelationshipKey)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), (List<String>)command.properties());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.NodeExistence) {
            SchemaCommand.ConstraintCommand.Create.NodeExistence command = (SchemaCommand.ConstraintCommand.Create.NodeExistence)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), command.property());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.RelationshipExistence) {
            SchemaCommand.ConstraintCommand.Create.RelationshipExistence command = (SchemaCommand.ConstraintCommand.Create.RelationshipExistence)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), command.property());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.NodePropertyType) {
            SchemaCommand.ConstraintCommand.Create.NodePropertyType command = (SchemaCommand.ConstraintCommand.Create.NodePropertyType)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.NODE, command.label(), command.property());
        }
        if (constraint instanceof SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType) {
            SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType command = (SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType)constraint;
            return SchemaCommandsBuilder.schemaKey(EntityType.RELATIONSHIP, command.type(), command.property());
        }
        throw new IllegalStateException("Unknown constraint operation: " + constraint);
    }

    private static String schemaKey(EntityType entityType, List<String> entities, List<String> properties) {
        return SchemaCommandsBuilder.schemaKey(entityType, String.join((CharSequence)",", entities), properties);
    }

    private static String schemaKey(EntityType entityType, String entities, List<String> properties) {
        return SchemaCommandsBuilder.schemaKey(entityType, entities, String.join((CharSequence)",", properties));
    }

    private static String schemaKey(EntityType entityType, String entities, String properties) {
        return "%s|%s|%s".formatted(entityType == EntityType.NODE ? "n" : "r", entities, properties);
    }
}

