/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionImpl;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.DatabaseUnavailableTransactionCreationException;
import org.neo4j.bolt.tx.error.NoSuchDatabaseTransactionCreationException;
import org.neo4j.bolt.tx.error.TransactionCreationException;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;

public class TransactionManagerImpl
implements TransactionManager {
    private final BoltGraphDatabaseManagementServiceSPI graphDatabaseManagementService;
    private final Clock clock;
    private final AtomicLong nextTransactionId = new AtomicLong(1L);
    private final Map<String, Transaction> transactionMap = new ConcurrentHashMap<String, Transaction>();
    private final CleanupListener cleanupListener = new CleanupListener();

    public TransactionManagerImpl(BoltGraphDatabaseManagementServiceSPI graphDatabaseManagementService, Clock clock) {
        this.graphDatabaseManagementService = graphDatabaseManagementService;
        this.clock = clock;
    }

    @Override
    public int getTransactionCount() {
        return this.transactionMap.size();
    }

    @Override
    public Optional<Transaction> get(String id) {
        return Optional.ofNullable(this.transactionMap.get(id));
    }

    @Override
    public Transaction create(TransactionType type, TransactionOwner owner, String databaseName, AccessMode mode, List<String> bookmarks, Duration timeout, Map<String, Object> metadata, NotificationConfiguration notificationsConfig) throws TransactionException {
        BoltTransaction tx;
        BoltGraphDatabaseServiceSPI databaseService;
        String db = databaseName;
        if (db == null || databaseName.isEmpty()) {
            db = owner.selectedDefaultDatabase();
        }
        KernelTransaction.Type kernelType = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionType.EXPLICIT -> KernelTransaction.Type.EXPLICIT;
            case TransactionType.IMPLICIT -> KernelTransaction.Type.IMPLICIT;
        };
        try {
            databaseService = this.graphDatabaseManagementService.database(db, owner.memoryTracker());
        }
        catch (DatabaseNotFoundException ex) {
            throw NoSuchDatabaseTransactionCreationException.databaseDoesNotExist(db, ex);
        }
        catch (UnavailableException ex) {
            throw new DatabaseUnavailableTransactionCreationException(databaseName, ex);
        }
        QueryExecutionConfiguration executionConfig = notificationsConfig != null ? new QueryExecutionConfiguration(notificationsConfig) : QueryExecutionConfiguration.DEFAULT_CONFIG;
        String id = "bolt-" + this.nextTransactionId.getAndIncrement();
        try {
            tx = databaseService.beginTransaction(kernelType, owner.loginContext(), owner.info(), bookmarks, timeout, mode, metadata, owner.routingContext(), executionConfig);
        }
        catch (Exception ex) {
            throw new TransactionCreationException(ex);
        }
        TransactionImpl handle = new TransactionImpl(id, type, databaseService.getDatabaseReference(), this.clock, tx);
        handle.registerListener(this.cleanupListener);
        this.transactionMap.put(id, handle);
        return handle;
    }

    private class CleanupListener
    implements Transaction.Listener {
        private CleanupListener() {
        }

        @Override
        public void onClose(Transaction transaction) {
            TransactionManagerImpl.this.transactionMap.remove(transaction.id());
        }
    }
}

