/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.fsm.response.AbstractMetadataAwareResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.response.NetworkRecordHandler;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.response.IgnoredMessage;
import org.neo4j.bolt.protocol.common.message.response.SuccessMessage;
import org.neo4j.bolt.protocol.error.streaming.BoltStreamingWriteException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class NetworkResponseHandler
extends AbstractMetadataAwareResponseHandler {
    private static final Set<Status> CLIENT_MID_OP_DISCONNECT_ERRORS = new HashSet<Status.Transaction>(Arrays.asList(Status.Transaction.Terminated, Status.Transaction.LockClientStopped));
    private final Connection connection;
    private final int bufferSize;
    private final int flushThreshold;
    private final Log log;
    private MapValueBuilder metadataBuilder;
    private NetworkRecordHandler recordHandler;

    public NetworkResponseHandler(Connection connection, MetadataHandler metadataHandler, int bufferSize, int flushThreshold, LogService logging) {
        super(metadataHandler);
        this.connection = connection;
        this.bufferSize = bufferSize;
        this.flushThreshold = flushThreshold;
        this.log = logging.getInternalLog(NetworkResponseHandler.class);
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        if (this.metadataBuilder == null) {
            this.metadataBuilder = new MapValueBuilder();
        }
        this.metadataBuilder.add(key, value);
    }

    @Override
    public RecordHandler onBeginStreaming(List<String> fieldNames) {
        this.recordHandler = new NetworkRecordHandler(this.connection, fieldNames.size(), this.bufferSize, this.flushThreshold);
        return this.recordHandler;
    }

    @Override
    public void onFailure(Error error) {
        if (this.recordHandler != null) {
            this.recordHandler.close();
            this.recordHandler = null;
        }
        this.metadataBuilder = null;
        if (error.isFatal()) {
            this.log.debug("Publishing fatal error: %s", new Object[]{error});
        }
        SocketAddress remoteAddress = this.connection.clientAddress();
        this.connection.writeAndFlush(error.asBoltMessage()).addListener(f -> {
            if (f.isSuccess()) {
                return;
            }
            if (CLIENT_MID_OP_DISCONNECT_ERRORS.contains(error.status())) {
                this.log.warn("Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting.", new Object[]{remoteAddress});
                return;
            }
            Throwable ex = f.cause();
            ex.addSuppressed(error.cause());
            this.log.warn("Unable to send error back to the client. " + ex.getMessage(), ex);
        });
        this.connection.notifyListenersSafely("requestResultFailure", listener -> listener.onResponseFailed(error));
    }

    @Override
    public void onIgnored() {
        try {
            this.connection.writeAndFlush(IgnoredMessage.INSTANCE).sync();
            this.connection.notifyListenersSafely("requestResultIgnored", ConnectionListener::onResponseIgnored);
        }
        catch (Throwable ex) {
            throw new BoltStreamingWriteException("Failed to transmit operation result: Response write failure", ex);
        }
    }

    @Override
    public void onSuccess() {
        MapValue metadata;
        if (this.recordHandler != null) {
            this.recordHandler.close();
            this.recordHandler = null;
        }
        if (this.metadataBuilder != null) {
            metadata = this.metadataBuilder.build();
            this.metadataBuilder = null;
        } else {
            metadata = MapValue.EMPTY;
        }
        try {
            this.connection.writeAndFlush(new SuccessMessage(metadata)).sync();
            this.connection.notifyListenersSafely("requestResultSuccess", listener -> listener.onResponseSuccess(metadata));
        }
        catch (Throwable ex) {
            throw new BoltStreamingWriteException("Failed to transmit operation result: Response write failure", ex);
        }
    }
}

