/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.arrow.flight.SessionOptionValue;
import org.apache.arrow.flight.SessionOptionValueVisitor;
import org.apache.arrow.flight.impl.Flight;

public class SessionOptionValueFactory {
    public static SessionOptionValue makeSessionOptionValue(String value) {
        return new SessionOptionValueString(value);
    }

    public static SessionOptionValue makeSessionOptionValue(boolean value) {
        return new SessionOptionValueBoolean(value);
    }

    public static SessionOptionValue makeSessionOptionValue(long value) {
        return new SessionOptionValueLong(value);
    }

    public static SessionOptionValue makeSessionOptionValue(double value) {
        return new SessionOptionValueDouble(value);
    }

    public static SessionOptionValue makeSessionOptionValue(String[] value) {
        return new SessionOptionValueStringList(value);
    }

    public static SessionOptionValue makeEmptySessionOptionValue() {
        return new SessionOptionValueEmpty();
    }

    public static SessionOptionValue makeSessionOptionValue(Flight.SessionOptionValue proto) {
        switch (proto.getOptionValueCase()) {
            case STRING_VALUE: {
                return new SessionOptionValueString(proto.getStringValue());
            }
            case BOOL_VALUE: {
                return new SessionOptionValueBoolean(proto.getBoolValue());
            }
            case INT64_VALUE: {
                return new SessionOptionValueLong(proto.getInt64Value());
            }
            case DOUBLE_VALUE: {
                return new SessionOptionValueDouble(proto.getDoubleValue());
            }
            case STRING_LIST_VALUE: {
                return new SessionOptionValueStringList((String[])proto.getStringListValue().getValuesList().asByteStringList().stream().map(e -> new String(e.toByteArray(), StandardCharsets.UTF_8)).toArray(String[]::new));
            }
            case OPTIONVALUE_NOT_SET: {
                return new SessionOptionValueEmpty();
            }
        }
        throw new IllegalArgumentException("");
    }

    private static class SessionOptionValueString
    extends SessionOptionValue {
        private final String value;

        SessionOptionValueString(String value) {
            this.value = value;
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionOptionValueString that = (SessionOptionValueString)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return '\"' + this.value + '\"';
        }
    }

    private static class SessionOptionValueBoolean
    extends SessionOptionValue {
        private final boolean value;

        SessionOptionValueBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionOptionValueBoolean that = (SessionOptionValueBoolean)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SessionOptionValueLong
    extends SessionOptionValue {
        private final long value;

        SessionOptionValueLong(long value) {
            this.value = value;
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionOptionValueLong that = (SessionOptionValueLong)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SessionOptionValueDouble
    extends SessionOptionValue {
        private final double value;

        SessionOptionValueDouble(double value) {
            this.value = value;
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionOptionValueDouble that = (SessionOptionValueDouble)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SessionOptionValueStringList
    extends SessionOptionValue {
        private final String[] value;

        SessionOptionValueStringList(String[] value) {
            this.value = (String[])value.clone();
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionOptionValueStringList that = (SessionOptionValueStringList)o;
            return Arrays.deepEquals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.value);
        }

        public String toString() {
            if (this.value.length == 0) {
                return "[]";
            }
            return "[\"" + String.join((CharSequence)"\", \"", this.value) + "\"]";
        }
    }

    private static class SessionOptionValueEmpty
    extends SessionOptionValue {
        private SessionOptionValueEmpty() {
        }

        @Override
        public <T> T acceptVisitor(SessionOptionValueVisitor<T> v) {
            return v.visit((Void)null);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return SessionOptionValueEmpty.class.hashCode();
        }

        public String toString() {
            return "<empty>";
        }
    }
}

