/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        T[] result = ObjectArrays.newArray(type, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(@ParametricNullness T element, T[] array) {
        T[] result = ObjectArrays.newArray(array, array.length + 1);
        result[0] = element;
        System.arraycopy(array, 0, result, 1, array.length);
        return result;
    }

    public static <T> T[] concat(T[] array, @ParametricNullness T element) {
        T[] result = Arrays.copyOf(array, array.length + 1);
        result[array.length] = element;
        return result;
    }

    static <T> T[] toArrayImpl(Collection<?> c11, T[] array) {
        int size = c11.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        }
        ObjectArrays.fillArray(c11, array);
        if (array.length > size) {
            @Nullable T[] unsoundlyCovariantArray = array;
            unsoundlyCovariantArray[size] = null;
        }
        return array;
    }

    static <T> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c11) {
        return ObjectArrays.fillArray(c11, new Object[c11.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result = new Object[length];
        System.arraycopy(elements, offset, result, 0, length);
        return result;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array) {
        int i11 = 0;
        for (Object element : elements) {
            array[i11++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i11, int j11) {
        Object temp = array[i11];
        array[i11] = array[j11];
        array[j11] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i11 = 0; i11 < length; ++i11) {
            ObjectArrays.checkElementNotNull(array[i11], i11);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index) {
        if (element == null) {
            throw new NullPointerException("at index " + index);
        }
        return element;
    }
}

