/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import rcm.awt.Constrain;
import rcm.awt.PopupDialog;
import websphinx.Access;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.EventLog;
import websphinx.LinkListener;
import websphinx.workbench.ActionEditor;
import websphinx.workbench.Browser;
import websphinx.workbench.ClassifierListEditor;
import websphinx.workbench.Context;
import websphinx.workbench.CrawlerEditor;
import websphinx.workbench.DownloadParametersEditor;
import websphinx.workbench.LinkPredicateEditor;
import websphinx.workbench.PagePredicateEditor;
import websphinx.workbench.SimpleCrawlerEditor;
import websphinx.workbench.Statistics;
import websphinx.workbench.WebGraph;
import websphinx.workbench.WebOutline;
import websphinx.workbench.WorkbenchControlPanel;
import websphinx.workbench.WorkbenchFrame;
import websphinx.workbench.WorkbenchTabPanel;
import websphinx.workbench.WorkbenchVizFrame;
import websphinx.workbench.WorkbenchVizPanel;

public class Workbench
extends Panel
implements CrawlListener {
    Crawler crawler;
    String currentFilename = "";
    Panel workbenchPanel;
    GridBagConstraints workbenchConstraints;
    WorkbenchVizPanel vizPanel;
    GridBagConstraints vizConstraints;
    WebGraph graph;
    WebOutline outline;
    Statistics statistics;
    EventLog logger;
    MenuBar menubar;
    Menu fileMenu;
    MenuItem newCrawlerItem;
    MenuItem openCrawlerItem;
    MenuItem saveCrawlerItem;
    MenuItem createCrawlerItem;
    MenuItem exitItem;
    Panel menuPanel;
    Button newCrawlerButton;
    Button openCrawlerButton;
    Button saveCrawlerButton;
    Button createCrawlerButton;
    WorkbenchTabPanel configPanel;
    Panel simplePanel;
    Panel crawlPanel;
    Panel limitsPanel;
    Panel classifiersPanel;
    Panel linksPanel;
    Panel actionPanel;
    CrawlerEditor crawlerEditor;
    ClassifierListEditor classifierListEditor;
    DownloadParametersEditor downloadParametersEditor;
    LinkPredicateEditor linkPredicateEditor;
    PagePredicateEditor pagePredicateEditor;
    ActionEditor actionEditor;
    SimpleCrawlerEditor simpleCrawlerEditor;
    boolean advancedMode = false;
    boolean tornOff = false;
    Button startButton;
    Button pauseButton;
    Button stopButton;
    Button clearButton;
    boolean allowExit;
    Frame workbenchFrame;
    Frame vizFrame;
    static final int MARGIN = 8;

    public Workbench() {
        this(Workbench.makeDefaultCrawler());
    }

    private static Crawler makeDefaultCrawler() {
        Crawler c = new Crawler();
        c.setDomain(Crawler.SUBTREE);
        return c;
    }

    public Workbench(String filename) throws Exception {
        this(Workbench.loadCrawler(new FileInputStream(filename)));
    }

    public Workbench(URL url) throws Exception {
        this(Workbench.loadCrawler(url.openStream()));
    }

    public Workbench(Crawler _crawler) {
        Browser browser = Context.getBrowser();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setLayout(new GridLayout(2, 1));
        this.workbenchPanel = new Panel();
        this.add(this.workbenchPanel);
        this.workbenchPanel.setLayout(new GridBagLayout());
        this.makeMenus();
        Constrain.add(this.workbenchPanel, this.menuPanel, Constrain.labelLike(0, 0));
        this.configPanel = new WorkbenchTabPanel();
        Constrain.add(this.workbenchPanel, this.configPanel, Constrain.areaLike(0, 1));
        this.simplePanel = this.makeSimplePanel();
        this.crawlPanel = this.makeCrawlPanel();
        this.linksPanel = this.makeLinksPanel();
        this.actionPanel = this.makeActionPanel();
        this.classifiersPanel = this.makeClassifiersPanel();
        this.limitsPanel = this.makeLimitsPanel();
        Constrain.add(this.workbenchPanel, this.makeButtonPanel(), Constrain.fieldLike(0, 2));
        this.vizPanel = new WorkbenchVizPanel(this);
        this.add(this.vizPanel);
        this.graph = new WebGraph();
        this.graph.setBackground(Color.white);
        if (browser != null) {
            this.graph.addLinkViewListener(browser);
        }
        this.vizPanel.addTabPanel("Graph", true, this.graph);
        this.outline = new WebOutline();
        this.outline.setBackground(Color.white);
        if (browser != null) {
            this.outline.addLinkViewListener(browser);
        }
        this.vizPanel.addTabPanel("Outline", true, this.outline);
        this.statistics = new Statistics();
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add(this.statistics);
        this.vizPanel.addTabPanel("Statistics", true, p);
        this.logger = new EventLog();
        this.setCrawler(_crawler);
    }

    public Frame makeFrame() {
        if (this.workbenchFrame == null) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.workbenchFrame = new WorkbenchFrame(this);
            this.workbenchFrame.setForeground(this.getForeground());
            this.workbenchFrame.setBackground(this.getBackground());
            this.workbenchFrame.setFont(this.getFont());
            this.workbenchFrame.setTitle("Crawler Workbench: " + (this.crawler != null ? this.crawler.getName() : ""));
            this.workbenchFrame.setLayout(new GridLayout(1, 1));
            this.workbenchFrame.add(this);
            this.workbenchPanel.remove(this.menuPanel);
            this.workbenchFrame.setMenuBar(this.menubar);
            this.workbenchFrame.reshape(0, 0, Math.min(550, screen.width), screen.height - 50);
        }
        return this.workbenchFrame;
    }

    public void setAllowExit(boolean yes) {
        this.allowExit = yes;
    }

    public boolean getAllowExit() {
        return this.allowExit;
    }

    public synchronized void setAdvancedMode(boolean adv) {
        if (this.advancedMode == adv) {
            return;
        }
        this.configureCrawler();
        this.advancedMode = adv;
        this.setCrawler(this.crawler);
        this.configPanel.advancedButton.setLabel(this.advancedMode ? "<< Simple" : ">> Advanced");
        this.validate();
    }

    public boolean getAdvancedMode() {
        return this.advancedMode;
    }

    static void setVisible(Component comp, boolean visible) {
        if (visible) {
            comp.show();
        } else {
            comp.hide();
        }
    }

    static void setEnabled(Component comp, boolean enabled) {
        if (enabled) {
            comp.enable();
        } else {
            comp.disable();
        }
    }

    static void setEnabled(MenuItem item, boolean enabled) {
        if (enabled) {
            item.enable();
        } else {
            item.disable();
        }
    }

    Panel makeMenus() {
        this.menubar = new MenuBar();
        this.menuPanel = new Panel();
        this.menuPanel.setLayout(new FlowLayout());
        this.fileMenu = new Menu("File");
        this.menubar.add(this.fileMenu);
        this.newCrawlerItem = new MenuItem("New Crawler");
        this.fileMenu.add(this.newCrawlerItem);
        this.newCrawlerButton = new Button("New");
        this.menuPanel.add(this.newCrawlerButton);
        this.openCrawlerItem = new MenuItem("Open Crawler...");
        this.fileMenu.add(this.openCrawlerItem);
        this.openCrawlerButton = new Button("Open...");
        this.menuPanel.add(this.openCrawlerButton);
        this.saveCrawlerItem = new MenuItem("Save Crawler...");
        this.fileMenu.add(this.saveCrawlerItem);
        this.saveCrawlerButton = new Button("Save...");
        this.menuPanel.add(this.saveCrawlerButton);
        this.createCrawlerItem = new MenuItem("Create Crawler From Class...");
        this.fileMenu.add(this.createCrawlerItem);
        this.createCrawlerButton = new Button("Create...");
        this.menuPanel.add(this.createCrawlerButton);
        this.exitItem = new MenuItem("Exit");
        this.fileMenu.add(this.exitItem);
        return this.menuPanel;
    }

    private Panel makeSimplePanel() {
        this.simpleCrawlerEditor = new SimpleCrawlerEditor();
        return this.simpleCrawlerEditor;
    }

    private Panel makeCrawlPanel() {
        this.crawlerEditor = new CrawlerEditor();
        return this.crawlerEditor;
    }

    private Panel makeLinksPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Constrain.add(panel, new Label("Follow:"), Constrain.labelLike(0, 0));
        this.linkPredicateEditor = new LinkPredicateEditor();
        Constrain.add(panel, this.linkPredicateEditor, Constrain.areaLike(1, 0));
        return panel;
    }

    private Panel makeActionPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Constrain.add(panel, new Label("Action:"), Constrain.labelLike(0, 0));
        this.actionEditor = new ActionEditor();
        Constrain.add(panel, this.actionEditor, Constrain.areaLike(1, 0));
        Constrain.add(panel, new Label("on pages:"), Constrain.labelLike(0, 1));
        this.pagePredicateEditor = new PagePredicateEditor();
        Constrain.add(panel, this.pagePredicateEditor, Constrain.areaLike(1, 1));
        return panel;
    }

    private Panel makeClassifiersPanel() {
        this.classifierListEditor = new ClassifierListEditor();
        return this.classifierListEditor;
    }

    private Panel makeLimitsPanel() {
        this.downloadParametersEditor = new DownloadParametersEditor();
        return this.downloadParametersEditor;
    }

    private Panel makeButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.startButton = new Button("Start");
        panel.add(this.startButton);
        this.pauseButton = new Button("Pause");
        panel.add(this.pauseButton);
        this.stopButton = new Button("Stop");
        panel.add(this.stopButton);
        this.clearButton = new Button("Clear");
        panel.add(this.clearButton);
        this.enableButtons(true, false, false, false);
        return panel;
    }

    String getCrawlerClassName(String label) {
        String className = label;
        if (className != null) {
            if (className.equals("Crawler")) {
                className = "websphinx.Crawler";
            } else if (className.equals("Load Class...")) {
                className = null;
            }
        }
        return className;
    }

    public boolean handleEvent(Event event) {
        if (this.doEvent(event)) {
            return true;
        }
        return super.handleEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean doEvent(Event event) {
        if (event.id != 1001) return false;
        if (event.target instanceof MenuItem) {
            MenuItem item = (MenuItem)event.target;
            if (item == this.newCrawlerItem) {
                this.newCrawler();
                return true;
            } else if (item == this.openCrawlerItem) {
                this.openCrawler();
                return true;
            } else if (item == this.saveCrawlerItem) {
                this.saveCrawler();
                return true;
            } else if (item == this.createCrawlerItem) {
                this.createCrawler(null);
                return true;
            } else {
                if (item != this.exitItem) return false;
                this.close();
            }
            return true;
        } else if (event.target == this.newCrawlerButton) {
            this.newCrawler();
            return true;
        } else if (event.target == this.openCrawlerButton) {
            this.openCrawler();
            return true;
        } else if (event.target == this.saveCrawlerButton) {
            this.saveCrawler();
            return true;
        } else if (event.target == this.createCrawlerButton) {
            this.createCrawler(null);
            return true;
        } else if (event.target == this.configPanel.advancedButton) {
            this.setAdvancedMode(!this.advancedMode);
            return true;
        } else if (event.target == this.vizPanel.optionsButton) {
            new WorkbenchControlPanel(this.graph, this.outline).show();
            return true;
        } else if (event.target == this.vizPanel.tearoffButton) {
            if (this.tornOff) {
                this.dockVisualizations();
                return true;
            } else {
                this.tearoffVisualizations();
            }
            return true;
        } else if (event.target == this.startButton) {
            this.start();
            return true;
        } else if (event.target == this.pauseButton) {
            this.pause();
            return true;
        } else if (event.target == this.stopButton) {
            this.stop();
            return true;
        } else {
            if (event.target != this.clearButton) return false;
            this.clear();
        }
        return true;
    }

    protected void finalize() {
    }

    void close() {
        if (!this.allowExit) {
            return;
        }
        if (Context.isApplication()) {
            Runtime.runFinalizersOnExit((boolean)true);
            System.exit(0);
        }
    }

    public void refresh() {
        this.graph.updateClosure(this.crawler.getCrawledRoots());
        this.outline.updateClosure(this.crawler.getCrawledRoots());
    }

    void connectVisualization(Crawler crawler, Object viz, boolean linksToo) {
        if (viz instanceof CrawlListener) {
            crawler.addCrawlListener((CrawlListener)viz);
        }
        if (linksToo && viz instanceof LinkListener) {
            crawler.addLinkListener((LinkListener)viz);
        }
    }

    void disconnectVisualization(Crawler crawler, Object viz, boolean linksToo) {
        if (viz instanceof CrawlListener) {
            crawler.removeCrawlListener((CrawlListener)viz);
        }
        if (linksToo && viz instanceof LinkListener) {
            crawler.removeLinkListener((LinkListener)viz);
        }
    }

    void showVisualization(Object viz) {
        if (viz == this.graph) {
            this.graph.start();
        }
    }

    void hideVisualization(Object viz) {
        if (viz == this.graph) {
            this.graph.stop();
        }
    }

    void tearoffVisualizations() {
        if (this.tornOff) {
            return;
        }
        if (this.vizFrame == null) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.vizFrame = new WorkbenchVizFrame(this);
            this.vizFrame.setForeground(this.getForeground());
            this.vizFrame.setBackground(this.getBackground());
            this.vizFrame.setFont(this.getFont());
            this.vizFrame.setTitle("Visualization: " + (this.crawler != null ? this.crawler.getName() : ""));
            this.vizFrame.setLayout(new GridLayout(1, 1));
            this.vizFrame.reshape(0, 0, Math.min(550, screen.width), screen.height / 2);
        }
        this.remove(this.vizPanel);
        this.setLayout(new GridLayout(1, 1));
        this.validate();
        this.vizFrame.add(this.vizPanel);
        Workbench.setVisible(this.vizFrame, true);
        this.vizPanel.tearoffButton.setLabel("Glue Back");
        this.tornOff = true;
    }

    void dockVisualizations() {
        if (!this.tornOff) {
            return;
        }
        Workbench.setVisible(this.vizFrame, false);
        this.vizFrame.remove(this.vizPanel);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.vizPanel);
        this.validate();
        this.vizPanel.tearoffButton.setLabel("Tear Off");
        this.tornOff = false;
    }

    void newCrawler() {
        this.setCrawler(Workbench.makeDefaultCrawler());
        this.currentFilename = "";
    }

    void createCrawler(String className) {
        if ((className == null || className.length() == 0) && (className = PopupDialog.ask(this.workbenchPanel, "New Crawler", "Create a Crawler of class:", this.crawler.getClass().getName())) == null) {
            return;
        }
        try {
            Class<?> crawlerClass = Class.forName(className);
            Crawler newCrawler = (Crawler)crawlerClass.newInstance();
            this.setCrawler(newCrawler);
            this.currentFilename = "";
        }
        catch (Exception e) {
            PopupDialog.warn(this.workbenchPanel, "Error", e.toString());
            return;
        }
    }

    void openCrawler() {
        String fn = PopupDialog.askFilename(this.workbenchPanel, "Open Crawler", "", true);
        if (fn != null) {
            this.openCrawler(fn);
        }
    }

    void openCrawler(String filename) {
        try {
            this.setCrawler(Workbench.loadCrawler(Access.getAccess().readFile(new File(filename))));
            this.currentFilename = filename;
        }
        catch (Exception e) {
            PopupDialog.warn(this.workbenchPanel, "Error", e.toString());
        }
    }

    void openCrawler(URL url) {
        try {
            this.setCrawler(Workbench.loadCrawler(Access.getAccess().openConnection(url).getInputStream()));
            this.currentFilename = "";
        }
        catch (Exception e) {
            PopupDialog.warn(this.workbenchPanel, "Error", e.toString());
        }
    }

    static Crawler loadCrawler(InputStream stream) throws Exception {
        ObjectInputStream in = new ObjectInputStream(stream);
        Crawler loadedCrawler = (Crawler)in.readObject();
        in.close();
        return loadedCrawler;
    }

    void saveCrawler() {
        String fn = PopupDialog.askFilename(this.workbenchPanel, "Save Crawler As", this.currentFilename, true);
        if (fn != null) {
            this.saveCrawler(fn);
        }
    }

    void saveCrawler(String filename) {
        this.configureCrawler();
        try {
            ObjectOutputStream out = new ObjectOutputStream(Access.getAccess().writeFile(new File(filename), false));
            out.writeObject(this.crawler);
            out.close();
            this.currentFilename = filename;
        }
        catch (Exception e) {
            PopupDialog.warn(this.workbenchPanel, "Error", e.toString());
        }
    }

    void configureCrawler() {
        if (this.advancedMode) {
            this.crawlerEditor.getCrawler();
            this.classifierListEditor.getCrawler();
            this.crawler.setDownloadParameters(this.downloadParametersEditor.getDownloadParameters());
            if (this.advancedMode) {
                this.crawler.setLinkPredicate(this.linkPredicateEditor.getLinkPredicate());
                this.crawler.setPagePredicate(this.pagePredicateEditor.getPagePredicate());
                this.crawler.setAction(this.actionEditor.getAction());
            }
        } else {
            this.simpleCrawlerEditor.getCrawler();
        }
    }

    void enableButtons(boolean fStart, boolean fPause, boolean fStop, boolean fClear) {
        Workbench.setEnabled(this.startButton, fStart);
        Workbench.setEnabled(this.pauseButton, fPause);
        Workbench.setEnabled(this.stopButton, fStop);
        Workbench.setEnabled(this.clearButton, fClear);
    }

    public void setCrawler(Crawler _crawler) {
        if (this.crawler != _crawler) {
            if (this.crawler != null) {
                this.clear();
                this.disconnectVisualization(this.crawler, this, false);
                this.disconnectVisualization(this.crawler, this.graph, true);
                this.disconnectVisualization(this.crawler, this.outline, true);
                this.disconnectVisualization(this.crawler, this.statistics, false);
                this.disconnectVisualization(this.crawler, this.logger, true);
            }
            this.connectVisualization(_crawler, this, false);
            this.connectVisualization(_crawler, this.graph, true);
            this.connectVisualization(_crawler, this.outline, true);
            this.connectVisualization(_crawler, this.statistics, false);
            this.connectVisualization(_crawler, this.logger, true);
        }
        this.crawler = _crawler;
        String name = this.crawler.getName();
        if (this.workbenchFrame != null) {
            this.workbenchFrame.setTitle("Crawler Workbench: " + name);
        }
        if (this.vizFrame != null) {
            this.vizFrame.setTitle("Visualization: " + name);
        }
        if (this.advancedMode) {
            this.crawlerEditor.setCrawler(this.crawler);
            this.classifierListEditor.setCrawler(this.crawler);
            this.downloadParametersEditor.setDownloadParameters(this.crawler.getDownloadParameters());
            if (this.advancedMode) {
                this.linkPredicateEditor.setLinkPredicate(this.crawler.getLinkPredicate());
                this.pagePredicateEditor.setPagePredicate(this.crawler.getPagePredicate());
                this.actionEditor.setAction(this.crawler.getAction());
            }
        } else {
            this.simpleCrawlerEditor.setCrawler(this.crawler);
        }
        if (this.advancedMode) {
            this.showAdvancedTabs();
        } else {
            this.showSimpleTabs();
        }
    }

    public Crawler getCrawler() {
        return this.crawler;
    }

    private void showAdvancedTabs() {
        if (this.configPanel.countTabs() != 5) {
            this.configPanel.removeAllTabPanels();
            this.configPanel.addTabPanel("Crawl", true, this.crawlPanel);
            this.configPanel.addTabPanel("Links", true, this.linksPanel);
            this.configPanel.addTabPanel("Pages", true, this.actionPanel);
            this.configPanel.addTabPanel("Classifiers", true, this.classifiersPanel);
            this.configPanel.addTabPanel("Limits", true, this.limitsPanel);
        }
    }

    private void showSimpleTabs() {
        if (this.configPanel.countTabs() != 1) {
            this.configPanel.removeAllTabPanels();
            this.configPanel.addTabPanel("Crawl", true, this.simplePanel);
        }
    }

    public void start() {
        this.configureCrawler();
        if (this.crawler.getState() == 1) {
            this.crawler.clear();
        }
        Thread thread = new Thread((Runnable)this.crawler, this.crawler.getName());
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.crawler.stop();
    }

    public void pause() {
        this.crawler.pause();
    }

    public void clear() {
        this.crawler.clear();
    }

    public void started(CrawlEvent event) {
        this.enableButtons(false, true, true, false);
    }

    public void stopped(CrawlEvent event) {
        this.enableButtons(true, false, false, true);
    }

    public void cleared(CrawlEvent event) {
        this.enableButtons(true, false, false, false);
    }

    public void timedOut(CrawlEvent event) {
        this.enableButtons(true, false, false, true);
    }

    public void paused(CrawlEvent event) {
        this.enableButtons(true, false, true, true);
    }

    public static void main(String[] args) throws Exception {
        Workbench w = args.length == 0 ? new Workbench() : new Workbench(args[0]);
        w.setAllowExit(true);
        Frame f = w.makeFrame();
        f.show();
    }

    static {
        MARGIN = 8;
    }
}

