/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Panel;
import websphinx.LinkPredicate;
import websphinx.Regexp;
import websphinx.Tagexp;
import websphinx.Wildcard;
import websphinx.workbench.ContentPredicate;
import websphinx.workbench.DualPredicate;
import websphinx.workbench.FeatureChoice;
import websphinx.workbench.LabelPredicate;
import websphinx.workbench.LinkFeatureArgs;
import websphinx.workbench.Script;
import websphinx.workbench.URLPredicate;

class LinkFeatureChoice
extends FeatureChoice {
    LinkFeatureArgs args = new LinkFeatureArgs();
    static final String NULL_FEATURE = "all links";
    static final String URL_FEATURE = "URL";
    static final String HTML_FEATURE = "HTML tag";
    static final String TEXT_FEATURE = "anchor text";
    static final String LABEL_FEATURE = "labels";
    static final String SCRIPT_FEATURE = "script";

    public LinkFeatureChoice() {
        this.addItem(NULL_FEATURE);
        this.addItem(LABEL_FEATURE);
        this.addItem(URL_FEATURE);
        this.addItem(TEXT_FEATURE);
        this.addItem(HTML_FEATURE);
        this.addItem(SCRIPT_FEATURE);
    }

    public Panel getArgs() {
        return this.args;
    }

    public void setLinkPredicate(LinkPredicate pred) {
        LinkPredicate neg = null;
        if (pred instanceof DualPredicate) {
            neg = (LinkPredicate)((DualPredicate)pred).getNegativePredicate();
            pred = (LinkPredicate)((DualPredicate)pred).getPositivePredicate();
        }
        if (pred == null) {
            this.select(NULL_FEATURE);
        } else if (pred instanceof URLPredicate) {
            URLPredicate urlpred = (URLPredicate)pred;
            URLPredicate urlneg = (URLPredicate)neg;
            this.select(URL_FEATURE);
            this.args.setURLPattern(urlpred.getPattern().toString());
            this.args.setURLNegPattern(urlneg != null ? urlneg.getPattern().toString() : "");
        } else if (pred instanceof ContentPredicate) {
            ContentPredicate contpred = (ContentPredicate)pred;
            ContentPredicate contneg = (ContentPredicate)neg;
            if (contpred.getOverHTML()) {
                this.select(HTML_FEATURE);
                this.args.setHTMLPattern(contpred.getPattern().toString());
                this.args.setHTMLNegPattern(contneg != null ? contneg.getPattern().toString() : "");
            } else {
                this.select(TEXT_FEATURE);
                this.args.setTextPattern(contpred.getPattern().toString());
                this.args.setTextNegPattern(contneg != null ? contneg.getPattern().toString() : "");
            }
        } else if (pred instanceof LabelPredicate) {
            LabelPredicate labelpred = (LabelPredicate)pred;
            this.select(LABEL_FEATURE);
            this.args.setOrTerms(labelpred.getOrTerms());
            this.args.setLabels(labelpred.getLabels());
        } else if (pred instanceof Script) {
            Script script = (Script)pred;
            this.select(SCRIPT_FEATURE);
            this.args.setScript(script.getScript());
        } else {
            this.select(NULL_FEATURE);
        }
    }

    public LinkPredicate getLinkPredicate() {
        String feat = this.getSelectedItem();
        if (feat.equals(URL_FEATURE)) {
            return LinkFeatureChoice.makeSingleOrDual(new URLPredicate(new Wildcard(this.args.getURLPattern())), this.args.getURLNegPattern().length() == 0 ? null : new URLPredicate(new Wildcard(this.args.getURLNegPattern())));
        }
        if (feat.equals(HTML_FEATURE)) {
            return LinkFeatureChoice.makeSingleOrDual(new ContentPredicate(new Tagexp(this.args.getHTMLPattern()), true), this.args.getHTMLNegPattern().length() == 0 ? null : new ContentPredicate(new Tagexp(this.args.getHTMLNegPattern()), true));
        }
        if (feat.equals(TEXT_FEATURE)) {
            return LinkFeatureChoice.makeSingleOrDual(new ContentPredicate(new Regexp(this.args.getTextPattern()), false), this.args.getTextNegPattern().length() == 0 ? null : new ContentPredicate(new Regexp(this.args.getTextNegPattern()), false));
        }
        if (feat.equals(LABEL_FEATURE)) {
            return new LabelPredicate(this.args.getLabels(), this.args.getOrTerms());
        }
        if (feat.equals(SCRIPT_FEATURE)) {
            return new Script(this.args.getScript(), true);
        }
        return null;
    }

    private static LinkPredicate makeSingleOrDual(LinkPredicate positive, LinkPredicate negative) {
        return negative == null ? positive : new DualPredicate(positive, negative);
    }

    static {
        NULL_FEATURE = NULL_FEATURE;
        URL_FEATURE = URL_FEATURE;
        HTML_FEATURE = HTML_FEATURE;
        TEXT_FEATURE = TEXT_FEATURE;
        LABEL_FEATURE = LABEL_FEATURE;
        SCRIPT_FEATURE = SCRIPT_FEATURE;
    }
}

