/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Checkbox;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.TextField;
import rcm.awt.ClosableFrame;
import rcm.awt.Constrain;
import websphinx.workbench.GraphLayout;

class GraphLayoutControlPanel
extends ClosableFrame {
    GraphLayout gl;
    Checkbox automatic;
    Scrollbar threshold;
    Scrollbar restLength;
    Scrollbar springConstant;
    Scrollbar nodeCharge;
    TextField thresholdText;
    TextField restLengthText;
    TextField springConstantText;
    TextField nodeChargeText;

    public GraphLayoutControlPanel(GraphLayout graphLayout) {
        super("Graph Layout Control Panel", true);
        this.gl = graphLayout;
        this.setLayout(new GridBagLayout());
        this.automatic = new Checkbox("Automatic layout");
        Constrain.add(this, this.automatic, Constrain.labelLike(0, 0, 2));
        this.automatic.setState(true);
        Constrain.add(this, new Label("Threshold:", 0), Constrain.labelLike(0, 1));
        this.thresholdText = new TextField(String.valueOf(this.gl.getThreshold()));
        Constrain.add(this, this.thresholdText, Constrain.fieldLike(1, 1));
        this.threshold = new Scrollbar(0, (int)this.gl.getThreshold(), 50, 0, 1000);
        Constrain.add(this, this.threshold, Constrain.fieldLike(0, 2, 2));
        Constrain.add(this, new Label("Rest length:", 0), Constrain.labelLike(0, 3));
        this.restLengthText = new TextField(String.valueOf(this.gl.getRestLength()));
        Constrain.add(this, this.restLengthText, Constrain.fieldLike(1, 3));
        this.restLength = new Scrollbar(0, (int)this.gl.getRestLength(), 50, 0, 1000);
        Constrain.add(this, this.restLength, Constrain.fieldLike(0, 4, 2));
        Constrain.add(this, new Label("Spring constant:", 0), Constrain.labelLike(0, 5));
        this.springConstantText = new TextField(String.valueOf(this.gl.getSpringConstant()));
        Constrain.add(this, this.springConstantText, Constrain.fieldLike(1, 5));
        this.springConstant = new Scrollbar(0, (int)this.gl.getSpringConstant(), 50, 0, 1000);
        Constrain.add(this, this.springConstant, Constrain.fieldLike(0, 6, 2));
        Constrain.add(this, new Label("Node charge:", 0), Constrain.labelLike(0, 7));
        this.nodeChargeText = new TextField(String.valueOf(Math.sqrt(this.gl.getNodeCharge())));
        Constrain.add(this, this.nodeChargeText, Constrain.fieldLike(1, 7));
        this.nodeCharge = new Scrollbar(0, (int)Math.sqrt(this.gl.getNodeCharge()), 50, 0, 1000);
        Constrain.add(this, this.nodeCharge, Constrain.fieldLike(0, 8, 2));
        this.pack();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.automatic) {
            this.gl.setAutomaticLayout(this.automatic.getState());
        } else if (event.target == this.threshold) {
            this.gl.setThreshold(((Integer)event.arg).intValue());
        } else if (event.target == this.restLength) {
            this.gl.setRestLength(((Integer)event.arg).intValue());
        } else if (event.target == this.springConstant) {
            this.gl.setSpringConstant(((Integer)event.arg).intValue());
        } else if (event.target == this.restLength) {
            int v = (Integer)event.arg;
            this.gl.setNodeCharge(v * v);
        } else {
            return super.handleEvent(event);
        }
        return true;
    }
}

