/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tagexp;
import websphinx.searchengine.Search;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class HotBot
implements SearchEngine {
    static Pattern patTitle = new Regexp("^");
    static Pattern patCount = new Regexp("Returned <B>(\\d+)</b> matches");
    static Pattern patNoHits = new Regexp("Sorry -- your search yielded no results");
    static Pattern patResult = new Tagexp("<td><b>(?{rank})</b></td><td>(?:<a><img></a>)?(?{link}<a>(?{title})</a>)</td></tr><tr><td><font>(?{score})</font></td><td>(?{description})<br></td>");
    static Pattern patMoreLink = new Tagexp("<input type=image name=act.next>");
    public static final float priority = 0.0f;

    public void classify(Page page) {
        String title = page.getTitle();
        if (title != null && title.startsWith("HotBot results:")) {
            page.setObjectLabel("searchengine.source", this);
            Region count = patCount.oneMatch(page);
            if (count != null) {
                page.setField("searchengine.count", count.getField("0"));
            }
            Region[] results = patResult.allMatches(page);
            Region[] ser = new SearchEngineResult[results.length];
            int i = 0;
            while (i < results.length) {
                ser[i] = new SearchEngineResult(results[i]);
                ++i;
            }
            page.setFields("searchengine.results", ser);
            PatternMatcher m = patMoreLink.match(page);
            while (m.hasMoreElements()) {
                Link link = (Link)m.nextMatch();
                link.setLabel("searchengine.more-results");
                link.setLabel("hyperlink");
            }
        } else {
            System.err.println("not a HotBot page");
        }
    }

    public float getPriority() {
        return 0.0f;
    }

    public URL makeQuery(String keywords) {
        try {
            return new URL("http://www.search.hotbot.com/hResult.html/?SM=MC&MT=" + URLEncoder.encode(keywords) + "&DV=7&RG=.com&DC=10&DE=2&OPs=MDRTP&_v=2&DU=days&SW=web");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error");
        }
    }

    public int getResultsPerPage() {
        return 10;
    }

    public static Search search(String keywords) {
        return new Search(new HotBot(), keywords);
    }

    public static Search search(String keywords, int maxResults) {
        return new Search(new HotBot(), keywords, maxResults);
    }

    static {
        priority = 0.0f;
    }
}

