/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import rcm.util.Prioritized;
import websphinx.DownloadParameters;
import websphinx.Element;
import websphinx.HTMLParser;
import websphinx.Page;
import websphinx.Tag;

public class Link
extends Element
implements Prioritized {
    protected URL url;
    private String directory;
    private String filename;
    private String query;
    private String ref;
    private Page page;
    private int depth;
    private String text = "";
    private int status = 0;
    private float priority;
    private DownloadParameters dp;
    public static final int GET = 0;
    public static final int POST = 1;

    public Link(Tag startTag, Tag endTag, URL base) throws MalformedURLException {
        super(startTag, endTag);
        this.url = this.urlFromHref(startTag, base);
        this.depth = startTag.getSource().getDepth() + 1;
    }

    public Link(URL url) {
        super(new Tag(new Page(""), 0, 0, "", true), null);
        this.url = url;
        this.depth = 0;
    }

    public Link(File file) throws MalformedURLException {
        this(Link.FileToURL(file));
    }

    public Link(String href) throws MalformedURLException {
        this(new URL(href));
        this.depth = 0;
    }

    public void discardContent() {
        this.parent = null;
        this.child = null;
        this.sibling = null;
    }

    public void disconnect() {
        this.page = null;
        this.status = 0;
    }

    public int getDepth() {
        return this.depth;
    }

    public URL getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.getURL().getProtocol();
    }

    public String getHost() {
        return this.getURL().getHost();
    }

    public int getPort() {
        return this.getURL().getPort();
    }

    public String getFile() {
        return this.getURL().getFile();
    }

    public String getDirectory() {
        if (this.directory == null) {
            this.parseURL();
        }
        return this.directory;
    }

    public String getFilename() {
        if (this.filename == null) {
            this.parseURL();
        }
        return this.filename;
    }

    public String getQuery() {
        if (this.query == null) {
            this.parseURL();
        }
        return this.query;
    }

    public String getRef() {
        if (this.ref == null) {
            this.parseURL();
        }
        return this.ref;
    }

    public URL getPageURL() {
        return Link.getPageURL(this.getURL());
    }

    public static URL getPageURL(URL url) {
        String href = url.toExternalForm();
        int i = href.indexOf(35);
        try {
            return i != -1 ? new URL(href.substring(0, i)) : url;
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public URL getServiceURL() {
        return Link.getServiceURL(this.getURL());
    }

    public static URL getServiceURL(URL url) {
        String href = url.toExternalForm();
        int i = href.indexOf(63);
        try {
            return i != -1 && url.getProtocol().equals("http") ? new URL(href.substring(0, i)) : Link.getPageURL(url);
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public URL getDirectoryURL() {
        return Link.getDirectoryURL(this.getURL());
    }

    public static URL getDirectoryURL(URL url) {
        String file = url.getFile();
        int qmark = file.indexOf(63);
        if (qmark == -1 || !url.getProtocol().equals("http")) {
            qmark = file.length();
        }
        int pivot = file.lastIndexOf(47, Math.max(qmark - 1, 0));
        try {
            if (pivot == -1) {
                return new URL(url, "/");
            }
            if (pivot == file.length() - 1) {
                return url;
            }
            return new URL(url, file.substring(0, pivot + 1));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public URL getParentURL() {
        return Link.getParentURL(this.getURL());
    }

    public static URL getParentURL(URL url) {
        URL dirURL = Link.getDirectoryURL(url);
        if (!dirURL.equals(url)) {
            return dirURL;
        }
        String dir = dirURL.getFile();
        int lastSlash = dir.length() - 1;
        if (lastSlash == 0) {
            return dirURL;
        }
        int penultSlash = dir.lastIndexOf(47, lastSlash - 1);
        if (penultSlash == -1) {
            return dirURL;
        }
        try {
            return new URL(url, dir.substring(0, penultSlash + 1));
        }
        catch (MalformedURLException e) {
            return dirURL;
        }
    }

    public static String relativeTo(URL here, URL there) {
        if (here == null) {
            return there.toString();
        }
        if (here.getProtocol().equals(there.getProtocol()) && here.getHost().equals(there.getHost()) && here.getPort() == there.getPort()) {
            String fn = Link.relativeTo(here.getFile(), there.getFile());
            String ref = there.getRef();
            return ref != null ? fn + ref : fn;
        }
        return there.toString();
    }

    public static String relativeTo(URL here, String there) {
        if (here == null) {
            return there;
        }
        try {
            return Link.relativeTo(here, new URL(here, there));
        }
        catch (MalformedURLException e) {
            return there;
        }
    }

    private static String relativeTo(String here, String there) {
        int i;
        StringBuffer result = new StringBuffer();
        int lcp = 0;
        while (true) {
            i = here.indexOf(47, lcp);
            int j = there.indexOf(47, lcp);
            if (i == -1 || i != j || !here.regionMatches(lcp, there, lcp, i - lcp)) break;
            lcp = i + 1;
        }
        i = here.indexOf(47, lcp);
        while (i != -1) {
            result.append("..");
            result.append('/');
            i = here.indexOf(47, i + 1);
        }
        result.append(there.substring(lcp));
        return result.toString();
    }

    public static URL FileToURL(File file) throws MalformedURLException {
        return new URL("file:" + Link.toURLDelimiters(file.getAbsolutePath()));
    }

    public static File URLToFile(URL url) throws MalformedURLException {
        if (!url.getProtocol().equals("file")) {
            throw new MalformedURLException();
        }
        String path = url.getFile();
        if ((path = path.replace('/', File.separatorChar)).length() > 3 && path.charAt(0) == File.separatorChar && path.charAt(2) == ':' && path.charAt(3) == File.separatorChar) {
            path = path.substring(1);
        }
        return new File(path);
    }

    public static String toURLDelimiters(String path) {
        if (!(path = path.replace('\\', '/')).startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public int getMethod() {
        return 0;
    }

    public String toURL() {
        return this.getURL().toExternalForm();
    }

    public String toDescription() {
        return (this.text.length() > 0 ? this.text + " " : "") + "[" + this.getURL() + "]";
    }

    public String toText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    private void parseURL() {
        String protocol = this.getProtocol();
        String file = this.getFile();
        int qmark = file.indexOf(63);
        if (qmark == -1 || !protocol.equals("http")) {
            this.query = "";
            qmark = file.length();
        } else {
            this.query = file.substring(qmark + 1);
            file = file.substring(0, qmark);
        }
        int slash = file.lastIndexOf(47, Math.max(qmark - 1, 0));
        if (slash == -1) {
            this.directory = "";
            this.filename = file;
        } else {
            this.directory = file.substring(0, slash + 1);
            this.filename = file.substring(slash + 1);
        }
        this.ref = this.getURL().getRef();
        if (this.ref == null) {
            this.ref = "";
        }
    }

    protected URL urlFromHref(Tag tag, URL base) throws MalformedURLException {
        String codebase;
        String hrefAttr = Link.getHrefAttributeName(tag);
        String href = tag.getHTMLAttribute(hrefAttr);
        if (tag.tagName == Tag.APPLET && (codebase = tag.getHTMLAttribute("codebase")) != null) {
            base = new URL(base, codebase);
        }
        return new URL(base, href);
    }

    public Tag replaceHref(String newHref) {
        String hrefAttrName;
        int i;
        Tag tag = this.startTag;
        if (tag.getTagName() == Tag.APPLET && (i = newHref.lastIndexOf(47)) != -1) {
            tag = this.startTag.replaceHTMLAttribute("codebase", newHref.substring(0, i + 1));
            newHref = newHref.substring(i + 1);
        }
        if ((hrefAttrName = Link.getHrefAttributeName(tag)) == null) {
            return tag;
        }
        return tag.replaceHTMLAttribute(hrefAttrName, newHref);
    }

    private static String getHrefAttributeName(Tag tag) {
        return (String)HTMLParser.linktag.get(tag.getTagName());
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int event) {
        this.status = event;
    }

    public float getPriority() {
        return this.priority;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public DownloadParameters getDownloadParameters() {
        return this.dp;
    }

    public void setDownloadParameters(DownloadParameters dp) {
        this.dp = dp;
    }

    static {
        GET = 0;
        POST = 1;
    }
}

